/*
 * Copyright (c) 2024, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

// Generated by jextract

package jdk.internal.ffi.generated.timespec;

import java.lang.foreign.*;
import java.util.function.*;

import static java.lang.foreign.MemoryLayout.PathElement.*;
import static java.lang.foreign.ValueLayout.*;

/**
 * {@snippet lang=c :
 * struct timespec {
 *     __darwin_time_t tv_sec;
 *     long tv_nsec;
 * }
 * }
 */
@SuppressWarnings("restricted")
public class timespec {

    timespec() {
        // Should not be called directly
    }

    private static final GroupLayout $LAYOUT = MemoryLayout.structLayout(
        timespec_h.C_LONG.withName("tv_sec"),
        timespec_h.C_LONG.withName("tv_nsec")
    ).withName("timespec");

    /**
     * The layout of this struct
     */
    public static final GroupLayout layout() {
        return $LAYOUT;
    }

    private static final OfLong tv_sec$LAYOUT = (OfLong)$LAYOUT.select(groupElement("tv_sec"));

    /**
     * Layout for field:
     * {@snippet lang=c :
     * __darwin_time_t tv_sec
     * }
     */
    public static final OfLong tv_sec$layout() {
        return tv_sec$LAYOUT;
    }

    private static final long tv_sec$OFFSET = $LAYOUT.byteOffset(groupElement("tv_sec"));

    /**
     * Offset for field:
     * {@snippet lang=c :
     * __darwin_time_t tv_sec
     * }
     */
    public static final long tv_sec$offset() {
        return tv_sec$OFFSET;
    }

    /**
     * Getter for field:
     * {@snippet lang=c :
     * __darwin_time_t tv_sec
     * }
     */
    public static long tv_sec(MemorySegment struct) {
        return struct.get(tv_sec$LAYOUT, tv_sec$OFFSET);
    }

    /**
     * Setter for field:
     * {@snippet lang=c :
     * __darwin_time_t tv_sec
     * }
     */
    public static void tv_sec(MemorySegment struct, long fieldValue) {
        struct.set(tv_sec$LAYOUT, tv_sec$OFFSET, fieldValue);
    }

    private static final OfLong tv_nsec$LAYOUT = (OfLong)$LAYOUT.select(groupElement("tv_nsec"));

    /**
     * Layout for field:
     * {@snippet lang=c :
     * long tv_nsec
     * }
     */
    public static final OfLong tv_nsec$layout() {
        return tv_nsec$LAYOUT;
    }

    private static final long tv_nsec$OFFSET = $LAYOUT.byteOffset(groupElement("tv_nsec"));

    /**
     * Offset for field:
     * {@snippet lang=c :
     * long tv_nsec
     * }
     */
    public static final long tv_nsec$offset() {
        return tv_nsec$OFFSET;
    }

    /**
     * Getter for field:
     * {@snippet lang=c :
     * long tv_nsec
     * }
     */
    public static long tv_nsec(MemorySegment struct) {
        return struct.get(tv_nsec$LAYOUT, tv_nsec$OFFSET);
    }

    /**
     * Setter for field:
     * {@snippet lang=c :
     * long tv_nsec
     * }
     */
    public static void tv_nsec(MemorySegment struct, long fieldValue) {
        struct.set(tv_nsec$LAYOUT, tv_nsec$OFFSET, fieldValue);
    }

    /**
     * Obtains a slice of {@code arrayParam} which selects the array element at {@code index}.
     * The returned segment has address {@code arrayParam.address() + index * layout().byteSize()}
     */
    public static MemorySegment asSlice(MemorySegment array, long index) {
        return array.asSlice(layout().byteSize() * index);
    }

    /**
     * The size (in bytes) of this struct
     */
    public static long sizeof() { return layout().byteSize(); }

    /**
     * Allocate a segment of size {@code layout().byteSize()} using {@code allocator}
     */
    public static MemorySegment allocate(SegmentAllocator allocator) {
        return allocator.allocate(layout());
    }

    /**
     * Allocate an array of size {@code elementCount} using {@code allocator}.
     * The returned segment has size {@code elementCount * layout().byteSize()}.
     */
    public static MemorySegment allocateArray(long elementCount, SegmentAllocator allocator) {
        return allocator.allocate(MemoryLayout.sequenceLayout(elementCount, layout()));
    }

    /**
     * Reinterprets {@code addr} using target {@code arena} and {@code cleanupAction} (if any).
     * The returned segment has size {@code layout().byteSize()}
     */
    public static MemorySegment reinterpret(MemorySegment addr, Arena arena, Consumer<MemorySegment> cleanup) {
        return reinterpret(addr, 1, arena, cleanup);
    }

    /**
     * Reinterprets {@code addr} using target {@code arena} and {@code cleanupAction} (if any).
     * The returned segment has size {@code elementCount * layout().byteSize()}
     */
    public static MemorySegment reinterpret(MemorySegment addr, long elementCount, Arena arena, Consumer<MemorySegment> cleanup) {
        return addr.reinterpret(layout().byteSize() * elementCount, arena, cleanup);
    }
}
