/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;

public class XMLReconcilingStrategy
extends SpellingReconcileStrategy {
    public XMLReconcilingStrategy(ISourceViewer viewer) {
        super(viewer, EditorsUI.getSpellingService());
    }

    public void reconcile(IRegion region) {
        this.deleteAllAnnotations(region);
        super.reconcile(region);
    }

    private void deleteAllAnnotations(IRegion region) {
        IAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return;
        }
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            SpellingAnnotation spellingAnnotation;
            Position position;
            Annotation annotation = (Annotation)iter.next();
            if (!(annotation instanceof SpellingAnnotation) || !(position = model.getPosition((Annotation)(spellingAnnotation = (SpellingAnnotation)annotation))).overlapsWith(region.getOffset(), region.getLength())) continue;
            model.removeAnnotation((Annotation)spellingAnnotation);
        }
    }

    private void deleteNonstringSpellingAnnotations(Iterator<SpellingAnnotation> iter) {
        if (!(this.getDocument() instanceof IDocumentExtension3)) {
            return;
        }
        IDocumentExtension3 document = (IDocumentExtension3)this.getDocument();
        IDocumentPartitioner docPartitioner = document.getDocumentPartitioner("__xml_string");
        IDocumentPartitioner pdeXMLPartitioner = document.getDocumentPartitioner("_pde_xml_partitioning");
        IAnnotationModel model = this.getAnnotationModel();
        while (iter.hasNext()) {
            SpellingAnnotation annotation = iter.next();
            if (!(annotation instanceof SpellingAnnotation)) continue;
            SpellingAnnotation spellingAnnotation = annotation;
            Position position = model.getPosition((Annotation)spellingAnnotation);
            String docContentType = docPartitioner.getContentType(position.getOffset());
            String pdeXMLContentType = pdeXMLPartitioner.getContentType(position.getOffset());
            if (("__xml_string".equalsIgnoreCase(docContentType) || "__custom_tag".equalsIgnoreCase(docContentType)) && (!"__custom_tag".equalsIgnoreCase(docContentType) || !"__xml_tag".equalsIgnoreCase(pdeXMLContentType))) continue;
            model.removeAnnotation((Annotation)spellingAnnotation);
        }
    }

    protected ISpellingProblemCollector createSpellingProblemCollector() {
        IAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return null;
        }
        return new SpellingProblemCollector(model);
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        private IAnnotationModel fAnnotationModel;
        private Map<SpellingAnnotation, Position> fAddAnnotations;
        private Object fLockObject;

        public SpellingProblemCollector(IAnnotationModel annotationModel) {
            Assert.isLegal((annotationModel != null ? 1 : 0) != 0);
            this.fAnnotationModel = annotationModel;
            this.fLockObject = this.fAnnotationModel instanceof ISynchronizable ? ((ISynchronizable)this.fAnnotationModel).getLockObject() : this.fAnnotationModel;
        }

        public void accept(SpellingProblem problem) {
            this.fAddAnnotations.put(new SpellingAnnotation(problem), new Position(problem.getOffset(), problem.getLength()));
        }

        public void beginCollecting() {
            this.fAddAnnotations = new HashMap<SpellingAnnotation, Position>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endCollecting() {
            Object object = this.fLockObject;
            synchronized (object) {
                for (SpellingAnnotation annotation : this.fAddAnnotations.keySet()) {
                    this.fAnnotationModel.addAnnotation((Annotation)annotation, this.fAddAnnotations.get(annotation));
                }
                XMLReconcilingStrategy.this.deleteNonstringSpellingAnnotations(this.fAddAnnotations.keySet().iterator());
            }
            this.fAddAnnotations = null;
        }
    }
}

