/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProcessor;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocCompletionProcessor;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ContentAssistPreference {
    private static final String AUTOACTIVATION = "content_assist_autoactivation";
    private static final String AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    private static final String PARAMETERS_FOREGROUND = "content_assist_parameters_foreground";
    private static final String PARAMETERS_BACKGROUND = "content_assist_parameters_background";
    private static final String AUTOINSERT = "content_assist_autoinsert";
    private static final String AUTOACTIVATION_TRIGGERS_JAVA = "content_assist_autoactivation_triggers_java";
    private static final String AUTOACTIVATION_TRIGGERS_JAVADOC = "content_assist_autoactivation_triggers_javadoc";
    private static final String SHOW_VISIBLE_PROPOSALS = "content_assist_show_visible_proposals";
    private static final String CASE_SENSITIVITY = "content_assist_case_sensitivity";
    private static final String FILL_METHOD_ARGUMENTS = "content_assist_fill_method_arguments";
    private static final String PREFIX_COMPLETION = "content_assist_prefix_completion";
    private static final String USE_COLORED_LABELS = "USE_COLORED_LABELS";

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    private static Color getColor(IPreferenceStore store, String key) {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return ContentAssistPreference.getColor(store, key, textTools.getColorManager());
    }

    private static JavaCompletionProcessor getJavaProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (p instanceof JavaCompletionProcessor) {
            return (JavaCompletionProcessor)p;
        }
        return null;
    }

    private static JavadocCompletionProcessor getJavaDocProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__java_javadoc");
        if (p instanceof JavadocCompletionProcessor) {
            return (JavadocCompletionProcessor)p;
        }
        return null;
    }

    private static void configureJavaProcessor(ContentAssistant assistant, IPreferenceStore store) {
        JavaCompletionProcessor jcp = ContentAssistPreference.getJavaProcessor(assistant);
        if (jcp == null) {
            return;
        }
        String triggers = store.getString(AUTOACTIVATION_TRIGGERS_JAVA);
        if (triggers != null) {
            jcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        boolean enabled = store.getBoolean(SHOW_VISIBLE_PROPOSALS);
        jcp.restrictProposalsToVisibility(enabled);
        enabled = store.getBoolean(CASE_SENSITIVITY);
        jcp.restrictProposalsToMatchingCases(enabled);
    }

    private static void configureJavaDocProcessor(ContentAssistant assistant, IPreferenceStore store) {
        JavadocCompletionProcessor jdcp = ContentAssistPreference.getJavaDocProcessor(assistant);
        if (jdcp == null) {
            return;
        }
        String triggers = store.getString(AUTOACTIVATION_TRIGGERS_JAVADOC);
        if (triggers != null) {
            jdcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        boolean enabled = store.getBoolean(CASE_SENSITIVITY);
        jdcp.restrictProposalsToMatchingCases(enabled);
    }

    public static void configure(ContentAssistant assistant, IPreferenceStore store) {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        IColorManager manager = textTools.getColorManager();
        boolean enabled = store.getBoolean(AUTOACTIVATION);
        assistant.enableAutoActivation(enabled);
        int delay = store.getInt(AUTOACTIVATION_DELAY);
        assistant.setAutoActivationDelay(delay);
        Color c = ContentAssistPreference.getColor(store, PARAMETERS_FOREGROUND, manager);
        assistant.setContextInformationPopupForeground(c);
        assistant.setContextSelectorForeground(c);
        c = ContentAssistPreference.getColor(store, PARAMETERS_BACKGROUND, manager);
        assistant.setContextInformationPopupBackground(c);
        assistant.setContextSelectorBackground(c);
        enabled = store.getBoolean(AUTOINSERT);
        assistant.enableAutoInsert(enabled);
        enabled = store.getBoolean(PREFIX_COMPLETION);
        assistant.enablePrefixCompletion(enabled);
        enabled = store.getBoolean(USE_COLORED_LABELS);
        assistant.enableColoredLabels(enabled);
        ContentAssistPreference.configureJavaProcessor(assistant, store);
        ContentAssistPreference.configureJavaDocProcessor(assistant, store);
    }

    private static void changeJavaProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        JavaCompletionProcessor jcp = ContentAssistPreference.getJavaProcessor(assistant);
        if (jcp == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS_JAVA.equals(key)) {
            String triggers = store.getString(AUTOACTIVATION_TRIGGERS_JAVA);
            if (triggers != null) {
                jcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
            }
        } else if (SHOW_VISIBLE_PROPOSALS.equals(key)) {
            boolean enabled = store.getBoolean(SHOW_VISIBLE_PROPOSALS);
            jcp.restrictProposalsToVisibility(enabled);
        } else if (CASE_SENSITIVITY.equals(key)) {
            boolean enabled = store.getBoolean(CASE_SENSITIVITY);
            jcp.restrictProposalsToMatchingCases(enabled);
        }
    }

    private static void changeJavaDocProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        JavadocCompletionProcessor jdcp = ContentAssistPreference.getJavaDocProcessor(assistant);
        if (jdcp == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS_JAVADOC.equals(key)) {
            String triggers = store.getString(AUTOACTIVATION_TRIGGERS_JAVADOC);
            if (triggers != null) {
                jdcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
            }
        } else if (CASE_SENSITIVITY.equals(key)) {
            boolean enabled = store.getBoolean(CASE_SENSITIVITY);
            jdcp.restrictProposalsToMatchingCases(enabled);
        }
    }

    public static void changeConfiguration(ContentAssistant assistant, IPreferenceStore store, PropertyChangeEvent event) {
        String p = event.getProperty();
        if (AUTOACTIVATION.equals(p)) {
            boolean enabled = store.getBoolean(AUTOACTIVATION);
            assistant.enableAutoActivation(enabled);
        } else if (AUTOACTIVATION_DELAY.equals(p)) {
            int delay = store.getInt(AUTOACTIVATION_DELAY);
            assistant.setAutoActivationDelay(delay);
        } else if (PARAMETERS_FOREGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PARAMETERS_FOREGROUND);
            assistant.setContextInformationPopupForeground(c);
            assistant.setContextSelectorForeground(c);
        } else if (PARAMETERS_BACKGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PARAMETERS_BACKGROUND);
            assistant.setContextInformationPopupBackground(c);
            assistant.setContextSelectorBackground(c);
        } else if (AUTOINSERT.equals(p)) {
            boolean enabled = store.getBoolean(AUTOINSERT);
            assistant.enableAutoInsert(enabled);
        } else if (PREFIX_COMPLETION.equals(p)) {
            boolean enabled = store.getBoolean(PREFIX_COMPLETION);
            assistant.enablePrefixCompletion(enabled);
        } else if (USE_COLORED_LABELS.equals(p)) {
            boolean enabled = store.getBoolean(USE_COLORED_LABELS);
            assistant.enableColoredLabels(enabled);
        }
        ContentAssistPreference.changeJavaProcessor(assistant, store, p);
        ContentAssistPreference.changeJavaDocProcessor(assistant, store, p);
    }

    public static boolean fillArgumentsOnMethodCompletion(IPreferenceStore store) {
        return store.getBoolean(FILL_METHOD_ARGUMENTS);
    }
}

