/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ocl.business.internal.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.sirius.common.ocl.DslOclPlugin;
import org.eclipse.sirius.common.ocl.business.internal.interpreter.OclCompletionEntry;
import org.eclipse.sirius.common.ocl.tools.Messages;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.IVariableStatusListener;
import org.eclipse.sirius.common.tools.api.interpreter.VariableManager;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;

public class OclInterpreter
implements IInterpreter,
IInterpreterProvider,
IProposalProvider {
    public static final String OCL_DISCRIMINANT = "ocl:";
    private OCL<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> ocl;
    private OCLHelper<EClassifier, ?, ?, Constraint> helper;
    private final VariableManager variables = new VariableManager();
    private final List<IVariableStatusListener> variablesListeners = new LinkedList<IVariableStatusListener>();

    public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
    }

    public void addImport(String dependency) {
    }

    public void clearImports() {
    }

    public void addVariableStatusListener(IVariableStatusListener newListener) {
        this.variablesListeners.add(newListener);
    }

    public void removeVariableStatusListener(IVariableStatusListener listener) {
        this.variablesListeners.remove(listener);
    }

    public void setVariable(String name, Object value) {
        this.variables.setVariable(name, value);
        this.fireVariablesChanged();
    }

    public void unSetVariable(String name) {
        this.variables.unSetVariable(name);
        this.fireVariablesChanged();
    }

    public void clearVariables() {
        this.variables.clearVariables();
        this.fireVariablesChanged();
    }

    public Object getVariable(String name) {
        return this.variables.getVariable(name);
    }

    public Map<String, Object> getVariables() {
        return this.variables.getVariables();
    }

    protected void fireVariablesChanged() {
        for (IVariableStatusListener listener : this.variablesListeners) {
            listener.notifyChanged(this.getVariables());
        }
    }

    public boolean provides(String expression) {
        return expression != null && expression.startsWith(OCL_DISCRIMINANT);
    }

    public void setProperty(Object key, Object value) {
    }

    public Object evaluate(EObject target, String expression) throws EvaluationException {
        return this.internalEvaluate(target, expression);
    }

    public boolean evaluateBoolean(EObject context, String expression) throws EvaluationException {
        Object value = this.evaluate(context, expression);
        boolean result = false;
        if (value instanceof Boolean) {
            result = (Boolean)value;
        } else if (value instanceof String) {
            result = Boolean.parseBoolean((String)value);
        }
        return result;
    }

    public Collection<EObject> evaluateCollection(EObject context, String expression) throws EvaluationException {
        List<EObject> result;
        block4: {
            Object value;
            block5: {
                block3: {
                    value = this.evaluate(context, expression);
                    result = Collections.emptyList();
                    if (!(value instanceof EObject)) break block3;
                    result = new ArrayList(1);
                    result.add((EObject)value);
                    break block4;
                }
                if (!(value instanceof Collection)) break block5;
                result = new ArrayList<EObject>(((Collection)value).size());
                for (Object object : (Collection)value) {
                    if (!(object instanceof EObject)) continue;
                    result.add((EObject)object);
                }
                break block4;
            }
            if (value == null || !value.getClass().isArray()) break block4;
            result = new ArrayList<EObject>(((Object[])value).length);
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof EObject) {
                    result.add((EObject)object);
                }
                ++n2;
            }
        }
        return result;
    }

    public EObject evaluateEObject(EObject context, String expression) throws EvaluationException {
        Object value = this.evaluate(context, expression);
        if (value instanceof EObject) {
            return (EObject)value;
        }
        return null;
    }

    public Integer evaluateInteger(EObject context, String expression) throws EvaluationException {
        Object value = this.evaluate(context, expression);
        Integer result = null;
        if (value instanceof Integer) {
            result = (Integer)value;
        } else if (value instanceof String) {
            try {
                result = new Integer((String)value);
            }
            catch (NumberFormatException nfe) {
                DslOclPlugin.getPlugin().error(Messages.OclInterpreter_OclNotANumber, nfe);
            }
        }
        return result;
    }

    public String evaluateString(EObject context, String expression) throws EvaluationException {
        Object value = this.evaluate(context, expression);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private Object internalEvaluate(EObject context, String expression) throws EvaluationException {
        String exp;
        block7: {
            exp = expression.substring(OCL_DISCRIMINANT.length());
            if (!"".equals(exp)) break block7;
            return null;
        }
        try {
            this.getOCLHelper().setContext((Object)context.eClass());
            for (Map.Entry<String, Object> variable : this.getVariables().entrySet()) {
                Object value = variable.getValue();
                Variable oclVar = EcoreFactory.eINSTANCE.createVariable();
                if (value instanceof Collection) {
                    SequenceType sequence = EcoreFactory.eINSTANCE.createSequenceType();
                    sequence.setElementType((Object)EcorePackage.eINSTANCE.getEObject());
                    oclVar.setType((Object)sequence);
                } else {
                    oclVar.setType((Object)EcorePackage.eINSTANCE.getEObject());
                }
                oclVar.setName(variable.getKey());
                this.getOCLHelper().getOCL().getEnvironment().addElement(oclVar.getName(), (org.eclipse.ocl.expressions.Variable)oclVar, false);
            }
            OCLExpression query = this.getOCLHelper().createQuery(exp);
            Query eval = this.getOCL().createQuery(query);
            for (Map.Entry<String, Object> variable : this.getVariables().entrySet()) {
                eval.getEvaluationEnvironment().add(variable.getKey(), variable.getValue());
            }
            return eval.evaluate((Object)context);
        }
        catch (ParserException pe) {
            throw new EvaluationException((Throwable)pe);
        }
    }

    public OCLHelper<EClassifier, ?, ?, Constraint> getOCLHelper() {
        if (this.helper == null) {
            this.helper = this.getOCL().createOCLHelper();
        }
        return this.helper;
    }

    private OCL<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> getOCL() {
        if (this.ocl == null) {
            this.ocl = OCL.newInstance((EnvironmentFactory)EcoreEnvironmentFactory.INSTANCE);
        }
        return this.ocl;
    }

    public IInterpreter createInterpreter() {
        return new OclInterpreter();
    }

    public void dispose() {
        this.variables.clearVariables();
        this.variablesListeners.clear();
    }

    public void setModelAccessor(ModelAccessor modelAccessor) {
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentContext context) {
        List<ContentProposal> computeCompletionEntry = OclCompletionEntry.computeCompletionEntry(context);
        return computeCompletionEntry;
    }

    public String getPrefix() {
        return OCL_DISCRIMINANT;
    }

    public ContentProposal getNewEmtpyExpression() {
        return new ContentProposal(OCL_DISCRIMINANT, OCL_DISCRIMINANT, Messages.OclInterpreter_NewOclExpression);
    }

    public String getVariablePrefix() {
        return null;
    }

    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentInstanceContext context) {
        String textSoFar;
        String evaluationString;
        if (context != null && context.getTextSoFar() != null && context.getCursorPosition() != -1 && context.getTextSoFar().length() >= context.getCursorPosition() && (evaluationString = (textSoFar = context.getTextSoFar()).substring(0, context.getCursorPosition())).toLowerCase().startsWith(OCL_DISCRIMINANT) && context.getCurrentSelected() != null) {
            this.getOCLHelper().setContext((Object)context.getCurrentSelected().eClass());
            evaluationString = evaluationString.substring(OCL_DISCRIMINANT.length());
            List choices = this.getOCLHelper().getSyntaxHelp(ConstraintKind.INVARIANT, evaluationString);
            if (choices != null && choices.size() > 0) {
                ArrayList<ContentProposal> contentProposals = new ArrayList<ContentProposal>();
                for (Choice choice : choices) {
                    contentProposals.add(new ContentProposal(choice.getName(), String.valueOf(choice.getName()) + " (" + choice.getKind().name() + ")", choice.getDescription()));
                }
                Collections.sort(contentProposals);
                return contentProposals;
            }
        }
        return Collections.emptyList();
    }

    public Collection<String> getImports() {
        return Collections.emptyList();
    }

    public void removeImport(String dependency) {
    }

    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        return new LinkedHashSet<IInterpreterStatus>();
    }

    public boolean supportsValidation() {
        return false;
    }
}

