/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;

public class PackageCache {
    private final IPackageFragmentRoot packageRoot;
    private final Map<String, List<IPackageFragment>> packagesCache;
    private boolean initialized;

    public PackageCache(IPackageFragmentRoot packageRoot) {
        this.packageRoot = packageRoot;
        this.packagesCache = new HashMap<String, List<IPackageFragment>>();
        this.initialized = false;
    }

    public boolean hasSingleChild(IPackageFragment packageFragment) throws JavaModelException {
        IPackageFragment singleChild = this.getSingleChild(packageFragment);
        boolean hasSingleChild = singleChild != null;
        return hasSingleChild;
    }

    public IPackageFragment getSingleChild(IPackageFragment packageFragment) throws JavaModelException {
        boolean hasSingleChild;
        List<IPackageFragment> children = this.getDirectChildren(packageFragment);
        boolean bl = hasSingleChild = children.size() == 1;
        if (hasSingleChild) {
            IPackageFragment singleChild = children.get(0);
            return singleChild;
        }
        return null;
    }

    public List<IPackageFragment> getDirectChildren(IPackageFragment packageFragment) throws JavaModelException {
        this.initialize();
        String packageName = packageFragment.getElementName();
        List<IPackageFragment> childrenOfPackage = this.packagesCache.get(packageName);
        if (childrenOfPackage == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(childrenOfPackage);
    }

    private void initialize() throws JavaModelException {
        if (!this.initialized) {
            this.collectChildrenOfPackages();
            this.initialized = true;
        }
    }

    private void collectChildrenOfPackages() throws JavaModelException {
        IJavaElement[] allPackages;
        this.packagesCache.clear();
        IJavaElement[] iJavaElementArray = allPackages = this.packageRoot.getChildren();
        int n = allPackages.length;
        int n2 = 0;
        while (n2 < n) {
            boolean hasParentPackage;
            IJavaElement child = iJavaElementArray[n2];
            IPackageFragment currentPackage = (IPackageFragment)child;
            String packageName = currentPackage.getElementName();
            int index = packageName.lastIndexOf(46);
            boolean bl = hasParentPackage = index != -1;
            if (hasParentPackage) {
                String parentName = packageName.substring(0, index);
                List<IPackageFragment> siblingsOfCurrentPackage = this.packagesCache.get(parentName);
                if (siblingsOfCurrentPackage == null) {
                    siblingsOfCurrentPackage = new ArrayList<IPackageFragment>();
                    this.packagesCache.put(parentName, siblingsOfCurrentPackage);
                }
                siblingsOfCurrentPackage.add(currentPackage);
            }
            ++n2;
        }
    }

    static class PerRootCache {
        private final Map<IPackageFragmentRoot, PackageCache> packageCaches = new HashMap<IPackageFragmentRoot, PackageCache>();

        PerRootCache() {
        }

        boolean hasSingleChild(IPackageFragment packageFragment) throws JavaModelException {
            PackageCache packagesOfRoot = this.getPackageCache(packageFragment);
            return packagesOfRoot.hasSingleChild(packageFragment);
        }

        IPackageFragment getSingleChild(IPackageFragment packageFragment) throws JavaModelException {
            PackageCache packagesOfRoot = this.getPackageCache(packageFragment);
            return packagesOfRoot.getSingleChild(packageFragment);
        }

        List<IPackageFragment> getDirectChildren(IPackageFragment packageFragment) throws JavaModelException {
            PackageCache packagesOfRoot = this.getPackageCache(packageFragment);
            return packagesOfRoot.getDirectChildren(packageFragment);
        }

        private PackageCache getPackageCache(IPackageFragment packageFragment) {
            IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)packageFragment.getParent();
            PackageCache packageCache = this.getPackageCache(packageRoot);
            return packageCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PackageCache getPackageCache(IPackageFragmentRoot root) {
            PackageCache packageCacheOfRoot;
            Map<IPackageFragmentRoot, PackageCache> map = this.packageCaches;
            synchronized (map) {
                packageCacheOfRoot = this.packageCaches.get(root);
                if (packageCacheOfRoot == null) {
                    packageCacheOfRoot = new PackageCache(root);
                    this.packageCaches.put(root, packageCacheOfRoot);
                }
            }
            return packageCacheOfRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            Map<IPackageFragmentRoot, PackageCache> map = this.packageCaches;
            synchronized (map) {
                this.packageCaches.clear();
            }
        }
    }
}

