/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.ui.wizards.ClasspathAttributeConfiguration;

public class CPListElementAttribute {
    private CPListElement fParent;
    private String fKey;
    private Object fValue;
    private final boolean fBuiltIn;
    private IStatus fStatus;
    private ClasspathAttributeConfiguration.ClasspathAttributeAccess fCachedAccess;

    public CPListElementAttribute(CPListElement parent, String key, Object value, boolean builtIn) {
        this.fKey = key;
        this.fValue = value;
        this.fParent = parent;
        this.fBuiltIn = builtIn;
        if (!builtIn) {
            Assert.isTrue((value instanceof String || value == null ? 1 : 0) != 0);
        }
        this.fStatus = this.getContainerChildStatus();
    }

    private CPListElementAttribute(boolean buildIn) {
        this.fBuiltIn = buildIn;
    }

    public IClasspathAttribute getClasspathAttribute() {
        Assert.isTrue((!this.fBuiltIn ? 1 : 0) != 0);
        return JavaCore.newClasspathAttribute((String)this.fKey, (String)((String)this.fValue));
    }

    public CPListElement getParent() {
        return this.fParent;
    }

    public boolean isBuiltIn() {
        return this.fBuiltIn;
    }

    public boolean isNonModifiable() {
        IJavaProject javaProject;
        if (this.fStatus != null && !this.fStatus.isOK()) {
            return true;
        }
        return this.fBuiltIn && this.fKey.equals("module") && !JavaModelUtil.is9OrHigher((IJavaProject)(javaProject = this.fParent.getJavaProject()));
    }

    public boolean isNotSupported() {
        return this.fStatus != null && this.fStatus.getCode() == 1;
    }

    private IStatus getContainerChildStatus() {
        return this.fParent.getContainerChildStatus(this);
    }

    public String getKey() {
        return this.fKey;
    }

    public Object getValue() {
        return this.fValue;
    }

    public void setValue(Object value) {
        this.fValue = value;
        this.fCachedAccess = null;
        this.getParent().attributeChanged(this.fKey);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CPListElementAttribute)) {
            return false;
        }
        CPListElementAttribute attrib = (CPListElementAttribute)obj;
        return attrib.fKey == this.fKey && attrib.getParent().getPath().equals((Object)this.fParent.getPath());
    }

    public int hashCode() {
        return this.fKey.hashCode() * 89 + this.fParent.getPath().hashCode();
    }

    public CPListElementAttribute copy() {
        CPListElementAttribute result = new CPListElementAttribute(this.fBuiltIn);
        result.fParent = this.fParent;
        result.fKey = this.fKey;
        result.fValue = this.fValue;
        result.fStatus = this.fStatus;
        return result;
    }

    public ClasspathAttributeConfiguration.ClasspathAttributeAccess getClasspathAttributeAccess() {
        if (this.fCachedAccess == null) {
            this.fCachedAccess = new ClasspathAttributeConfiguration.ClasspathAttributeAccess(){

                @Override
                public IClasspathAttribute getClasspathAttribute() {
                    return CPListElementAttribute.this.getClasspathAttribute();
                }

                @Override
                public IJavaProject getJavaProject() {
                    return CPListElementAttribute.this.getParent().getJavaProject();
                }

                @Override
                public IClasspathEntry getParentClasspassEntry() {
                    return CPListElementAttribute.this.getParent().getClasspathEntry();
                }
            };
        }
        return this.fCachedAccess;
    }
}

