/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.migrationsupport.rules.member;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedField;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedMember;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedMethod;
import org.junit.platform.commons.util.PreconditionViolationException;

@API(status=API.Status.INTERNAL, since="5.0")
public final class TestRuleAnnotatedMemberFactory {
    private TestRuleAnnotatedMemberFactory() {
    }

    public static TestRuleAnnotatedMember from(Object testInstance, Member member) {
        if (member instanceof Method) {
            return new TestRuleAnnotatedMethod(testInstance, (Method)member);
        }
        if (member instanceof Field) {
            return new TestRuleAnnotatedField(testInstance, (Field)member);
        }
        throw new PreconditionViolationException(String.format("Unsupported Member type [%s] for TestRule. Member must be of type %s or %s", member, Method.class.getName(), Field.class.getName()));
    }
}

