/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.navigator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.common.ui.tools.api.navigator.GroupingContentProvider;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.internal.views.common.FileSessionFinder;
import org.eclipse.sirius.ui.tools.internal.views.common.SessionWrapperContentProvider;
import org.eclipse.sirius.ui.tools.internal.views.common.item.AnalysisResourceItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ControlledRoot;
import org.eclipse.sirius.ui.tools.internal.views.common.item.InternalCommonItem;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ProjectDependenciesItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.OpenEditorDoubleClickListener;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.OpenSessionOnExpandListener;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.SiriusDialectLinkWithEditorSelectionListener;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.progress.UIJob;

public class SiriusCommonContentProvider
implements ICommonContentProvider {
    private ITreeContentProvider defaultContentProvider;
    private Viewer myViewer;
    private Collection<Runnable> pendingUpdates;
    private UIJob updateJob;
    private SessionManagerListener sessionManagerListener;
    private IDoubleClickListener doubleClickListener;
    private Collection<RefreshViewerTrigger> viewerRefreshTriggers = new HashSet<RefreshViewerTrigger>();
    private boolean shouldAskExtension;
    private ITreeViewerListener expandListener;
    private SiriusDialectLinkWithEditorSelectionListener linkWithEditorSelectionListener;

    public SiriusCommonContentProvider() {
        this(null);
    }

    public SiriusCommonContentProvider(Session session) {
        this(session, new OpenEditorDoubleClickListener(session));
    }

    public SiriusCommonContentProvider(Session session, IDoubleClickListener listener) {
        this.defaultContentProvider = ViewHelper.INSTANCE.createContentProvider();
        this.initSessionManager();
        this.doubleClickListener = listener;
        this.initExpandListener();
    }

    private void initExpandListener() {
        this.expandListener = new OpenSessionOnExpandListener();
    }

    private void initSessionManager() {
        this.sessionManagerListener = new CommonSessionManagerListener();
        SessionManager.INSTANCE.addSessionsListener(this.sessionManagerListener);
        for (Session alreadyManagedSession : SessionManager.INSTANCE.getSessions()) {
            if (!alreadyManagedSession.isOpen()) continue;
            this.addRefreshViewerTrigger(alreadyManagedSession);
        }
    }

    public void addRefreshViewerTrigger(Session openedSession) {
        if (openedSession != null) {
            RefreshViewerTrigger viewerRefreshTrigger = new RefreshViewerTrigger(openedSession);
            openedSession.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)viewerRefreshTrigger);
            this.viewerRefreshTriggers.add(viewerRefreshTrigger);
        }
    }

    public void removeRefreshViewerTriggers(Session removedSession) {
        if (removedSession != null && removedSession.getTransactionalEditingDomain() != null) {
            for (RefreshViewerTrigger trigger : new ArrayList<RefreshViewerTrigger>(this.viewerRefreshTriggers)) {
                if (!removedSession.equals(trigger.getSession())) continue;
                removedSession.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)trigger);
                this.viewerRefreshTriggers.remove((Object)trigger);
            }
        }
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> allChildren = new ArrayList<Object>();
        this.shouldAskExtension = true;
        if (parentElement instanceof IProject) {
            Option modelingProj = ModelingProject.asModelingProject((IProject)((IProject)parentElement));
            if (modelingProj.some()) {
                allChildren.add(new ProjectDependenciesItemImpl((ModelingProject)modelingProj.get()));
            }
        } else if (parentElement instanceof IFile) {
            allChildren.addAll(this.doGetFileChildren((IFile)parentElement));
        } else if (this.defaultContentProvider != null) {
            return this.defaultContentProvider.getChildren(parentElement);
        }
        if (this.shouldAskExtension) {
            SessionWrapperContentProvider sessionWrapperContentProvider = null;
            if (this.defaultContentProvider instanceof SessionWrapperContentProvider) {
                sessionWrapperContentProvider = (SessionWrapperContentProvider)this.defaultContentProvider;
            } else if (this.defaultContentProvider instanceof GroupingContentProvider && ((GroupingContentProvider)this.defaultContentProvider).getDelegateTreeContentProvider() instanceof SessionWrapperContentProvider) {
                sessionWrapperContentProvider = (SessionWrapperContentProvider)((GroupingContentProvider)this.defaultContentProvider).getDelegateTreeContentProvider();
            }
            if (sessionWrapperContentProvider != null) {
                allChildren.addAll(sessionWrapperContentProvider.getChildrenFromExtensions(parentElement));
            }
        }
        return allChildren.toArray();
    }

    private Collection<Object> doGetFileChildren(IFile parentFile) {
        Iterable transientSessions;
        ArrayList<Object> fileChildren = new ArrayList<Object>();
        IProject parentProject = parentFile.getProject();
        if (parentProject == null) {
            return fileChildren;
        }
        ArrayList openedSessions = Lists.newArrayList((Iterable)Iterables.filter(FileSessionFinder.getSelectedSessions(Collections.singletonList(parentFile)), (Predicate)new Predicate<Session>(){

            public boolean apply(Session input) {
                return input.isOpen();
            }
        }));
        Option modelingProject = ModelingProject.asModelingProject((IProject)parentProject);
        if (modelingProject.some()) {
            Session modelingProjectSession = ((ModelingProject)modelingProject.get()).getSession();
            if (modelingProjectSession != null && modelingProjectSession.isOpen()) {
                if (!"aird".equals(parentFile.getFileExtension())) {
                    Resource resource = this.getControlledResource(parentFile, modelingProjectSession);
                    if (resource != null && resource.isLoaded()) {
                        for (EObject obj : resource.getContents()) {
                            fileChildren.add(new ControlledRoot(obj, parentFile));
                        }
                    } else {
                        resource = this.getSemanticResource(parentFile, modelingProjectSession);
                        if (resource != null && resource.isLoaded()) {
                            fileChildren.addAll(this.safeGetDefaultContentProviderChildren(resource, parentFile));
                        }
                    }
                } else {
                    Resource resource = this.getAnalysisResource(parentFile, modelingProjectSession);
                    if (resource != null) {
                        AnalysisResourceItemImpl childrenComputer = new AnalysisResourceItemImpl(modelingProjectSession, resource, parentFile);
                        childrenComputer.setSpecialMode(true);
                        fileChildren.addAll(childrenComputer.getChildren());
                    }
                }
            }
        } else if (!openedSessions.isEmpty() && "aird".equals(parentFile.getFileExtension())) {
            if (openedSessions.size() > 1) {
                fileChildren.addAll(openedSessions);
                this.shouldAskExtension = false;
            } else {
                fileChildren.addAll(this.safeGetDefaultContentProviderChildren(openedSessions.iterator().next(), parentFile));
            }
        }
        if (!"aird".equals(parentFile.getFileExtension()) && !Iterables.isEmpty((Iterable)(transientSessions = Iterables.filter((Iterable)openedSessions, (Predicate)new TransientSessionPredicate())))) {
            if (modelingProject.some() || Iterables.size((Iterable)transientSessions) > 1) {
                Iterables.addAll(fileChildren, (Iterable)transientSessions);
                this.shouldAskExtension = false;
            } else {
                fileChildren.addAll(this.doGetChildrenForTransientSession((Session)transientSessions.iterator().next(), parentFile));
            }
        }
        return fileChildren;
    }

    private Collection<Object> safeGetDefaultContentProviderChildren(Object computationParent, Object parentInView) {
        Object[] children = this.defaultContentProvider.getChildren(computationParent);
        this.shouldAskExtension = false;
        if (children != null) {
            List<Object> childrenList = Arrays.asList(children);
            if (parentInView != null && parentInView != computationParent) {
                for (InternalCommonItem wrapper : Iterables.filter(childrenList, InternalCommonItem.class)) {
                    wrapper.setParent(parentInView);
                }
            }
            return childrenList;
        }
        return Collections.emptyList();
    }

    private List<Object> doGetChildrenForTransientSession(Session transientSession, IFile semanticFile) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.defaultContentProvider != null && semanticFile != null && semanticFile.getFullPath() != null) {
            URI semUri = this.getFileUri(semanticFile);
            for (Object child : this.safeGetDefaultContentProviderChildren(transientSession, semanticFile)) {
                if (child instanceof Resource) {
                    if (!semUri.equals(((Resource)child).getURI())) continue;
                    children.addAll(this.safeGetDefaultContentProviderChildren(child, semanticFile));
                    continue;
                }
                children.add(child);
            }
        }
        return children;
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (this.defaultContentProvider instanceof SessionWrapperContentProvider) {
            parent = ((SessionWrapperContentProvider)this.defaultContentProvider).getParentFromExtensions(element);
        }
        try {
            if (parent == null) {
                parent = element instanceof Session ? this.getSessionParent((Session)element) : (element instanceof Resource ? this.getResourceParent((Resource)element) : (element instanceof EObject && ((EObject)element).eContainer() == null ? this.getRootParent((EObject)element) : this.defaultContentProvider.getParent(element)));
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (NullPointerException nullPointerException) {}
        return parent;
    }

    private Object getRootParent(EObject element) {
        IFile file;
        IFile mainAirdFile;
        Option modelingProj;
        Session session;
        Resource res = element.eResource();
        Session session2 = session = res == null ? null : SessionManager.INSTANCE.getSession(res);
        if (session != null && session.isOpen() && session.getSessionResource().getURI().isPlatformResource() && (modelingProj = ModelingProject.asModelingProject((IProject)(mainAirdFile = WorkspaceSynchronizer.getFile((Resource)session.getSessionResource())).getProject())).some() && res.getURI().isPlatformResource() && (file = WorkspaceSynchronizer.getFile((Resource)res)) != null && file.exists() && ((ModelingProject)modelingProj.get()).getProject().equals((Object)file.getProject())) {
            return file;
        }
        return res;
    }

    private Object getResourceParent(Resource res) {
        ProjectDependenciesItemImpl parent = null;
        Session session = SessionManager.INSTANCE.getSession(res);
        if (session != null && session.isOpen() && session.getSessionResource().getURI().isPlatformResource()) {
            IFile mainAirdFile = WorkspaceSynchronizer.getFile((Resource)session.getSessionResource());
            Option modelingProj = ModelingProject.asModelingProject((IProject)mainAirdFile.getProject());
            parent = modelingProj.some() ? new ProjectDependenciesItemImpl((ModelingProject)modelingProj.get()) : (new TransientSessionPredicate().apply(session) ? (res.getURI().isPlatformResource() ? WorkspaceSynchronizer.getFile((Resource)res) : null) : mainAirdFile);
        }
        return parent;
    }

    private Object getSessionParent(Session session) {
        IFile parent = null;
        if (new TransientSessionPredicate().apply(session)) {
            for (Resource res : session.getSemanticResources()) {
                if (!res.getURI().isPlatformResource()) continue;
                parent = WorkspaceSynchronizer.getFile((Resource)res);
                break;
            }
        } else if (session.getSessionResource().getURI().isPlatformResource()) {
            parent = WorkspaceSynchronizer.getFile((Resource)session.getSessionResource());
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        Option modelingProject;
        if (element instanceof IFile && (modelingProject = ModelingProject.asModelingProject((IProject)((IFile)element).getProject())).some() && ((ModelingProject)modelingProject.get()).getSession() == null && ((ModelingProject)modelingProject.get()).isValid()) {
            return true;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.defaultContentProvider != null) {
            this.defaultContentProvider.inputChanged(viewer, oldInput, newInput);
        }
        if (viewer != this.myViewer) {
            if (this.doubleClickListener != null) {
                this.removeDoubleClickListener(this.doubleClickListener);
            }
            this.removeExpandListener();
            if (this.linkWithEditorSelectionListener != null) {
                this.linkWithEditorSelectionListener.dispose();
            }
            this.myViewer = viewer;
            if (this.doubleClickListener != null) {
                this.addDoubleClickListener(this.doubleClickListener);
            }
            this.addExpandListener();
            this.createLWESelectionListener();
        }
    }

    private void createLWESelectionListener() {
        if (this.myViewer instanceof CommonViewer) {
            CommonNavigator commonNavigator = ((CommonViewer)this.myViewer).getCommonNavigator();
            this.linkWithEditorSelectionListener = new SiriusDialectLinkWithEditorSelectionListener(commonNavigator);
            this.linkWithEditorSelectionListener.init();
        }
    }

    private void addDoubleClickListener(IDoubleClickListener listener) {
        if (this.myViewer instanceof StructuredViewer) {
            ((StructuredViewer)this.myViewer).addDoubleClickListener(listener);
        }
    }

    private void removeDoubleClickListener(IDoubleClickListener listener) {
        if (this.myViewer instanceof StructuredViewer) {
            ((StructuredViewer)this.myViewer).removeDoubleClickListener(listener);
        }
    }

    private void addExpandListener() {
        if (this.myViewer instanceof AbstractTreeViewer) {
            ((AbstractTreeViewer)this.myViewer).addTreeListener(this.expandListener);
        }
    }

    private void removeExpandListener() {
        if (this.myViewer instanceof StructuredViewer) {
            ((AbstractTreeViewer)this.myViewer).removeTreeListener(this.expandListener);
        }
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void dispose() {
        if (this.doubleClickListener != null) {
            this.removeDoubleClickListener(this.doubleClickListener);
        }
        this.removeExpandListener();
        this.myViewer = null;
        this.defaultContentProvider = null;
        for (RefreshViewerTrigger trigger : this.viewerRefreshTriggers) {
            Session session = trigger.getSession();
            if (session == null || session.getTransactionalEditingDomain() == null) continue;
            session.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)trigger);
        }
        this.viewerRefreshTriggers.clear();
        if (this.sessionManagerListener != null) {
            SessionManager.INSTANCE.removeSessionsListener(this.sessionManagerListener);
            this.sessionManagerListener = null;
        }
        if (this.linkWithEditorSelectionListener != null) {
            this.linkWithEditorSelectionListener.dispose();
            this.linkWithEditorSelectionListener = null;
        }
    }

    private void refreshViewer(Session session) {
        this.refreshViewer(Collections.singleton(session));
    }

    private void updateViewer(Session session) {
        LinkedHashSet<Object> resourcesToUpdate = new LinkedHashSet<Object>();
        if (session != null) {
            Iterable resources = Iterables.concat((Iterable)session.getAllSessionResources(), (Iterable)session.getSemanticResources());
            if (session instanceof DAnalysisSessionEObject) {
                resources = Iterables.concat((Iterable)resources, (Iterable)((DAnalysisSessionEObject)session).getControlledResources());
            }
            for (Resource res : resources) {
                IFile file;
                if (res.getURI() == null || !res.getURI().isPlatformResource() || (file = WorkspaceSynchronizer.getFile((Resource)res)) == null || !file.exists() || file.getProject() == null) continue;
                resourcesToUpdate.add(file);
                resourcesToUpdate.add(file.getProject());
            }
        }
        this.updateViewer(resourcesToUpdate);
    }

    private void updateViewer(final Collection<?> toUpdate) {
        Runnable updateViewer = new Runnable(){

            @Override
            public void run() {
                if (SiriusCommonContentProvider.this.myViewer instanceof StructuredViewer && toUpdate != null && !toUpdate.isEmpty()) {
                    ((StructuredViewer)SiriusCommonContentProvider.this.myViewer).update(toUpdate.toArray(), null);
                } else {
                    SiriusCommonContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.executeRunnables(new ArrayList<Runnable>(Arrays.asList(updateViewer)));
    }

    private void refreshViewer(final Collection<?> toRefresh) {
        Runnable refreshViewer = new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        if (SiriusCommonContentProvider.this.myViewer instanceof StructuredViewer && toRefresh != null && !toRefresh.isEmpty()) {
                            for (Object toRef : toRefresh) {
                                if (toRef instanceof Session) {
                                    Session session = (Session)toRef;
                                    Set projectsToRefresh = SiriusCommonContentProvider.this.getProjectsToRefresh(session);
                                    for (IProject projectToRefresh : projectsToRefresh) {
                                        ((StructuredViewer)SiriusCommonContentProvider.this.myViewer).refresh((Object)projectToRefresh, true);
                                    }
                                    continue;
                                }
                                ((StructuredViewer)SiriusCommonContentProvider.this.myViewer).refresh(toRef, true);
                            }
                            break block8;
                        }
                        if (SiriusCommonContentProvider.this.myViewer != null) {
                            SiriusCommonContentProvider.this.myViewer.refresh();
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            }
        };
        this.executeRunnables(new ArrayList<Runnable>(Arrays.asList(refreshViewer)));
    }

    private Set<IProject> getProjectsToRefresh(Session session) {
        HashSet<IProject> projectsToRefresh = new HashSet<IProject>();
        if (session != null) {
            Resource sessionResource;
            Iterable resources = Iterables.concat((Iterable)session.getAllSessionResources(), (Iterable)session.getSemanticResources());
            if (session instanceof DAnalysisSessionEObject) {
                resources = Iterables.concat((Iterable)resources, (Iterable)((DAnalysisSessionEObject)session).getControlledResources());
            }
            if ((sessionResource = session.getSessionResource()) != null && !Iterables.contains((Iterable)resources, (Object)sessionResource)) {
                resources = Iterables.concat((Iterable)resources, Collections.singletonList(sessionResource));
            }
            for (Resource res : resources) {
                try {
                    IFile file;
                    if (res == null || res.getURI() == null || !res.getURI().isPlatformResource() || (file = WorkspaceSynchronizer.getFile((Resource)res)) == null || !file.exists() || file.getProject() == null) continue;
                    projectsToRefresh.add(file.getProject());
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        return projectsToRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRunnables(Collection<Runnable> runnables) {
        if (this.myViewer == null) {
            SiriusCommonContentProvider siriusCommonContentProvider = this;
            synchronized (siriusCommonContentProvider) {
                this.pendingUpdates = null;
            }
            return;
        }
        Control ctrl = this.myViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            boolean inUIThread;
            boolean hasPendingUpdates;
            SiriusCommonContentProvider siriusCommonContentProvider = this;
            synchronized (siriusCommonContentProvider) {
                hasPendingUpdates = this.pendingUpdates != null && !this.pendingUpdates.isEmpty();
            }
            boolean bl = inUIThread = ctrl.getDisplay().getThread() == Thread.currentThread();
            if (!hasPendingUpdates && inUIThread && !this.isViewerBusy()) {
                this.runUpdates(runnables);
            } else {
                SiriusCommonContentProvider siriusCommonContentProvider2 = this;
                synchronized (siriusCommonContentProvider2) {
                    if (this.pendingUpdates == null) {
                        this.pendingUpdates = runnables;
                    } else {
                        this.pendingUpdates.addAll(runnables);
                    }
                }
                this.postAsyncUpdate(ctrl.getDisplay());
            }
        }
    }

    private boolean isViewerBusy() {
        boolean viewerIsBusy = false;
        if (this.myViewer != null) {
            AccessibleObject method = null;
            try {
                method = this.myViewer.getClass().getMethod("isBusy", new Class[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (method != null) {
                if (!method.isAccessible()) {
                    ((Method)method).setAccessible(true);
                }
                try {
                    Object data = ((Method)method).invoke(this.myViewer, new Object[0]);
                    if (data instanceof Boolean) {
                        viewerIsBusy = (Boolean)data;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
        return viewerIsBusy;
    }

    private void postAsyncUpdate(Display display) {
        if (this.updateJob == null) {
            this.updateJob = new UIJob(display, Messages.SiriusCommonContentProvider_asyncUpdateJob){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (SiriusCommonContentProvider.this.isViewerBusy()) {
                        this.schedule(100L);
                    } else {
                        SiriusCommonContentProvider.this.runPendingUpdates();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.updateJob.setSystem(true);
        }
        this.updateJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPendingUpdates() {
        Control control;
        Collection<Runnable> updates;
        SiriusCommonContentProvider siriusCommonContentProvider = this;
        synchronized (siriusCommonContentProvider) {
            updates = this.pendingUpdates;
            this.pendingUpdates = null;
        }
        if (updates != null && this.myViewer != null && (control = this.myViewer.getControl()) != null && !control.isDisposed()) {
            this.runUpdates(updates);
        }
    }

    private void runUpdates(Collection<Runnable> runnables) {
        if (runnables != null) {
            for (Runnable r : runnables) {
                r.run();
            }
        }
    }

    public void saveState(IMemento aMemento) {
    }

    public void restoreState(IMemento aMemento) {
    }

    private Resource getSemanticResource(IFile file, Session session) {
        if (session != null) {
            URI fileURI = this.getFileUri(file);
            for (Resource resource : new ArrayList(session.getSemanticResources())) {
                if (!resource.getURI().equals(fileURI)) continue;
                return resource;
            }
        }
        return null;
    }

    private Resource getControlledResource(IFile file, Session session) {
        if (session instanceof DAnalysisSessionEObject) {
            URI fileURI = this.getFileUri(file);
            for (Resource resource : ((DAnalysisSessionEObject)session).getControlledResources()) {
                if (!resource.getURI().equals(fileURI)) continue;
                return resource;
            }
        }
        return null;
    }

    private URI getFileUri(IFile file) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    private Resource getAnalysisResource(IFile file, Session session) {
        if (session != null) {
            URI fileURI = this.getFileUri(file);
            for (Resource resource : session.getAllSessionResources()) {
                if (!resource.getURI().equals(fileURI)) continue;
                return resource;
            }
        }
        return null;
    }

    private class CommonSessionManagerListener
    implements SessionManagerListener {
        private CommonSessionManagerListener() {
        }

        public void notifyAddSession(Session newSession) {
        }

        public void notifyRemoveSession(Session removedSession) {
            SiriusCommonContentProvider.this.removeRefreshViewerTriggers(removedSession);
            SiriusCommonContentProvider.this.refreshViewer(removedSession);
        }

        public void viewpointSelected(Viewpoint selectedSirius) {
        }

        public void viewpointDeselected(Viewpoint deselectedSirius) {
        }

        public void notify(Session updated, int notification) {
            switch (notification) {
                case 0: 
                case 5: 
                case 10: 
                case 11: 
                case 16: {
                    SiriusCommonContentProvider.this.refreshViewer(updated);
                    break;
                }
                case 2: 
                case 3: {
                    SiriusCommonContentProvider.this.updateViewer(updated);
                    break;
                }
                case 7: {
                    SiriusCommonContentProvider.this.refreshViewer(updated);
                    SiriusCommonContentProvider.this.addRefreshViewerTrigger(updated);
                    break;
                }
            }
        }
    }

    private class RefreshViewerTrigger
    extends ResourceSetListenerImpl {
        private final Session session;

        RefreshViewerTrigger(Session openedSession) {
            super(NotificationFilter.NOT_TOUCH);
            this.session = openedSession;
        }

        public Session getSession() {
            return this.session;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            Function<Notification, Object> notifToNotifier;
            if (!this.session.isOpen()) {
                return;
            }
            ArrayList notifications = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)event.getNotifications(), Notification.class), (Predicate)new RefreshViewerTriggerScope(this.session)));
            ArrayList impactedElements = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)notifications, (Function)(notifToNotifier = new Function<Notification, Object>(){

                public Object apply(Notification from) {
                    return from.getNotifier();
                }
            })), EObject.class));
            if (!impactedElements.isEmpty()) {
                boolean needRefresh = this.shouldRefresh(notifications, impactedElements);
                if (needRefresh) {
                    SiriusCommonContentProvider.this.refreshViewer(impactedElements);
                } else {
                    SiriusCommonContentProvider.this.updateViewer(impactedElements);
                }
            }
        }

        private boolean shouldRefresh(Iterable<Notification> notifications, Collection<EObject> impactedElements) {
            block3: for (Notification n : notifications) {
                if (n.getNotifier() == null || !impactedElements.contains(n.getNotifier())) continue;
                switch (n.getEventType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        if (!(n.getFeature() instanceof EReference) || !((EReference)n.getFeature()).isContainment()) continue block3;
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean isPostcommitOnly() {
            return true;
        }
    }

    private class RefreshViewerTriggerScope
    implements Predicate<Notification> {
        private final Session session;
        private Set<Resource> allSemanticResources = new HashSet<Resource>();

        RefreshViewerTriggerScope(Session session) {
            this.session = session;
            this.allSemanticResources = new HashSet<Resource>();
            if (session.isOpen()) {
                this.allSemanticResources.addAll(session.getSemanticResources());
                if (session instanceof DAnalysisSessionEObject) {
                    this.allSemanticResources.addAll((Collection<Resource>)((DAnalysisSessionEObject)session).getControlledResources());
                }
            }
        }

        public boolean apply(Notification notification) {
            Resource notifierResource;
            Object notifier = notification.getNotifier();
            boolean result = false;
            if (notifier instanceof DRepresentation && ViewpointPackage.eINSTANCE.getDRepresentation_Name().equals(notification.getFeature())) {
                result = true;
            }
            if (!result && notifier instanceof Resource && 2 == notification.getFeatureID(Resource.class)) {
                result = this.isSemanticChange((Resource)notifier);
            } else if (!result && notifier instanceof EObject && (notifierResource = ((EObject)notifier).eResource()) != null && this.session != null && this.session.isOpen()) {
                result = this.isSemanticChange(notifierResource);
            }
            return !notification.isTouch() && result;
        }

        private boolean isSemanticChange(Resource resource) {
            boolean result = false;
            if (resource != null) {
                this.allSemanticResources.contains(resource);
            }
            return result;
        }
    }

    public static class TransientSessionPredicate
    implements Predicate<Session> {
        public boolean apply(Session input) {
            return new URIQuery(input.getSessionResource().getURI()).isInMemoryURI();
        }
    }
}

