/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.decoration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.ImageFigureEx;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerTask;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.DecorationDescriptor;
import org.eclipse.sirius.diagram.ui.tools.api.decoration.SiriusDecorationDescriptorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.DecorationDistributionDirection;
import org.eclipse.sirius.viewpoint.description.Position;
import org.eclipse.swt.graphics.Image;

public class SiriusGenericDecorator
extends AbstractDecorator {
    private static final Integer DEFAULT_MARGIN = 2;
    private static final Integer MARGIN_FOR_BORDERNODE = IBorderItemOffsets.DEFAULT_OFFSET.height;
    private static final Integer SPACE = 1;
    private static final Integer LIST_DECORATION_SIZE = 16;
    private static final ProfilerTask DECORATOR_REFRESH = new ProfilerTask("DDiagram", Messages.SubDiagramDecorator_taskName, "/images/viewpoint.gif");
    private GraphicalEditPart editPart;
    private List<IDecoration> decorations = Collections.emptyList();
    private Set<SiriusDecorationDescriptorProvider> decorationDescriptorProviders;
    private boolean printDecoration;
    private Session session;

    public SiriusGenericDecorator(IDecoratorTarget decoratorTarget, Set<SiriusDecorationDescriptorProvider> decorationDescriptorProviders) {
        super(decoratorTarget);
        IPreferenceStore prefs = DiagramUIPlugin.getPlugin().getPreferenceStore();
        this.printDecoration = prefs.getBoolean(SiriusDiagramUiPreferencesKeys.PREF_PRINT_DECORATION.name());
        this.decorationDescriptorProviders = decorationDescriptorProviders;
        this.editPart = (GraphicalEditPart)this.getDecoratorTarget().getAdapter(GraphicalEditPart.class);
        View view = (View)this.getDecoratorTarget().getAdapter(View.class);
        EObject model = view.getElement();
        if (model instanceof DRepresentationElement) {
            DRepresentationElement repElement = (DRepresentationElement)model;
            this.session = SessionManager.INSTANCE.getSession(repElement.getTarget());
        }
    }

    public void activate() {
        for (SiriusDecorationDescriptorProvider siriusDecorationDescriptorProvider : this.decorationDescriptorProviders) {
            siriusDecorationDescriptorProvider.activate((IDecoratorTarget)this.getDecoratorTarget(), (IDecorator)this, this.editPart);
        }
    }

    public void deactivate() {
        super.deactivate();
        for (SiriusDecorationDescriptorProvider siriusDecorationDescriptorProvider : this.decorationDescriptorProviders) {
            siriusDecorationDescriptorProvider.deactivate((IDecorator)this, this.editPart);
        }
        this.removeDecorations();
    }

    public void refresh() {
        DslCommonPlugin.PROFILER.startWork(DECORATOR_REFRESH);
        this.removeDecorations();
        if (this.editPart == null || this.editPart.getParent() == null || this.editPart.getViewer() == null) {
            return;
        }
        if (this.editPart instanceof IDiagramElementEditPart) {
            IDiagramElementEditPart diagramElementEditPart = (IDiagramElementEditPart)this.editPart;
            HashMap<Position, List<DecorationDescriptor>> positionToDecorators = new HashMap<Position, List<DecorationDescriptor>>();
            List decorationDescriptors = this.decorationDescriptorProviders.stream().filter(provider -> provider.provides(diagramElementEditPart)).flatMap(provider -> provider.getDecorationDescriptors(diagramElementEditPart, this.session).stream()).collect(Collectors.toList());
            if (!decorationDescriptors.isEmpty()) {
                int margin = this.editPart.getChildren().stream().filter(IBorderedShapeEditPart.class::isInstance).findFirst().isPresent() ? MARGIN_FOR_BORDERNODE : DEFAULT_MARGIN;
                if (this.editPart instanceof AbstractConnectionEditPart) {
                    positionToDecorators.put(Position.CENTER_LITERAL, decorationDescriptors);
                    for (DecorationDescriptor decoDesc : decorationDescriptors) {
                        decoDesc.setDistributionDirection(DecorationDistributionDirection.HORIZONTAL);
                    }
                    Map<Position, IFigure> figureAtPosition = this.computeGroupDecorationsFigure(positionToDecorators, margin);
                    if (figureAtPosition != null) {
                        boolean isPrintableDeco = this.isPrintableDecoration((List)positionToDecorators.get(Position.CENTER_LITERAL));
                        this.addDecoration(this.getDecoratorTarget().addConnectionDecoration(figureAtPosition.get(Position.CENTER_LITERAL), 50, !isPrintableDeco));
                    }
                } else {
                    for (DecorationDescriptor decorationDescriptor : decorationDescriptors) {
                        Position position = decorationDescriptor.getPosition();
                        ArrayList<DecorationDescriptor> list = (ArrayList<DecorationDescriptor>)positionToDecorators.get(position);
                        if (list == null) {
                            list = new ArrayList<DecorationDescriptor>(Arrays.asList(decorationDescriptor));
                            positionToDecorators.put(position, list);
                            continue;
                        }
                        list.add(decorationDescriptor);
                    }
                    Map<Position, IFigure> figureAtPosition = this.computeGroupDecorationsFigure(positionToDecorators, margin);
                    if (figureAtPosition != null) {
                        for (Position position : figureAtPosition.keySet()) {
                            boolean isPrintableDeco = this.isPrintableDecoration((List)positionToDecorators.get(position));
                            this.addDecoration(this.getDecoratorTarget().addShapeDecoration(figureAtPosition.get(position), this.getGMFPosition(position), -margin, !isPrintableDeco));
                        }
                    }
                }
            }
        }
        DslCommonPlugin.PROFILER.stopWork(DECORATOR_REFRESH);
    }

    private boolean isPrintableDecoration(List<DecorationDescriptor> decorationDescs) {
        boolean atLeastOnePrintableDecorator = decorationDescs.stream().filter(deco -> deco.isPrintable()).findFirst().isPresent();
        return this.printDecoration && atLeastOnePrintableDecorator;
    }

    private Map<Position, IFigure> computeGroupDecorationsFigure(Map<Position, List<DecorationDescriptor>> decosDescAtPosition, int margin) {
        this.orderDecorationDescriptor(decosDescAtPosition);
        Dimension figureDimension = this.getFigureDimension(margin);
        Map<Position, Rectangle> groupBoundsAtPosition = this.initializeDisplayedDecoratorsGroup(decosDescAtPosition, figureDimension);
        HashMap<Position, List<Rectangle>> decosBoundsAtPosition = new HashMap<Position, List<Rectangle>>();
        IdentityHashMap<Rectangle, List<DecorationDescriptor>> decosBoundsToDecoDescriptors = new IdentityHashMap<Rectangle, List<DecorationDescriptor>>();
        HashMap decosBoundsPerDistribDirectionAtPosition = new HashMap();
        for (Position position : groupBoundsAtPosition.keySet()) {
            HashMap<DecorationDistributionDirection, ArrayList<Rectangle>> decoBBPerDistribDirection = new HashMap<DecorationDistributionDirection, ArrayList<Rectangle>>();
            decosBoundsPerDistribDirectionAtPosition.put(position, decoBBPerDistribDirection);
            ArrayList<Rectangle> brotherDecosBounds = new ArrayList<Rectangle>();
            ArrayList<Rectangle> decosHoriz = new ArrayList<Rectangle>();
            ArrayList<Rectangle> decosVert = new ArrayList<Rectangle>();
            decoBBPerDistribDirection.put(DecorationDistributionDirection.HORIZONTAL, decosHoriz);
            decoBBPerDistribDirection.put(DecorationDistributionDirection.VERTICAL, decosVert);
            Rectangle groupBounds = groupBoundsAtPosition.get(position);
            List<DecorationDescriptor> decoDescs = decosDescAtPosition.get(position);
            for (DecorationDescriptor decorationDescriptor : decoDescs) {
                IFigure decorationFigure = this.getDecorationFigure(decorationDescriptor, false);
                Rectangle decorationBounds = decorationFigure.getBounds();
                decorationBounds.x = 0;
                decorationBounds.y = 0;
                DecorationDistributionDirection distributionDirection = decorationDescriptor.getDistributionDirection();
                if (distributionDirection.equals((Object)DecorationDistributionDirection.HORIZONTAL)) {
                    this.addHorizontalDecoration(groupBounds, decorationBounds, decosHoriz, decosVert, position);
                } else if (distributionDirection.equals((Object)DecorationDistributionDirection.VERTICAL)) {
                    this.addVerticalDecoration(groupBounds, decorationBounds, decosHoriz, decosVert, position);
                }
                brotherDecosBounds.add(decorationBounds);
                decosBoundsToDecoDescriptors.put(decorationBounds, new ArrayList<DecorationDescriptor>(Arrays.asList(decorationDescriptor)));
                this.updateGroupBoundsSize(groupBounds, brotherDecosBounds);
            }
            this.updateGroupBoundsLocation(groupBounds, position, figureDimension);
            decosBoundsAtPosition.put(position, brotherDecosBounds);
        }
        List<Position> positionWithListDecoration = null;
        if (!DiagramUIPlugin.getPlugin().getDynamicPreferences().authorizeDecorationOverlap()) {
            positionWithListDecoration = this.mergeDecorationsInGoups(figureDimension, groupBoundsAtPosition, decosBoundsAtPosition, decosBoundsToDecoDescriptors, decosDescAtPosition);
            this.mergeGroups(figureDimension, groupBoundsAtPosition, decosBoundsAtPosition, decosBoundsToDecoDescriptors, decosDescAtPosition, positionWithListDecoration);
        }
        Map<Position, IFigure> figureAtPosition = this.createFigure(groupBoundsAtPosition, decosBoundsAtPosition, decosBoundsToDecoDescriptors, positionWithListDecoration);
        return figureAtPosition;
    }

    private Dimension getFigureDimension(int margin) {
        Dimension figureDimension = this.editPart.getFigure().getBounds().getSize().getCopy();
        if (this.editPart.getModel() instanceof Node) {
            try {
                LayoutConstraint layoutConstraint = ((Node)this.editPart.getModel()).getLayoutConstraint();
                if (layoutConstraint instanceof Bounds) {
                    int width = ((Bounds)layoutConstraint).getWidth();
                    int height = ((Bounds)layoutConstraint).getHeight();
                    if (width > 0) {
                        figureDimension.width = width;
                    }
                    if (height > 0) {
                        figureDimension.height = height;
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {}
        }
        figureDimension.width = figureDimension.width - 2 * margin >= 0 ? figureDimension.width - 2 * margin : 0;
        figureDimension.height = figureDimension.height - 2 * margin >= 0 ? figureDimension.height - 2 * margin : 0;
        return figureDimension;
    }

    private Map<Position, IFigure> createFigure(Map<Position, Rectangle> groupBoundsAtPosition, Map<Position, List<Rectangle>> decosBoundsAtPosition, Map<Rectangle, List<DecorationDescriptor>> decosBoundsToDecoDescriptors, List<Position> positionWithListDecoration) {
        HashMap<Position, IFigure> figureAtPosition = new HashMap<Position, IFigure>();
        for (Position position : groupBoundsAtPosition.keySet()) {
            Rectangle groupBounds = groupBoundsAtPosition.get(position);
            Figure groupFigure = new Figure();
            groupFigure.setSize(groupBounds.getSize());
            figureAtPosition.put(position, (IFigure)groupFigure);
            List<Rectangle> decosBounds = decosBoundsAtPosition.get(position);
            for (Rectangle rectangle : decosBounds) {
                List<DecorationDescriptor> decoDescs = decosBoundsToDecoDescriptors.get(rectangle);
                Object decorationFigure = null;
                if (positionWithListDecoration == null || !positionWithListDecoration.contains(position)) {
                    decorationFigure = this.getDecorationFigure(decoDescs.get(0), true);
                    decorationFigure.setBounds(rectangle);
                } else {
                    decorationFigure = new ListDecorationFigure(decoDescs);
                    decorationFigure.setBounds(rectangle);
                }
                groupFigure.add(decorationFigure);
            }
        }
        return figureAtPosition;
    }

    private void mergeGroups(Dimension figureDimension, Map<Position, Rectangle> groupBoundsAtPosition, Map<Position, List<Rectangle>> decosBoundsAtPosition, Map<Rectangle, List<DecorationDescriptor>> decosBoundsToDecoDescriptors, Map<Position, List<DecorationDescriptor>> positionToDecorators, List<Position> positionWithListDecoration) {
        ArrayList<Position> positionsToTest = new ArrayList<Position>(groupBoundsAtPosition.keySet());
        while (!positionsToTest.isEmpty()) {
            Position position = (Position)positionsToTest.get(0);
            positionsToTest.remove(position);
            Rectangle groupBounds = groupBoundsAtPosition.get(position);
            Iterator iterator = positionsToTest.iterator();
            while (iterator.hasNext()) {
                Position otherPosition = (Position)iterator.next();
                if (!groupBounds.intersects(groupBoundsAtPosition.get(otherPosition))) continue;
                iterator.remove();
                if (!positionWithListDecoration.contains(position)) {
                    positionWithListDecoration.add(position);
                    decosBoundsAtPosition.get(position).clear();
                    Rectangle listDecoBounds = new Rectangle(0, 0, LIST_DECORATION_SIZE.intValue(), LIST_DECORATION_SIZE.intValue());
                    this.updateGroupBoundsSize(groupBounds, new ArrayList<Rectangle>(Arrays.asList(listDecoBounds)));
                    this.updateGroupBoundsLocation(groupBounds, position, figureDimension);
                    decosBoundsAtPosition.get(position).add(listDecoBounds);
                    decosBoundsToDecoDescriptors.put(listDecoBounds, positionToDecorators.get(position));
                }
                Rectangle existingListDecoBounds = decosBoundsAtPosition.get(position).get(0);
                decosBoundsToDecoDescriptors.get(existingListDecoBounds).addAll((Collection<DecorationDescriptor>)positionToDecorators.get(otherPosition));
                groupBoundsAtPosition.remove(otherPosition);
                decosBoundsAtPosition.remove(otherPosition);
                positionToDecorators.remove(otherPosition);
                positionWithListDecoration.remove(otherPosition);
            }
        }
    }

    private List<Position> mergeDecorationsInGoups(Dimension figureDimension, Map<Position, Rectangle> groupBoundsAtPosition, Map<Position, List<Rectangle>> decosBoundsAtPosition, Map<Rectangle, List<DecorationDescriptor>> decosBoundsToDecoDescriptors, Map<Position, List<DecorationDescriptor>> decosDescAtPosition) {
        ArrayList<Position> positionWithListDecoration = new ArrayList<Position>();
        ArrayList<Rectangle> groupBBsToCompareOverlapWith = new ArrayList<Rectangle>(groupBoundsAtPosition.values());
        for (Position position : groupBoundsAtPosition.keySet()) {
            Rectangle groupBounds = groupBoundsAtPosition.get(position);
            boolean overlapFigure = false;
            ArrayList<Rectangle> overlappingGroupBBs = new ArrayList<Rectangle>();
            if (groupBounds.width > figureDimension.width || groupBounds.height > figureDimension.height()) {
                overlapFigure = true;
            } else {
                for (Rectangle bounds : groupBBsToCompareOverlapWith) {
                    if (!groupBounds.intersects(bounds) || groupBounds.equals((Object)bounds)) continue;
                    overlappingGroupBBs.add(bounds);
                }
            }
            if (overlappingGroupBBs.size() > 0 || overlapFigure) {
                if (groupBounds.height <= LIST_DECORATION_SIZE && groupBounds.width <= LIST_DECORATION_SIZE) continue;
                positionWithListDecoration.add(position);
                decosBoundsAtPosition.get(position).clear();
                Rectangle listDecoBounds = new Rectangle(0, 0, LIST_DECORATION_SIZE.intValue(), LIST_DECORATION_SIZE.intValue());
                this.updateGroupBoundsSize(groupBounds, new ArrayList<Rectangle>(Arrays.asList(listDecoBounds)));
                this.updateGroupBoundsLocation(groupBounds, position, figureDimension);
                decosBoundsAtPosition.get(position).add(listDecoBounds);
                decosBoundsToDecoDescriptors.put(listDecoBounds, decosDescAtPosition.get(position));
                continue;
            }
            groupBBsToCompareOverlapWith.remove(groupBounds);
        }
        return positionWithListDecoration;
    }

    private Map<Position, Rectangle> initializeDisplayedDecoratorsGroup(Map<Position, List<DecorationDescriptor>> positionToDecorators, Dimension figureDimension) {
        HashMap<Position, Rectangle> groupBoundsAtPosition = new HashMap<Position, Rectangle>();
        ArrayList<Position> positions = new ArrayList<Position>(positionToDecorators.keySet());
        Collections.sort(positions, (p1, p2) -> {
            int p1Priority = this.getPositionPriority((Position)p1);
            int p2Priority = this.getPositionPriority((Position)p2);
            return p2Priority - p1Priority;
        });
        for (Position position : positions) {
            Rectangle groupBounds = this.initializeDecorationsRelativeBoundsAtPosition(position, figureDimension);
            groupBoundsAtPosition.put(position, groupBounds);
        }
        return groupBoundsAtPosition;
    }

    private int getPositionPriority(Position position) {
        int priority = 0;
        switch (position.getValue()) {
            case 6: {
                priority = 1;
                break;
            }
            case 2: {
                priority = 2;
                break;
            }
            case 7: {
                priority = 3;
                break;
            }
            case 3: {
                priority = 4;
                break;
            }
            case 5: {
                priority = 5;
                break;
            }
            case 0: {
                priority = 6;
                break;
            }
            case 4: {
                priority = 7;
                break;
            }
            case 1: {
                priority = 8;
                break;
            }
            case 8: {
                priority = 9;
                break;
            }
        }
        return priority;
    }

    private void addVerticalDecoration(Rectangle groupBounds, Rectangle decorationBounds, List<Rectangle> decosHoriz, List<Rectangle> decosVert, Position position) {
        Rectangle previousDecoBoundsInTheDistribDirection = decosVert.size() > 0 ? decosVert.get(decosVert.size() - 1) : (decosHoriz.size() > 0 ? decosHoriz.get(0) : null);
        ArrayList<Rectangle> brotherDecosBounds = new ArrayList<Rectangle>(decosHoriz);
        brotherDecosBounds.addAll(decosVert);
        switch (position.getValue()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                if (previousDecoBoundsInTheDistribDirection == null) break;
                decorationBounds.y = previousDecoBoundsInTheDistribDirection.y + previousDecoBoundsInTheDistribDirection.height + SPACE;
                break;
            }
            case 6: 
            case 7: {
                if (previousDecoBoundsInTheDistribDirection == null) break;
                int yShift = previousDecoBoundsInTheDistribDirection.y - decorationBounds.height;
                decorationBounds.y = Math.max(0, yShift);
                int yShiftExistingFigureInGroup = Math.max(0, -yShift);
                for (Rectangle decoBounds : brotherDecosBounds) {
                    decoBounds.y = decoBounds.y + SPACE + yShiftExistingFigureInGroup;
                }
                break;
            }
        }
        switch (position.getValue()) {
            case 3: 
            case 5: 
            case 7: {
                int xShift = groupBounds.width - decorationBounds.width;
                decorationBounds.x = Math.max(0, xShift);
                int xShiftExistingFigureInGroup = Math.max(0, -xShift);
                for (Rectangle decoBounds : brotherDecosBounds) {
                    decoBounds.x += xShiftExistingFigureInGroup;
                }
                break;
            }
        }
        decosVert.add(decorationBounds);
    }

    private void addHorizontalDecoration(Rectangle groupBounds, Rectangle decorationBounds, List<Rectangle> decosHoriz, List<Rectangle> decosVert, Position position) {
        Rectangle previousDecoBoundsInTheDistribDirection = decosHoriz.size() > 0 ? decosHoriz.get(decosHoriz.size() - 1) : (decosVert.size() > 0 ? decosVert.get(0) : null);
        ArrayList<Rectangle> brotherDecosBounds = new ArrayList<Rectangle>(decosHoriz);
        brotherDecosBounds.addAll(decosVert);
        switch (position.getValue()) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                if (previousDecoBoundsInTheDistribDirection == null) break;
                decorationBounds.x = previousDecoBoundsInTheDistribDirection != null ? previousDecoBoundsInTheDistribDirection.x + SPACE + previousDecoBoundsInTheDistribDirection.width : 0;
                break;
            }
            case 5: 
            case 7: {
                if (previousDecoBoundsInTheDistribDirection == null) break;
                int xShift = previousDecoBoundsInTheDistribDirection.x - decorationBounds.width;
                decorationBounds.x = Math.max(0, xShift);
                int xShiftExistingFigureInGroup = Math.max(0, -xShift);
                for (Rectangle decoBounds : brotherDecosBounds) {
                    decoBounds.x = decoBounds.x + SPACE + xShiftExistingFigureInGroup;
                }
                break;
            }
        }
        switch (position.getValue()) {
            case 2: 
            case 6: 
            case 7: {
                int yShift = groupBounds.height - decorationBounds.height;
                decorationBounds.y = Math.max(0, yShift);
                int yShiftExistingFigureInGroup = Math.max(0, -yShift);
                for (Rectangle decoBounds : brotherDecosBounds) {
                    decoBounds.y += yShiftExistingFigureInGroup;
                }
                break;
            }
        }
        decosHoriz.add(decorationBounds);
    }

    private void orderDecorationDescriptor(Map<Position, List<DecorationDescriptor>> positionToDecorators) {
        for (Position position : positionToDecorators.keySet()) {
            List<DecorationDescriptor> decoDescriptors = positionToDecorators.get(position);
            Collections.sort(decoDescriptors, new Comparator<DecorationDescriptor>(){

                @Override
                public int compare(DecorationDescriptor d1, DecorationDescriptor d2) {
                    int diff = d1.getDisplayPriority() - d2.getDisplayPriority();
                    if (diff == 0) {
                        diff = d1.getName().compareTo(d2.getName());
                    }
                    return diff;
                }
            });
        }
    }

    private IFigure getDecorationFigure(DecorationDescriptor decorationDescriptor, boolean withTooltip) {
        Object figure = null;
        IFigure innerFigure = null;
        Image decorationAsImage = decorationDescriptor.getDecorationAsImage();
        if (decorationAsImage != null) {
            IMapMode mm = MapModeUtil.getMapMode((IFigure)this.editPart.getFigure());
            ImageFigureEx figureImage = new ImageFigureEx();
            figureImage.setImage(decorationAsImage);
            figureImage.setSize(mm.DPtoLP(decorationAsImage.getBounds().width), mm.DPtoLP(decorationAsImage.getBounds().height));
            innerFigure = figureImage;
        } else {
            innerFigure = decorationDescriptor.getDecorationAsFigure();
        }
        if (withTooltip) {
            if (innerFigure != null) {
                innerFigure.setLocation(new Point(0, 0));
                figure = new FigureWithLazyTooltip(decorationDescriptor);
                figure.setSize(innerFigure.getSize());
                figure.setLayoutManager((LayoutManager)new BorderLayout());
                figure.add(innerFigure, (Object)BorderLayout.LEFT);
            }
        } else {
            figure = innerFigure;
        }
        return figure;
    }

    private IFigure getDecorationFigureForTooltip(DecorationDescriptor decorationDescriptor) {
        Object figure = null;
        Image decorationAsImage = decorationDescriptor.getDecorationAsImage();
        figure = decorationAsImage != null ? new Label("", decorationAsImage) : decorationDescriptor.getDecorationAsFigure();
        return figure;
    }

    private IFigure getDecorationTooltip(DecorationDescriptor decorationDescriptor) {
        IFigure tooltipFigure = null;
        IFigure tooltipAsFigure = decorationDescriptor.getTooltipAsFigure();
        if (tooltipAsFigure != null) {
            tooltipFigure = tooltipAsFigure;
        } else {
            String tooltipAsString = decorationDescriptor.getTooltipAsString();
            if (!StringUtil.isEmpty((String)tooltipAsString)) {
                tooltipFigure = new Label(tooltipAsString);
            }
        }
        return tooltipFigure;
    }

    private Rectangle initializeDecorationsRelativeBoundsAtPosition(Position position, Dimension figureDimension) {
        int x = 0;
        int y = 0;
        switch (position.getValue()) {
            case 0: 
            case 2: 
            case 8: {
                x = figureDimension.width / 2;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                x = figureDimension.width;
                break;
            }
        }
        switch (position.getValue()) {
            case 1: 
            case 3: 
            case 8: {
                y = figureDimension.height / 2;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                y = figureDimension.height;
                break;
            }
        }
        return new Rectangle(x, y, 0, 0);
    }

    private void updateGroupBoundsSize(Rectangle groupBounds, Iterable<Rectangle> decoBBsInGroup) {
        groupBounds.width = 0;
        groupBounds.height = 0;
        for (Rectangle decoBound : decoBBsInGroup) {
            groupBounds.width = Math.max(groupBounds.width, decoBound.x + decoBound.width);
            groupBounds.height = Math.max(groupBounds.height, decoBound.y + decoBound.height);
        }
    }

    private void updateGroupBoundsLocation(Rectangle groupBounds, Position position, Dimension figureDimension) {
        switch (position.getValue()) {
            case 0: 
            case 2: 
            case 8: {
                groupBounds.x = (figureDimension.width - groupBounds.width) / 2;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                groupBounds.x = figureDimension.width - groupBounds.width;
                break;
            }
        }
        switch (position.getValue()) {
            case 1: 
            case 3: 
            case 8: {
                groupBounds.y = (figureDimension.height - groupBounds.height) / 2;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                groupBounds.y = figureDimension.height - groupBounds.height;
                break;
            }
        }
    }

    public List<IDecoration> getDecorations() {
        return this.decorations;
    }

    public void addDecoration(IDecoration decoration) {
        this.decorations.add(decoration);
    }

    private void removeDecorations() {
        for (IDecoration decoration : this.decorations) {
            GraphicalEditPart ownerEditPart;
            if (decoration instanceof IFigure && ((IFigure)decoration).getParent() != null) {
                ((IFigure)decoration).getParent().remove((IFigure)decoration);
            }
            if ((ownerEditPart = (GraphicalEditPart)this.getDecoratorTarget().getAdapter(GraphicalEditPart.class)) == null || ownerEditPart.getRoot() == null || ownerEditPart.getViewer() == null) continue;
            ownerEditPart.getViewer().getVisualPartMap().remove(decoration);
        }
        this.decorations = new ArrayList<IDecoration>();
    }

    private IDecoratorTarget.Direction getGMFPosition(Position position) {
        IDecoratorTarget.Direction direction = IDecoratorTarget.Direction.SOUTH_WEST;
        switch (position.getValue()) {
            case 8: {
                direction = IDecoratorTarget.Direction.CENTER;
                break;
            }
            case 0: {
                direction = IDecoratorTarget.Direction.NORTH;
                break;
            }
            case 2: {
                direction = IDecoratorTarget.Direction.SOUTH;
                break;
            }
            case 1: {
                direction = IDecoratorTarget.Direction.WEST;
                break;
            }
            case 3: {
                direction = IDecoratorTarget.Direction.EAST;
                break;
            }
            case 5: {
                direction = IDecoratorTarget.Direction.NORTH_EAST;
                break;
            }
            case 4: {
                direction = IDecoratorTarget.Direction.NORTH_WEST;
                break;
            }
            case 7: {
                direction = IDecoratorTarget.Direction.SOUTH_EAST;
                break;
            }
            case 6: {
                direction = IDecoratorTarget.Direction.SOUTH_WEST;
                break;
            }
        }
        return direction;
    }

    private class FigureWithLazyTooltip
    extends Figure {
        private DecorationDescriptor decoDescriptor;

        FigureWithLazyTooltip(DecorationDescriptor decorationDescriptor) {
            this.decoDescriptor = decorationDescriptor;
        }

        public IFigure getToolTip() {
            if (this.toolTip == null) {
                this.toolTip = SiriusGenericDecorator.this.getDecorationTooltip(this.decoDescriptor);
            }
            return this.toolTip;
        }
    }

    private class ListDecorationFigure
    extends RectangleFigure {
        private List<DecorationDescriptor> decoDescriptors;

        ListDecorationFigure(List<DecorationDescriptor> decoDescriptors) {
            this.decoDescriptors = decoDescriptors;
        }

        public void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            Rectangle bounds = this.getBounds();
            graphics.setForegroundColor(ColorConstants.black);
            graphics.drawText("...", new Point(bounds.x + 3, bounds.y - bounds.height / 2));
        }

        public IFigure getToolTip() {
            if (this.toolTip == null) {
                Figure composite = new Figure();
                GridLayout fl = new GridLayout(2, false);
                fl.horizontalSpacing = 1;
                fl.verticalSpacing = 1;
                composite.setLayoutManager((LayoutManager)fl);
                for (DecorationDescriptor decoDescriptor : this.decoDescriptors) {
                    IFigure decorationFigureForTooltip = SiriusGenericDecorator.this.getDecorationFigureForTooltip(decoDescriptor);
                    if (decorationFigureForTooltip == null) continue;
                    composite.add(decorationFigureForTooltip);
                    IFigure decorationTooltip = SiriusGenericDecorator.this.getDecorationTooltip(decoDescriptor);
                    if (decorationTooltip != null) {
                        composite.add(SiriusGenericDecorator.this.getDecorationTooltip(decoDescriptor));
                        continue;
                    }
                    composite.add((IFigure)new Figure());
                }
                this.toolTip = composite;
            }
            return this.toolTip;
        }
    }
}

