/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalCreator;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalPriorities;
import org.eclipse.xtext.ide.editor.contentassist.IdeCrossrefProposalProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.CurrentTypeFinder;

public class IdeContentProposalProvider {
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IScopeProvider scopeProvider;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IdeCrossrefProposalProvider crossrefProposalProvider;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IdeContentProposalCreator proposalCreator;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private IdeContentProposalPriorities proposalPriorities;
    @Inject
    @Extension
    private CurrentTypeFinder _currentTypeFinder;

    public void createProposals(Collection<ContentAssistContext> contexts, IIdeContentProposalAcceptor acceptor) {
        Iterable<ContentAssistContext> _filteredContexts = this.getFilteredContexts(contexts);
        for (ContentAssistContext context : _filteredContexts) {
            ImmutableList<AbstractElement> _firstSetGrammarElements = context.getFirstSetGrammarElements();
            for (AbstractElement element : _firstSetGrammarElements) {
                boolean _not;
                boolean _canAcceptMoreProposals = acceptor.canAcceptMoreProposals();
                boolean bl = _not = !_canAcceptMoreProposals;
                if (_not) {
                    return;
                }
                this.createProposals(element, context, acceptor);
            }
        }
    }

    protected Iterable<ContentAssistContext> getFilteredContexts(Collection<ContentAssistContext> contexts) {
        return contexts;
    }

    protected void _createProposals(AbstractElement element, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
    }

    protected void _createProposals(Assignment assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        AbstractRule rule;
        AbstractElement terminal = assignment.getTerminal();
        if (terminal instanceof CrossReference) {
            this.createProposals(terminal, context, acceptor);
        } else if (terminal instanceof RuleCall && (rule = ((RuleCall)terminal).getRule()) instanceof TerminalRule && context.getPrefix().isEmpty()) {
            String _xifexpression = null;
            String _name = rule.getName();
            boolean _equals = Objects.equal((Object)_name, (Object)"STRING");
            if (_equals) {
                String _feature = assignment.getFeature();
                String _plus = "\"" + _feature;
                _xifexpression = _plus + "\"";
            } else {
                _xifexpression = assignment.getFeature();
            }
            String proposal = _xifexpression;
            Procedures.Procedure1 _function = it -> {
                String _name_1 = rule.getName();
                boolean _equals_1 = Objects.equal((Object)_name_1, (Object)"STRING");
                if (_equals_1) {
                    ArrayList<TextRegion> _editPositions = it.getEditPositions();
                    int _offset = context.getOffset();
                    int _plus_1 = _offset + 1;
                    int _length = proposal.length();
                    int _minus = _length - 2;
                    TextRegion _textRegion = new TextRegion(_plus_1, _minus);
                    _editPositions.add(_textRegion);
                    it.setKind("TEXT");
                } else {
                    ArrayList<TextRegion> _editPositions_1 = it.getEditPositions();
                    int _offset_1 = context.getOffset();
                    int _length_1 = proposal.length();
                    TextRegion _textRegion_1 = new TextRegion(_offset_1, _length_1);
                    _editPositions_1.add(_textRegion_1);
                    it.setKind("VALUE");
                }
                it.setDescription(rule.getName());
            };
            ContentAssistEntry entry = this.proposalCreator.createProposal(proposal, context, (Procedures.Procedure1<? super ContentAssistEntry>)_function);
            acceptor.accept(entry, this.proposalPriorities.getDefaultPriority(entry));
        }
    }

    protected void _createProposals(Keyword keyword, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        ContentAssistEntry entry;
        boolean _filterKeyword = this.filterKeyword(keyword, context);
        if (_filterKeyword && (entry = this.proposalCreator.createProposal(keyword.getValue(), context)) != null) {
            entry.setKind("KEYWORD");
            acceptor.accept(entry, this.proposalPriorities.getKeywordPriority(keyword.getValue(), entry));
        }
    }

    protected boolean filterKeyword(Keyword keyword, ContentAssistContext context) {
        return true;
    }

    protected void _createProposals(RuleCall ruleCall, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
    }

    protected void _createProposals(CrossReference reference, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        EClassifier type = this._currentTypeFinder.findCurrentTypeAfter((AbstractElement)reference);
        if (type instanceof EClass) {
            EReference ereference = GrammarUtil.getReference((CrossReference)reference, (EClass)((EClass)type));
            EObject currentModel = context.getCurrentModel();
            if (ereference != null && currentModel != null) {
                IScope scope = this.scopeProvider.getScope(currentModel, ereference);
                this.crossrefProposalProvider.lookupCrossReference(scope, reference, context, acceptor, this.getCrossrefFilter(reference, context));
            }
        }
    }

    protected Predicate<IEObjectDescription> getCrossrefFilter(CrossReference reference, ContentAssistContext context) {
        return Predicates.alwaysTrue();
    }

    protected void createProposals(AbstractElement assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        if (assignment instanceof Assignment) {
            this._createProposals((Assignment)assignment, context, acceptor);
            return;
        }
        if (assignment instanceof CrossReference) {
            this._createProposals((CrossReference)assignment, context, acceptor);
            return;
        }
        if (assignment instanceof Keyword) {
            this._createProposals((Keyword)assignment, context, acceptor);
            return;
        }
        if (assignment instanceof RuleCall) {
            this._createProposals((RuleCall)assignment, context, acceptor);
            return;
        }
        if (assignment != null) {
            this._createProposals(assignment, context, acceptor);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(assignment, context, acceptor).toString());
    }

    @Pure
    protected IScopeProvider getScopeProvider() {
        return this.scopeProvider;
    }

    @Pure
    protected IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    @Pure
    protected IdeCrossrefProposalProvider getCrossrefProposalProvider() {
        return this.crossrefProposalProvider;
    }

    @Pure
    protected IdeContentProposalCreator getProposalCreator() {
        return this.proposalCreator;
    }

    @Pure
    protected IdeContentProposalPriorities getProposalPriorities() {
        return this.proposalPriorities;
    }
}

