/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.scrutiny.visitor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class EObjectVisitor {
    Set<Resource> visitedResources = new HashSet<Resource>();
    Set<EObject> visitedEObjects = new HashSet<EObject>();

    public void accept(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.visitedResources.contains(resource)) {
            return;
        }
        this.visitedResources.add(resource);
        if (!this.visit(resource)) {
            return;
        }
        TreeIterator i = resource.getAllContents();
        while (i.hasNext()) {
            EObject eObject = (EObject)i.next();
            this.internalAccept(eObject);
        }
        this.visited(resource);
    }

    public void accept(EObject eObject) {
        this.internalAccept(eObject);
        TreeIterator i = eObject.eAllContents();
        while (i.hasNext()) {
            EObject childEObject = (EObject)i.next();
            this.internalAccept(childEObject);
        }
    }

    protected void internalAccept(EObject eObject) {
        if (eObject == null) {
            return;
        }
        if (this.visitedEObjects.contains(eObject)) {
            return;
        }
        this.visitedEObjects.add(eObject);
        if (!this.visit(eObject)) {
            return;
        }
        this.accept(eObject.eResource());
        for (EObject crossReferencedEObject : eObject.eCrossReferences()) {
            this.internalAccept(crossReferencedEObject);
        }
        this.visited(eObject);
    }

    public boolean visit(EObject eObject) {
        return true;
    }

    public boolean visit(Resource resource) {
        return true;
    }

    public abstract void visited(EObject var1);

    public abstract void visited(Resource var1);
}

