/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.editparts;

import java.util.Iterator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures.GeoShapeFigure;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures.GeoShapeRoundedRectangleFigure;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.editparts.GeoShapeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.RoundedRectangleBorder;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RoundedCornersStyle;
import org.eclipse.gmf.runtime.notation.View;

public class RoundedRectangleEditPart
extends GeoShapeEditPart {
    public RoundedRectangleEditPart(View shapeView) {
        super(shapeView);
    }

    protected NodeFigure createNodeFigure() {
        GeoShapeRoundedRectangleFigure nodeFigure = new GeoShapeRoundedRectangleFigure(this.getMapMode().DPtoLP(100), this.getMapMode().DPtoLP(50), this.getMapMode().DPtoLP(5));
        RoundedRectangleBorder border = new RoundedRectangleBorder(this.getMapMode().DPtoLP(8), this.getMapMode().DPtoLP(8));
        border.setWidth(this.getMapMode().DPtoLP(this.getLineWidth()));
        border.setStyle(this.getLineType());
        nodeFigure.setBorder((Border)border);
        return nodeFigure;
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.Literals.ROUNDED_CORNERS_STYLE__ROUNDED_BENDPOINTS_RADIUS == feature) {
            this.refreshRoundedCorners();
        }
        super.handleNotificationEvent(notification);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshRoundedCorners();
    }

    protected void refreshRoundedCorners() {
        RoundedCornersStyle style = (RoundedCornersStyle)((View)this.getModel()).getStyle(NotationPackage.Literals.ROUNDED_CORNERS_STYLE);
        if (style != null && this.getNodeFigure().getBorder() instanceof RoundedRectangleBorder) {
            RoundedRectangleBorder border = (RoundedRectangleBorder)this.getNodeFigure().getBorder();
            int radius = this.getMapMode().DPtoLP(style.getRoundedBendpointsRadius());
            border.setArcWidth(radius * 2);
            border.setArcHeight(radius * 2);
            this.getFigure().repaint();
        }
        this.refreshConnections();
    }

    protected void refreshConnections() {
        Iterator conns = this.getTargetConnections().iterator();
        while (conns.hasNext()) {
            ((Connection)((ConnectionEditPart)conns.next()).getFigure()).revalidate();
        }
        conns = this.getSourceConnections().iterator();
        while (conns.hasNext()) {
            ((Connection)((ConnectionEditPart)conns.next()).getFigure()).revalidate();
        }
    }

    protected void setLineWidth(int width) {
        if (width < 0) {
            width = 1;
        }
        super.setLineWidth(width);
        LineBorder lineBorder = (LineBorder)this.getNodeFigure().getBorder();
        lineBorder.setWidth(this.getMapMode().DPtoLP(width));
        this.getFigure().revalidate();
    }

    protected void setLineType(int lineType) {
        super.setLineType(lineType);
        LineBorder lineBorder = (LineBorder)this.getNodeFigure().getBorder();
        lineBorder.setStyle(lineType);
    }

    public IFigure getContentPane() {
        return ((GeoShapeFigure)this.getFigure()).getContentPane();
    }

    public boolean supportsRoundedCorners() {
        return true;
    }
}

