/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;

public abstract class WorkspacePluginModelBase
extends AbstractPluginModelBase
implements IEditableModel {
    private static final long serialVersionUID = 1L;
    private final IFile fUnderlyingResource;
    private boolean fDirty;
    private boolean fEditable = true;

    @Override
    protected NLResourceHelper createNLResourceHelper() {
        return new NLResourceHelper("plugin", PDEManager.getNLLookupLocations(this));
    }

    @Override
    @Deprecated
    public URL getNLLookupLocation() {
        try {
            return new URL("file:" + this.getInstallLocation() + "/");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public WorkspacePluginModelBase(IFile file, boolean abbreviated) {
        this.fUnderlyingResource = file;
        this.fAbbreviated = abbreviated;
        this.setEnabled(true);
    }

    @Override
    public void fireModelChanged(IModelChangedEvent event) {
        this.fDirty = true;
        super.fireModelChanged(event);
    }

    @Override
    @Deprecated
    public IBuildModel getBuildModel() {
        return null;
    }

    /*
     * Loose catch block
     */
    public String getContents() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                String string;
                PrintWriter writer;
                StringWriter swriter;
                block18: {
                    swriter = new StringWriter();
                    writer = new PrintWriter(swriter);
                    this.save(writer);
                    writer.flush();
                    string = swriter.toString();
                    if (writer != null) {
                        writer.close();
                    }
                    if (swriter == null) break block18;
                    swriter.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (swriter != null) {
                                swriter.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
            return "";
        }
    }

    public IFile getFile() {
        return this.fUnderlyingResource;
    }

    @Override
    public String getInstallLocation() {
        IPath path = this.fUnderlyingResource.getLocation();
        return path == null ? null : path.removeLastSegments(1).addTrailingSeparator().toOSString();
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.fUnderlyingResource;
    }

    @Override
    public boolean isInSync() {
        if (this.fUnderlyingResource == null) {
            return true;
        }
        IPath path = this.fUnderlyingResource.getLocation();
        if (path == null) {
            return false;
        }
        return super.isInSync(path.toFile());
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    @Override
    public boolean isEditable() {
        return this.fEditable;
    }

    @Override
    public void load() {
        if (this.fUnderlyingResource == null) {
            return;
        }
        if (this.fUnderlyingResource.exists()) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedInputStream stream = new BufferedInputStream(this.fUnderlyingResource.getContents(true));){
                    this.load(stream, false);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                PDECore.logException(e);
            }
        } else {
            this.fPluginBase = this.createPluginBase();
            this.setLoaded(true);
        }
    }

    @Override
    protected void updateTimeStamp() {
        this.updateTimeStamp(this.fUnderlyingResource.getLocation().toFile());
    }

    @Override
    public void save() {
        if (this.fUnderlyingResource == null) {
            return;
        }
        String contents = WorkspacePluginModelBase.fixLineDelimiter(this.getContents(), this.fUnderlyingResource);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));){
                if (this.fUnderlyingResource.exists()) {
                    this.fUnderlyingResource.setContents((InputStream)stream, false, false, null);
                } else {
                    this.fUnderlyingResource.create((InputStream)stream, false, null);
                }
                stream.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            PDECore.logException(e);
        }
    }

    @Override
    public void save(PrintWriter writer) {
        if (this.isLoaded()) {
            this.fPluginBase.write("", writer);
        }
        this.fDirty = false;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public void setEditable(boolean editable) {
        this.fEditable = editable;
    }
}

