/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.transformation.trace;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.polarsys.kitalpha.transposer.transformation.trace.Trace;

public class TraceHelper {
    private List<Trace> traces = new ArrayList<Trace>();

    public void reset() {
        this.traces = new ArrayList<Trace>();
    }

    public void addTraceWithRole(Object source_p, Object target_p, String role_p) {
        for (Trace trace : this.traces) {
            if (trace.getSource() == null || !trace.getSource().equals(source_p) || trace.getRole() == null || !trace.getRole().equals(role_p)) continue;
            this.traces.remove(trace);
            break;
        }
        Trace temp = new Trace(source_p, target_p, role_p);
        this.traces.add(temp);
    }

    public List<Trace> getOutgoingTraces(Object source) {
        ArrayList<Trace> outgoingTraces = new ArrayList<Trace>();
        for (Trace trace : this.traces) {
            if (trace.getSource() == null || !trace.getSource().equals(source)) continue;
            outgoingTraces.add(trace);
        }
        return outgoingTraces;
    }

    public List<Trace> getOutgoingTracesWithRole(Object source_p, String string_p) {
        ArrayList<Trace> matchingTraces = new ArrayList<Trace>();
        for (Trace trace : this.traces) {
            if (trace.getSource() == null || !trace.getSource().equals(source_p) || trace.getRole() == null || !trace.getRole().equals(string_p)) continue;
            matchingTraces.add(trace);
        }
        return matchingTraces;
    }

    public List<Trace> getIncomingTraces(Object target) {
        ArrayList<Trace> incomingTraces = new ArrayList<Trace>();
        for (Trace trace : this.traces) {
            if (trace.getTarget() == null || !trace.getTarget().equals(target)) continue;
            incomingTraces.add(trace);
        }
        return incomingTraces;
    }

    public Trace getOutgoingTraceWithRole(Object source_p, String string_p) {
        for (Trace trace : this.traces) {
            if (trace.getSource() == null || !trace.getSource().equals(source_p) || trace.getRole() == null || !trace.getRole().equals(string_p)) continue;
            return trace;
        }
        return null;
    }

    public List<Trace> getIncomingTracesWithRole(Object target_p, String string_p) {
        ArrayList<Trace> matchingTraces = new ArrayList<Trace>();
        for (Trace trace : this.traces) {
            if (trace.getTarget() == null || !trace.getTarget().equals(target_p) || trace.getRole() == null || !trace.getRole().equals(string_p)) continue;
            matchingTraces.add(trace);
        }
        return matchingTraces;
    }

    public Trace getIncomingTraceWithRole(Object target_p, String string_p) {
        for (Trace trace : this.traces) {
            if (trace.getTarget() == null || !trace.getTarget().equals(target_p) || trace.getRole() == null || !trace.getRole().equals(string_p)) continue;
            return trace;
        }
        return null;
    }

    public boolean isResultOfMergeWithRole(Object element, String role) {
        return this.getIncomingTracesWithRole(element, role).size() > 1;
    }

    public void removeTrace(Trace t) {
        this.traces.remove(t);
    }

    public void removeAllOutgoingTraces(Object object_p) {
        List<Trace> outgoing = this.getOutgoingTraces(object_p);
        for (Trace trace : outgoing) {
            this.removeTrace(trace);
        }
    }

    public void removeAllIncomingTraces(Object object_p) {
        List<Trace> incoming = this.getIncomingTraces(object_p);
        for (Trace trace : incoming) {
            this.removeTrace(trace);
        }
    }

    public void removeOutGoingTraces(Object object_p, String role) {
        List<Trace> outgoing = this.getOutgoingTraces(object_p);
        for (Trace trace : outgoing) {
            if (!trace.getRole().equals(role)) continue;
            this.removeTrace(trace);
        }
    }

    public void removeAllTraces(Object object_p) {
        this.removeAllIncomingTraces(object_p);
        this.removeAllOutgoingTraces(object_p);
    }

    public Set<Object> getAllUniqueKeys() {
        HashSet<Object> set = new HashSet<Object>();
        for (Trace trace : this.traces) {
            set.add(trace.getSource());
        }
        return set;
    }

    public List<Trace> getTraces() {
        return this.traces;
    }
}

