/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.common.sirius.extension.rotativeimage;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.polarsys.kitalpha.common.sirius.extension.internal.rotativeimage.Activator;

public class RotativeWorkspaceImageHelper {
    public static Image getImage(String path, int orientation) {
        String key = RotativeWorkspaceImageHelper.getKey(path, orientation);
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(key);
        if (image != null) {
            return image;
        }
        switch (orientation) {
            case 1: {
                image = WorkspaceImageFigure.flyWeightImage((String)path);
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                image = RotativeWorkspaceImageHelper.rotate(RotativeWorkspaceImageHelper.getImage(path, 1), orientation);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid orientation");
            }
        }
        if (image != null) {
            registry.put(key, image);
        }
        return image;
    }

    static void createImage(String mainPath, String path, int orientation) {
        String key = RotativeWorkspaceImageHelper.getKey(mainPath, orientation);
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(key);
        if (image == null) {
            image = WorkspaceImageFigure.flyWeightImage((String)path);
            registry.put(key, image);
        }
    }

    @Deprecated
    static void putImage(String path, int orientation, Image image) {
        Activator.getDefault().getImageRegistry().put(RotativeWorkspaceImageHelper.getKey(path, orientation), image);
    }

    private static Image rotate(Image image, int orientation) {
        if (image == null) {
            return null;
        }
        ImageData srcData = image.getImageData();
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = orientation == 4 ? srcData.width * bytesPerPixel : srcData.height * bytesPerPixel;
        byte[] newData = new byte[srcData.data.length];
        boolean isAlpha = srcData.alphaData != null;
        byte[] newAlphaData = null;
        if (isAlpha) {
            newAlphaData = new byte[srcData.alphaData.length];
        }
        ImageData imgData = new ImageData(orientation == 4 ? srcData.width : srcData.height, orientation == 4 ? srcData.height : srcData.width, srcData.depth, srcData.palette, destBytesPerLine, newData);
        if (isAlpha) {
            imgData.alphaData = newAlphaData;
        }
        imgData.alpha = srcData.alpha;
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX = 0;
                int destY = 0;
                switch (orientation) {
                    case 8: {
                        destX = srcY;
                        destY = srcData.width - srcX - 1;
                        break;
                    }
                    case 16: {
                        destX = srcData.height - srcY - 1;
                        destY = srcX;
                        break;
                    }
                    case 4: {
                        destX = srcData.width - srcX - 1;
                        destY = srcData.height - srcY - 1;
                    }
                }
                imgData.setPixel(destX, destY, srcData.getPixel(srcX, srcY));
                if (isAlpha) {
                    imgData.setAlpha(destX, destY, srcData.getAlpha(srcX, srcY));
                }
                ++srcX;
            }
            ++srcY;
        }
        return new Image(image.getDevice(), imgData);
    }

    private static String getKey(String path, int orientation) {
        return String.valueOf(path) + orientation;
    }
}

