/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;

public class LogicalStructureCache {
    private Map<ILogicalStructureType, LogicalStructureTypeCache> fCacheForType = new HashMap<ILogicalStructureType, LogicalStructureTypeCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValue getLogicalStructure(ILogicalStructureType type, IValue value) throws CoreException {
        Map<ILogicalStructureType, LogicalStructureTypeCache> map = this.fCacheForType;
        synchronized (map) {
            LogicalStructureTypeCache cache = this.getCacheForType(type);
            return cache.getLogicalStructure(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<ILogicalStructureType, LogicalStructureTypeCache> map = this.fCacheForType;
        synchronized (map) {
            this.fCacheForType.clear();
        }
    }

    protected LogicalStructureTypeCache getCacheForType(ILogicalStructureType type) {
        LogicalStructureTypeCache cache = this.fCacheForType.get(type);
        if (cache == null) {
            cache = new LogicalStructureTypeCache(type);
            this.fCacheForType.put(type, cache);
        }
        return cache;
    }

    class LogicalStructureTypeCache {
        private ILogicalStructureType fType;
        private Map<IValue, IValue> fKnownValues = new HashMap<IValue, IValue>();
        private Set<IValue> fPendingValues = new HashSet<IValue>();

        public LogicalStructureTypeCache(ILogicalStructureType type) {
            this.fType = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IValue getLogicalStructure(IValue value) throws CoreException {
            Set<IValue> set;
            IValue iValue;
            Object object = this.fKnownValues;
            synchronized (object) {
                IValue logical = this.fKnownValues.get(value);
                if (logical != null) {
                    return logical;
                }
            }
            object = this.fPendingValues;
            synchronized (object) {
                if (this.fPendingValues.contains(value)) {
                    try {
                        this.fPendingValues.wait();
                        return this.getLogicalStructure(value);
                    }
                    catch (InterruptedException e) {
                        throw new CoreException((IStatus)new Status(8, DebugUIPlugin.getUniqueIdentifier(), VariablesViewMessages.LogicalStructureCache_0, (Throwable)e));
                    }
                }
                this.fPendingValues.add(value);
            }
            try {
                IValue result = this.fType.getLogicalStructure(value);
                Map<IValue, IValue> map = this.fKnownValues;
                synchronized (map) {
                    this.fKnownValues.put(value, result);
                }
                iValue = result;
                set = this.fPendingValues;
            }
            catch (Throwable throwable) {
                Set<IValue> set2 = this.fPendingValues;
                synchronized (set2) {
                    this.fPendingValues.remove(value);
                    this.fPendingValues.notifyAll();
                }
                throw throwable;
            }
            synchronized (set) {
                this.fPendingValues.remove(value);
                this.fPendingValues.notifyAll();
            }
            return iValue;
        }
    }
}

