/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import com.google.common.annotations.Beta;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.ui.wizard.template.IFileGenerator;
import org.eclipse.xtext.util.StringInputStream;

@Beta
public class WorkspaceFileGenerator
extends WorkspaceModifyOperation
implements IFileGenerator {
    private final SortedMap<String, CharSequence> files = new TreeMap<String, CharSequence>();
    private IFile firstFile;

    @Override
    public void generate(CharSequence path, CharSequence content) {
        this.files.put(path.toString(), content);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.files.size());
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            for (Map.Entry<String, CharSequence> fileEntry : this.files.entrySet()) {
                IFile file = workspace.getRoot().getFile((IPath)new Path(fileEntry.getKey()));
                file.create((InputStream)new StringInputStream(fileEntry.getValue().toString()), true, (IProgressMonitor)subMonitor);
                if (this.firstFile == null) {
                    this.firstFile = file;
                }
                subMonitor.worked(1);
            }
        }
        finally {
            subMonitor.done();
        }
    }

    public IFile getResult() {
        return this.firstFile;
    }
}

