/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.generic.api.IDataPolicy;
import org.eclipse.emf.diffmerge.generic.impl.scopes.AbstractDataScope;
import org.eclipse.emf.diffmerge.impl.policies.ModelDataPolicy;
import org.eclipse.emf.diffmerge.impl.scopes.ModelScopeIterator;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class AbstractModelScope
extends AbstractDataScope<EObject>
implements IFeaturedModelScope {
    protected AbstractModelScope() {
    }

    protected IDataPolicy<EObject> defineDataPolicy() {
        return ModelDataPolicy.getInstance();
    }

    @Override
    public List<EObject> get(EObject source_p, EReference reference_p) {
        return this.get(source_p, reference_p, this.resolveProxies());
    }

    protected List<EObject> get(EObject source_p, EReference reference_p, boolean resolveProxies_p) {
        List<Object> result = Collections.emptyList();
        try {
            if (source_p.eIsSet((EStructuralFeature)reference_p)) {
                Object value = source_p.eGet((EStructuralFeature)reference_p, resolveProxies_p);
                if (FeatureMapUtil.isMany((EObject)source_p, (EStructuralFeature)reference_p)) {
                    List values = (List)value;
                    if (!resolveProxies_p && values instanceof InternalEList) {
                        values = ((InternalEList)values).basicList();
                    }
                    result = Collections.unmodifiableList(values);
                } else if (value != null) {
                    result = Collections.singletonList((EObject)value);
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public List<Object> get(EObject source_p, EAttribute attribute_p) {
        List<Object> result;
        try {
            if (source_p.eIsSet((EStructuralFeature)attribute_p)) {
                Object value = source_p.eGet((EStructuralFeature)attribute_p, this.resolveProxies());
                if (FeatureMapUtil.isMany((EObject)source_p, (EStructuralFeature)attribute_p)) {
                    result = new LinkedList<Object>();
                    for (Object inValue : (List)value) {
                        if (inValue == null) continue;
                        result.add(inValue);
                    }
                    result = Collections.unmodifiableList(result);
                } else {
                    result = value != null ? Collections.singletonList(value) : Collections.emptyList();
                }
            } else {
                result = Collections.emptyList();
            }
        }
        catch (RuntimeException e) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public TreeIterator<EObject> getAllContents() {
        return new ModelScopeIterator(this);
    }

    public TreeIterator<EObject> getAllContents(EObject root_p) {
        return new AbstractTreeIterator<EObject>((Object)root_p, false){
            private static final long serialVersionUID = 1L;

            public Iterator<EObject> getChildren(Object object_p) {
                return AbstractModelScope.this.getContents((EObject)object_p).iterator();
            }
        };
    }

    @Override
    public Set<EObject> getAllContentsAsSet() {
        FHashSet result = new FHashSet();
        TreeIterator<EObject> it = this.getAllContents();
        while (it.hasNext()) {
            result.add((EObject)it.next());
        }
        return Collections.unmodifiableSet(result);
    }

    public EObject getContainer(EObject element_p) {
        return element_p.eContainer();
    }

    public EReference getContainment(EObject element_p) {
        return element_p.eContainmentFeature();
    }

    public List<EObject> getContents(EObject element_p) {
        return element_p.eContents();
    }

    @Override
    public List<EObject> getRoots() {
        return this.getContents();
    }

    @Override
    public TreeIterator<EObject> iterator() {
        return this.getAllContents();
    }

    protected boolean resolveProxies() {
        return false;
    }
}

