/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.ui.CVSDecoration;
import org.eclipse.team.internal.ccvs.ui.CVSLightweightDecorator;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelCompareParticipant;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.SynchronizationStateTester;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;

public class CVSParticipantLabelDecorator
extends LabelProvider
implements IPropertyChangeListener,
ILabelDecorator {
    private ISynchronizePageConfiguration configuration;
    private SynchronizationStateTester tester = new SynchronizationStateTester(){

        public int getState(Object element, int stateMask, IProgressMonitor monitor) throws CoreException {
            return 0;
        }
    };

    public CVSParticipantLabelDecorator(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        CVSUIPlugin.addPropertyChangeListener(this);
        TeamUI.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public String decorateText(String input, Object elementOrPath) {
        if (!this.isEnabledFor(elementOrPath)) {
            return input;
        }
        try {
            String text = input;
            IResource resource = this.getResource(elementOrPath);
            if (resource != null && resource.getType() != 8) {
                CVSDecoration decoration = this.getDecoration(resource);
                decoration.setRevision(this.getRevisionNumber(elementOrPath));
                decoration.compute();
                StringBuilder output = new StringBuilder(25);
                if (decoration.getPrefix() != null) {
                    output.append(decoration.getPrefix());
                }
                output.append(text);
                if (decoration.getSuffix() != null) {
                    output.append(decoration.getSuffix());
                }
                return output.toString();
            }
            return text;
        }
        catch (CoreException coreException) {
            return input;
        }
    }

    protected IResource getResource(Object element) {
        if (element instanceof ISynchronizeModelElement) {
            return ((ISynchronizeModelElement)element).getResource();
        }
        return Utils.getResource((Object)this.internalGetElement(element));
    }

    protected CVSDecoration getDecoration(IResource resource) throws CoreException {
        return CVSLightweightDecorator.decorate((Object)resource, this.tester);
    }

    public Image decorateImage(Image base, Object element) {
        return base;
    }

    public void propertyChange(PropertyChangeEvent event) {
        Viewer viewer;
        if (this.needsRefresh(event) && (viewer = this.configuration.getPage().getViewer()) instanceof StructuredViewer && !viewer.getControl().isDisposed()) {
            ((StructuredViewer)viewer).refresh(true);
        }
    }

    protected boolean needsRefresh(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.equals("org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED") || property.equals("org.eclipse.team.uiglobal_file_types_changed");
    }

    public void dispose() {
        CVSUIPlugin.removePropertyChangeListener(this);
        TeamUI.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected String getRevisionNumber(Object elementOrPath) {
        IResource resource = this.getResource(elementOrPath);
        if (resource != null && resource.getType() == 1) {
            IResourceVariant local;
            try {
                local = (IResourceVariant)CVSWorkspaceRoot.getRemoteResourceFor((IResource)resource);
            }
            catch (CVSException cVSException) {
                local = null;
            }
            if (local == null) {
                local = this.getBase(elementOrPath);
            }
            String localRevision = this.getRevisionString(local);
            StringBuilder revisionString = new StringBuilder();
            IResourceVariant remote = this.getRemote(elementOrPath);
            String remoteRevision = this.getRevisionString(remote);
            if (localRevision != null) {
                revisionString.append(localRevision);
            }
            if (remoteRevision != null) {
                revisionString.append(String.valueOf(localRevision != null ? " - " : "") + remoteRevision);
            }
            return revisionString.toString();
        }
        return null;
    }

    private boolean isEnabledFor(Object elementOrPath) {
        return !this.isCompareWithChangeSets() || elementOrPath instanceof TreePath;
    }

    private boolean isCompareWithChangeSets() {
        String id = (String)this.configuration.getProperty("org.eclipse.team.ui.activeModelProvider");
        return this.configuration.getParticipant() instanceof ModelCompareParticipant && id.equals("org.eclipse.team.cvs.core.changeSetModel");
    }

    private SyncInfo getSyncInfo(Object element) {
        ModelSynchronizeParticipant msp;
        ISynchronizationContext context;
        ISynchronizeParticipant participant;
        if (element instanceof SyncInfoModelElement) {
            SyncInfoModelElement sime = (SyncInfoModelElement)element;
            return sime.getSyncInfo();
        }
        IResource resource = this.getResource(element);
        if (resource != null && (participant = this.configuration.getParticipant()) instanceof ModelSynchronizeParticipant && (context = (msp = (ModelSynchronizeParticipant)participant).getContext()) instanceof SubscriberMergeContext) {
            SubscriberMergeContext smc = (SubscriberMergeContext)context;
            Subscriber subscriber = smc.getSubscriber();
            try {
                return subscriber.getSyncInfo(resource);
            }
            catch (TeamException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return null;
    }

    private IResourceVariant getBase(Object element) {
        if (element instanceof TreePath) {
            TreePath tp = (TreePath)element;
            IDiff diff = this.getDiff(tp);
            IFileRevision revision = Utils.getBase((IDiff)diff);
            return SyncInfoToDiffConverter.asResourceVariant((IFileRevision)revision);
        }
        SyncInfo info = this.getSyncInfo(element);
        if (info != null) {
            return info.getBase();
        }
        return null;
    }

    private IResourceVariant getRemote(Object element) {
        if (element instanceof TreePath) {
            TreePath tp = (TreePath)element;
            IDiff diff = this.getDiff(tp);
            IFileRevision revision = Utils.getRemote((IDiff)diff);
            return SyncInfoToDiffConverter.asResourceVariant((IFileRevision)revision);
        }
        SyncInfo info = this.getSyncInfo(element);
        if (info != null) {
            return info.getRemote();
        }
        return null;
    }

    private IDiff getDiff(TreePath tp) {
        Object first = tp.getFirstSegment();
        Object last = tp.getLastSegment();
        IResource resource = Utils.getResource((Object)last);
        if (first instanceof DiffChangeSet && resource != null) {
            DiffChangeSet dcs = (DiffChangeSet)first;
            return dcs.getDiffTree().getDiff(resource);
        }
        return null;
    }

    private String getRevisionString(IResourceVariant remoteFile) {
        if (remoteFile instanceof RemoteFile) {
            return ((RemoteFile)remoteFile).getRevision();
        }
        return null;
    }

    private Object internalGetElement(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)elementOrPath;
            return tp.getLastSegment();
        }
        return elementOrPath;
    }
}

