/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.components.BranchNameNormalizer;
import org.eclipse.egit.ui.internal.dialogs.CheckoutDialog;
import org.eclipse.egit.ui.internal.history.CommitSelectionDialog;
import org.eclipse.egit.ui.internal.repository.CreateBranchWizard;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CheckoutEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class SwitchToMenu
extends ContributionItem
implements IWorkbenchContribution {
    static final int MAX_NUM_MENU_ENTRIES = 20;
    private IHandlerService handlerService;
    private final Image branchImage;
    private final Image newBranchImage;
    private final Image checkedOutImage;
    private final Image commitImage;
    private final Image othersImage;

    public SwitchToMenu() {
        this(null);
    }

    public SwitchToMenu(String id) {
        super(id);
        ResourceManager pluginResources = Activator.getDefault().getResourceManager();
        this.branchImage = UIIcons.getImage(pluginResources, UIIcons.BRANCH);
        this.newBranchImage = UIIcons.getImage(pluginResources, UIIcons.CREATE_BRANCH);
        this.checkedOutImage = UIIcons.getImage(pluginResources, UIIcons.CHECKED_OUT_BRANCH);
        this.commitImage = UIIcons.getImage(pluginResources, UIIcons.CHANGESET);
        this.othersImage = UIIcons.getImage(pluginResources, UIIcons.BRANCHES);
    }

    public void fill(Menu menu, int index) {
        if (this.handlerService == null) {
            return;
        }
        Repository[] repositories = SelectionUtils.getAllRepositories(this.handlerService.getCurrentState());
        if (repositories.length > 0) {
            this.createDynamicMenu(menu, repositories);
        }
    }

    private void createDynamicMenu(Menu menu, Repository[] repositories) {
        boolean showCreateBranchItem = true;
        if (!this.isMultipleSelection(repositories)) {
            Repository repository = repositories[0];
            this.createNewBranchMenuItem(menu, repository);
        } else if (this.canBulkCreateNewBranch(repositories)) {
            this.createBulkNewBranchMenuItem(menu, repositories);
        } else {
            showCreateBranchItem = false;
        }
        if (showCreateBranchItem && Arrays.stream(repositories).anyMatch(this::hasBranches)) {
            SwitchToMenu.createSeparator(menu);
        }
        int itemCount = this.createMostActiveBranchesMenuItems(menu, repositories);
        if (!this.isMultipleSelection(repositories)) {
            SwitchToMenu.createSeparator(menu);
            this.createSwitchToCommitItem(menu, repositories[0]);
            if (itemCount > 0) {
                this.createOtherMenuItem(menu, repositories[0]);
            }
        }
        if (itemCount == 0 && this.isMultipleSelection(repositories)) {
            this.createDisabledMenu(menu, UIText.SwitchToMenu_NoCommonBranchesFound);
        }
    }

    private boolean canBulkCreateNewBranch(Repository[] repositories) {
        Repository[] repositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repo = repositoryArray[n2];
            if (!this.hasBranches(repo)) {
                return false;
            }
            if (repo.isBare()) {
                return false;
            }
            if (repo.getRepositoryState() != RepositoryState.SAFE) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void createBulkNewBranchMenuItem(Menu menu, final Repository[] repositories) {
        MenuItem newBranch = this.getNewBranchMenuItem(menu);
        newBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(e.display.getActiveShell(), UIText.CreateBranchBulkDialog_Title, UIText.CreateBranchBulkDialog_Description, "", new IInputValidator(){

                    public String isValid(String newBranchName) {
                        return SwitchToMenu.this.validateNewBulkBranchName(newBranchName, repositories);
                    }
                }){

                    protected Control createDialogArea(Composite parent) {
                        Control result = super.createDialogArea(parent);
                        BranchNameNormalizer normalizer = new BranchNameNormalizer(this.getText());
                        normalizer.setVisible(false);
                        return result;
                    }
                };
                if (dialog.open() == 0) {
                    String name = dialog.getValue();
                    try {
                        Repository[] repositoryArray = repositories;
                        int n = repositories.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Repository repository = repositoryArray[n2];
                            Ref headRef = repository.exactRef("HEAD");
                            if (headRef != null) {
                                ObjectId headId = headRef.getLeaf().getObjectId();
                                RevCommit head = repository.parseCommit((AnyObjectId)headId);
                                CreateLocalBranchOperation op = new CreateLocalBranchOperation(repository, name, head);
                                op.execute(null);
                            }
                            ++n2;
                        }
                        BranchOperationUI.checkout(repositories, name).start();
                    }
                    catch (Exception exception) {
                        Activator.handleError(UIText.CreateBranchBulkDialog_Error, exception, true);
                    }
                }
            }
        });
    }

    private MenuItem getNewBranchMenuItem(Menu parentMenu) {
        MenuItem newBranch = new MenuItem(parentMenu, 8);
        newBranch.setText(UIText.SwitchToMenu_NewBranchMenuLabel);
        newBranch.setImage(this.newBranchImage);
        return newBranch;
    }

    private String validateNewBulkBranchName(String newBranchName, Repository[] repositories) {
        if (StringUtils.isEmptyOrNull((String)newBranchName) || newBranchName.trim().isEmpty()) {
            return UIText.CreateBranchPage_ChooseNameMessage;
        }
        Repository[] repositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repo = repositoryArray[n2];
            IStatus status = Utils.validateNewRefName((String)newBranchName, (Repository)repo, (String)"refs/heads/", (boolean)true);
            if (status.getException() != null) {
                Activator.handleStatus(status, false);
            }
            if (!status.isOK()) {
                return String.valueOf(Activator.getDefault().getRepositoryUtil().getRepositoryName(repo)) + ": " + status.getMessage();
            }
            ++n2;
        }
        return null;
    }

    private boolean hasBranches(Repository repository) {
        try {
            return !repository.getRefDatabase().getRefsByPrefix("refs/heads/").isEmpty();
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
            return false;
        }
    }

    private void createNewBranchMenuItem(Menu menu, final Repository repository) {
        MenuItem newBranch = this.getNewBranchMenuItem(menu);
        newBranch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String sourceRef = repository.getConfig().getString("workflow", null, "defbranchstartpoint");
                CreateBranchWizard wiz = null;
                try {
                    Ref ref = null;
                    if (sourceRef != null) {
                        ref = repository.findRef(sourceRef);
                    }
                    wiz = ref != null ? new CreateBranchWizard(repository, ref.getName()) : new CreateBranchWizard(repository, repository.getFullBranch());
                }
                catch (IOException ref) {
                    // empty catch block
                }
                if (wiz == null) {
                    wiz = new CreateBranchWizard(repository);
                }
                WizardDialog dlg = new WizardDialog(e.display.getActiveShell(), (IWizard)wiz);
                dlg.setHelpAvailable(false);
                dlg.open();
            }
        });
    }

    private int createMostActiveBranchesMenuItems(Menu menu, Repository[] repositories) {
        int itemCount = 0;
        try {
            ArrayList<Map<String, Ref>> activeBranches = new ArrayList<Map<String, Ref>>();
            try {
                Repository[] repositoryArray = repositories;
                int n = repositories.length;
                int n2 = 0;
                while (n2 < n) {
                    Repository repository = repositoryArray[n2];
                    Map<String, Ref> branchRefMapping = this.getMostActiveBranches(repository, 20);
                    activeBranches.add(branchRefMapping);
                    ++n2;
                }
            }
            catch (IOException e) {
                Activator.logError(e.getLocalizedMessage(), e);
                activeBranches.clear();
            }
            Set<String> activeBranchIntersection = this.getBranchNameIntersection(activeBranches);
            for (String branchName : activeBranchIntersection) {
                ++itemCount;
                this.createMenuItemMultiple(menu, repositories, branchName);
            }
            if (itemCount >= 20) {
                return itemCount;
            }
            ArrayList<Map<String, Ref>> localBranchMapping = new ArrayList<Map<String, Ref>>();
            Repository[] repositoryArray = repositories;
            int n = repositories.length;
            int n3 = 0;
            while (n3 < n) {
                Repository repository = repositoryArray[n3];
                Map localBranches = repository.getRefDatabase().getRefs("refs/heads/");
                localBranchMapping.add(localBranches);
                ++n3;
            }
            Set<String> localBranchNameIntersection = this.getBranchNameIntersection(localBranchMapping);
            localBranchNameIntersection.removeAll(activeBranchIntersection);
            if (itemCount > 0 && !localBranchNameIntersection.isEmpty()) {
                SwitchToMenu.createSeparator(menu);
            }
            for (String localBranchName : localBranchNameIntersection) {
                if (++itemCount <= 20) {
                    this.createMenuItemMultiple(menu, repositories, localBranchName);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        return itemCount;
    }

    private Set<String> getBranchNameIntersection(List<Map<String, Ref>> refMapping) {
        Iterator<Map<String, Ref>> iterator = refMapping.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptySet();
        }
        TreeSet<String> intersection = new TreeSet<String>(CommonUtils.STRING_ASCENDING_COMPARATOR);
        intersection.addAll(iterator.next().keySet());
        iterator.forEachRemaining(map -> {
            boolean bl = intersection.retainAll(map.keySet());
        });
        return intersection;
    }

    private void createOtherMenuItem(Menu menu, final Repository repository) {
        MenuItem others = new MenuItem(menu, 8);
        others.setText(UIText.SwitchToMenu_OtherMenuLabel);
        others.setImage(this.othersImage);
        others.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutDialog dialog = new CheckoutDialog(e.display.getActiveShell(), repository);
                if (dialog.open() == 0) {
                    BranchOperationUI.checkout(repository, dialog.getRefName()).start();
                }
            }
        });
    }

    private void createSwitchToCommitItem(Menu menu, final Repository repository) {
        MenuItem switchToCommit = new MenuItem(menu, 8);
        switchToCommit.setText(UIText.SwitchToMenu_CommitMenuLabel);
        switchToCommit.setImage(this.commitImage);
        switchToCommit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectId commitId;
                CommitSelectionDialog dialog;
                if (repository != null && (dialog = new CommitSelectionDialog(e.display.getActiveShell(), repository)).open() == 0 && (commitId = dialog.getCommitId()) != null) {
                    BranchOperationUI.checkout(repository, commitId.getName()).start();
                }
            }
        });
    }

    private void createDisabledMenu(Menu menu, String text) {
        MenuItem disabled = new MenuItem(menu, 8);
        disabled.setText(text);
        disabled.setImage(this.branchImage);
        disabled.setEnabled(false);
    }

    private static MenuItem createSeparator(Menu menu) {
        return new MenuItem(menu, 2);
    }

    private void createMenuItemMultiple(Menu menu, final Repository[] repositories, final String shortName) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(shortName);
        boolean allRepositoriesCheckedOut = Stream.of(repositories).allMatch(r -> shortName.equals(this.getBranch((Repository)r)));
        if (allRepositoriesCheckedOut) {
            item.setImage(this.checkedOutImage);
        } else {
            item.setImage(this.branchImage);
        }
        item.setEnabled(!allRepositoriesCheckedOut);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BranchOperationUI.checkout(repositories, shortName).start();
            }
        });
    }

    private String getBranch(Repository repo) {
        try {
            return repo.getBranch();
        }
        catch (IOException e) {
            return "";
        }
    }

    private Map<String, Ref> getMostActiveBranches(Repository repository, int maximumBranchCount) throws IOException {
        Map localBranches = repository.getRefDatabase().getRefs("refs/heads/");
        HashMap<String, Ref> activeRefs = new HashMap<String, Ref>();
        List reflogEntries = RepositoryUtil.safeReadReflog((Repository)repository, (String)"HEAD");
        for (ReflogEntry entry : reflogEntries) {
            CheckoutEntry checkout = entry.parseCheckout();
            if (checkout == null) continue;
            Ref ref = (Ref)localBranches.get(checkout.getFromBranch());
            if (ref != null && activeRefs.size() < maximumBranchCount) {
                activeRefs.put(checkout.getFromBranch(), ref);
            }
            if ((ref = (Ref)localBranches.get(checkout.getToBranch())) == null || activeRefs.size() >= maximumBranchCount) continue;
            activeRefs.put(checkout.getToBranch(), ref);
        }
        return activeRefs;
    }

    private boolean isMultipleSelection(Repository[] repositories) {
        return repositories.length > 1;
    }

    public boolean isDynamic() {
        return true;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
    }
}

