/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.branch;

import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.internal.LabelColumnComparator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class MultiBranchOperationResultDialog
extends TitleAreaDialog {
    private final Map<Repository, CheckoutResult> results = new LinkedHashMap<Repository, CheckoutResult>();
    private TableViewer tv;
    private final RepositoryUtil utils = RepositoryUtil.getInstance();
    private EnumMap<CheckoutResult.Status, String> resultMessages;

    protected MultiBranchOperationResultDialog(Shell parentShell, Map<Repository, CheckoutResult> results) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF | 0x4F0);
        this.setBlockOnOpen(false);
        this.results.putAll(results);
        this.initializeResultMessages();
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        this.tv = new TableViewer(main, 67586);
        this.tv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableColumnLayout layout = new TableColumnLayout();
        main.setLayout((Layout)layout);
        Table table = this.tv.getTable();
        TableViewerColumn tc = new TableViewerColumn(this.tv, 0);
        TableColumn col = tc.getColumn();
        tc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry item = (Map.Entry)element;
                return MultiBranchOperationResultDialog.this.utils.getRepositoryName((Repository)item.getKey());
            }
        });
        col.setText(UIText.MultiBranchOperationResultDialog_RepositoryColumnHeader);
        layout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(200, 200));
        this.createComparator(col, 0);
        tc = new TableViewerColumn(this.tv, 0);
        col = tc.getColumn();
        tc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                Map.Entry item = (Map.Entry)element;
                if (((CheckoutResult)item.getValue()).getStatus() == CheckoutResult.Status.OK) {
                    return null;
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_STOP");
            }

            public String getText(Object element) {
                Map.Entry item = (Map.Entry)element;
                CheckoutResult.Status status = ((CheckoutResult)item.getValue()).getStatus();
                return MultiBranchOperationResultDialog.this.getMessageForStatus(status);
            }
        });
        col.setText(UIText.MultiBranchOperationResultDialog_CheckoutStatusColumnHeader);
        layout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnWeightData(200, 450));
        this.createComparator(col, 1);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tv.setInput(this.results.entrySet());
        int linesToShow = Math.min(Math.max(this.results.size(), 5), 15);
        int height = table.getItemHeight() * linesToShow;
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, height).applyTo((Control)main);
        this.setTitle(UIText.MultiBranchOperationResultDialog_DialogTitle);
        this.setErrorMessage(UIText.MultiBranchOperationResultDialog_DialogErrorMessage);
        return main;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.MultiBranchOperationResultDialog_WindowTitle);
    }

    private LabelColumnComparator createComparator(TableColumn column, int columnIndex) {
        return new LabelColumnComparator(this.tv, column, columnIndex);
    }

    private void initializeResultMessages() {
        this.resultMessages = new EnumMap(CheckoutResult.Status.class);
        this.resultMessages.put(CheckoutResult.Status.OK, UIText.MultiBranchOperationResultDialog_CheckoutResultOK);
        this.resultMessages.put(CheckoutResult.Status.CONFLICTS, UIText.MultiBranchOperationResultDialog_CheckoutResultConflicts);
        this.resultMessages.put(CheckoutResult.Status.NOT_TRIED, UIText.MultiBranchOperationResultDialog_CheckoutResultNotTried);
        this.resultMessages.put(CheckoutResult.Status.NONDELETED, UIText.MultiBranchOperationResultDialog_CheckoutResultNonDeleted);
        this.resultMessages.put(CheckoutResult.Status.ERROR, UIText.MultiBranchOperationResultDialog_CheckoutResultError);
    }

    private String getMessageForStatus(CheckoutResult.Status status) {
        return this.resultMessages.getOrDefault(status, "");
    }
}

