/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build.builddeploy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PermissionType implements Enumerator
{
    READ(1, "READ", "READ"),
    EXECUTE(2, "EXECUTE", "EXECUTE"),
    WRITE(3, "WRITE", "WRITE");

    public static final String copyright = "   Copyright (c) 2009-2010 Thales Corporate Services S.A.S.\r\n   This program and the accompanying materials\r\n   are made available under the terms of the Eclipse Public License v2.0\r\n   which accompanies this distribution, and is available at\r\n   https://www.eclipse.org/legal/epl-v2.0\r\n  \r\n  SPDX-License-Identifier: EPL-2.0\r\n  \r\n   Contributors:\r\n       Thales Corporate Services S.A.S - initial API and implementation";
    public static final int READ_VALUE = 1;
    public static final int EXECUTE_VALUE = 2;
    public static final int WRITE_VALUE = 3;
    private static final PermissionType[] VALUES_ARRAY;
    public static final List<PermissionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PermissionType[]{READ, EXECUTE, WRITE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PermissionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PermissionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PermissionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PermissionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PermissionType get(int value) {
        switch (value) {
            case 1: {
                return READ;
            }
            case 2: {
                return EXECUTE;
            }
            case 3: {
                return WRITE;
            }
        }
        return null;
    }

    private PermissionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

