/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.ConfigureRepositoryLocationsTable;
import org.eclipse.team.internal.ccvs.ui.wizards.AlternativeLocationWizard;
import org.eclipse.ui.PlatformUI;

public class ConfigureRepositoryLocationsDialog
extends TitleAreaDialog {
    private Image dlgTitleImage;
    private ConfigureRepositoryLocationsTable fConfigureRepositoryLocationsTable;

    public ConfigureRepositoryLocationsDialog(Shell parentShell, Map alternativesMap) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fConfigureRepositoryLocationsTable = new ConfigureRepositoryLocationsTable(alternativesMap);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(CVSUIMessages.ConfigureRepositoryLocationsWizard_title);
        this.setMessage(CVSUIMessages.ConfigureRepositoryLocationsWizard_message);
        this.dlgTitleImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.png").createImage();
        this.setTitleImage(this.dlgTitleImage);
        return contents;
    }

    public boolean close() {
        if (this.dlgTitleImage != null) {
            this.dlgTitleImage.dispose();
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(CVSUIMessages.ConfigureRepositoryLocationsWizard_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.team.cvs.ui.alternative_repository_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData childData = new GridData(1808);
        composite.setLayoutData((Object)childData);
        Composite table = this.fConfigureRepositoryLocationsTable.createControl(composite);
        GridData gridData = new GridData(16);
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        Button showOnlyCompatibleLocationsButton = new Button(composite, 32);
        showOnlyCompatibleLocationsButton.setText(CVSUIMessages.ConfigureRepositoryLocationsWizard_showOnlyCompatible);
        showOnlyCompatibleLocationsButton.setSelection(true);
        showOnlyCompatibleLocationsButton.addListener(13, event -> this.fConfigureRepositoryLocationsTable.setShowOnlyCompatibleLocations(showOnlyCompatibleLocationsButton.getSelection()));
        showOnlyCompatibleLocationsButton.setLayoutData((Object)new GridData(1, 0, false, false));
        Button createLocationButton = new Button(composite, 8);
        createLocationButton.setText(CVSUIMessages.ConfigureRepositoryLocationsWizard_createLocation);
        createLocationButton.setToolTipText(CVSUIMessages.ConfigureRepositoryLocationsWizard_createLocationTooltip);
        createLocationButton.addListener(13, event -> {
            CVSRepositoryLocation selectedAlternativeRepository = this.fConfigureRepositoryLocationsTable.getSelectedAlternativeRepository();
            Properties properties = new Properties();
            properties.put("connection", selectedAlternativeRepository.getMethod().getName());
            properties.put("user", selectedAlternativeRepository.getUsername());
            properties.put("host", selectedAlternativeRepository.getHost());
            int port = selectedAlternativeRepository.getPort();
            if (port != 0) {
                properties.put("port", String.valueOf(port));
            }
            properties.put("root", selectedAlternativeRepository.getRootDirectory());
            AlternativeLocationWizard wizard = new AlternativeLocationWizard(properties);
            wizard.setSwitchPerspectives(false);
            ConfigureRepositoryLocationsWizardDialog dialog = new ConfigureRepositoryLocationsWizardDialog(this.getShell(), (IWizard)wizard);
            dialog.open();
            ICVSRepositoryLocation location = wizard.getLocation();
            if (location != null) {
                this.fConfigureRepositoryLocationsTable.addAlternativeRepository(location);
            }
        });
        createLocationButton.setEnabled(this.fConfigureRepositoryLocationsTable.getSelection().getFirstElement() != null);
        createLocationButton.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this.fConfigureRepositoryLocationsTable.getViewer().addSelectionChangedListener(event -> {
            IStructuredSelection sel = event.getStructuredSelection();
            Object firstElement = sel.getFirstElement();
            createLocationButton.setEnabled(firstElement != null);
        });
        return composite;
    }

    public Map getSelected() {
        return this.fConfigureRepositoryLocationsTable.getSelected();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + "_dialogBounds";
        IDialogSettings settings = CVSUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
            section.put("DIALOG_HEIGHT", 300);
            section.put("DIALOG_WIDTH", 600);
        }
        return section;
    }

    protected int getDialogBoundsStrategy() {
        return 3;
    }

    private class ConfigureRepositoryLocationsWizardDialog
    extends WizardDialog {
        public ConfigureRepositoryLocationsWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
        }

        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            if (id == 16) {
                label = CVSUIMessages.ConfigureRepositoryLocationsWizardDialog_finish;
            }
            return super.createButton(parent, id, label, defaultButton);
        }
    }
}

