/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.xtext.ui.editor.XtextPresentationReconciler;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.syntaxcoloring.AttributedPosition;

public class HighlightingPresenter
implements ITextPresentationListener,
ITextInputListener,
IDocumentListener {
    private static final Logger log = Logger.getLogger(HighlightingPresenter.class);
    private final IPositionUpdater fPositionUpdater = new HighlightingPositionUpdater(this.getPositionCategory());
    private XtextSourceViewer fSourceViewer;
    private XtextPresentationReconciler fPresentationReconciler;
    private List<AttributedPosition> fPositions = new ArrayList<AttributedPosition>();
    private final Object fPositionLock = new Object();
    private boolean fIsCanceled = false;

    public AttributedPosition createHighlightedPosition(int offset, int length, TextAttribute highlighting) {
        return new AttributedPosition(offset, length, highlighting, this.fPositionUpdater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllPositions(List<AttributedPosition> list) {
        Object object = this.fPositionLock;
        synchronized (object) {
            list.addAll(this.fPositions);
        }
    }

    public TextPresentation createPresentation(List<AttributedPosition> addedPositions, List<AttributedPosition> removedPositions) {
        int offset;
        Position position;
        XtextSourceViewer sourceViewer = this.fSourceViewer;
        XtextPresentationReconciler presentationReconciler = this.fPresentationReconciler;
        if (sourceViewer == null || presentationReconciler == null) {
            return null;
        }
        if (this.isCanceled()) {
            return null;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return null;
        }
        int minStart = Integer.MAX_VALUE;
        int maxEnd = Integer.MIN_VALUE;
        int i = 0;
        int n = removedPositions.size();
        while (i < n) {
            position = removedPositions.get(i);
            offset = position.getOffset();
            minStart = Math.min(minStart, offset);
            maxEnd = Math.max(maxEnd, offset + position.getLength());
            ++i;
        }
        i = 0;
        n = addedPositions.size();
        while (i < n) {
            position = addedPositions.get(i);
            offset = position.getOffset();
            minStart = Math.min(minStart, offset);
            maxEnd = Math.max(maxEnd, offset + position.getLength());
            ++i;
        }
        if (minStart < maxEnd) {
            try {
                return presentationReconciler.createRepairDescription((IRegion)new Region(minStart, maxEnd - minStart), document);
            }
            catch (RuntimeException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public Runnable createUpdateRunnable(final TextPresentation textPresentation, List<AttributedPosition> addedPositions, List<AttributedPosition> removedPositions) {
        if (this.fSourceViewer == null || textPresentation == null) {
            return null;
        }
        final AttributedPosition[] added = new AttributedPosition[addedPositions.size()];
        addedPositions.toArray(added);
        final AttributedPosition[] removed = new AttributedPosition[removedPositions.size()];
        removedPositions.toArray(removed);
        if (this.isCanceled()) {
            return null;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                HighlightingPresenter.this.updatePresentation(textPresentation, added, removed);
            }
        };
        return runnable;
    }

    public Runnable createSimpleUpdateRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                if (HighlightingPresenter.this.fSourceViewer != null) {
                    HighlightingPresenter.this.fSourceViewer.invalidateTextPresentation();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updatePresentation(TextPresentation textPresentation, AttributedPosition[] addedPositions, AttributedPosition[] removedPositions) {
        if (this.fSourceViewer == null) {
            return;
        }
        if (this.isCanceled()) {
            return;
        }
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            return;
        }
        String positionCategory = this.getPositionCategory();
        List<AttributedPosition> removedPositionsList = Arrays.asList(removedPositions);
        try {
            Object object = this.fPositionLock;
            synchronized (object) {
                List<AttributedPosition> oldPositions = this.fPositions;
                int newSize = Math.max(this.fPositions.size() + addedPositions.length - removedPositions.length, 10);
                ArrayList<AttributedPosition> newPositions = new ArrayList<AttributedPosition>(newSize);
                AttributedPosition position = null;
                AttributedPosition addedPosition = null;
                int i = 0;
                int j = 0;
                int n = oldPositions.size();
                int m = addedPositions.length;
                block6: while (true) {
                    block17: {
                        block18: {
                            if (i >= n && position == null && j >= m && addedPosition == null) {
                                this.fPositions = newPositions;
                                break;
                            }
                            while (true) {
                                if (position != null || i >= n) {
                                    if (addedPosition == null && j < m) {
                                        addedPosition = addedPositions[j++];
                                        document.addPosition(positionCategory, (Position)addedPosition);
                                    }
                                    if (position == null) break block17;
                                    if (addedPosition != null) {
                                        if (position.getOffset() > addedPosition.getOffset()) break;
                                        newPositions.add(position);
                                        position = null;
                                        continue block6;
                                    }
                                    break block18;
                                }
                                if (!(position = oldPositions.get(i++)).isDeleted() && !this.contain(removedPositionsList, position)) continue;
                                document.removePosition(positionCategory, (Position)position);
                                position = null;
                            }
                            newPositions.add(addedPosition);
                            addedPosition = null;
                            continue;
                        }
                        newPositions.add(position);
                        position = null;
                        continue;
                    }
                    if (addedPosition == null) continue;
                    newPositions.add(addedPosition);
                    addedPosition = null;
                }
            }
        }
        catch (BadPositionCategoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (BadLocationException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        if (textPresentation != null) {
            this.fSourceViewer.changeTextPresentation(textPresentation, false);
            return;
        }
        this.fSourceViewer.invalidateTextPresentation();
    }

    private boolean contain(List<AttributedPosition> positions, AttributedPosition position) {
        return this.indexOf(positions, position) != -1;
    }

    private int indexOf(List<AttributedPosition> positions, AttributedPosition position) {
        int index = this.computeIndexAtOffset(positions, position.getOffset());
        int size = positions.size();
        while (index < size) {
            if (positions.get(index) == position) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void insertPosition(AttributedPosition position) {
        int i = this.computeIndexAfterOffset(this.fPositions, position.getOffset());
        this.fPositions.add(i, position);
    }

    protected int computeIndexAfterOffset(List<AttributedPosition> positions, int offset) {
        int i = -1;
        int j = positions.size();
        while (j - i > 1) {
            int k = i + j >> 1;
            AttributedPosition position = positions.get(k);
            if (position.getOffset() > offset) {
                j = k;
                continue;
            }
            i = k;
        }
        return j;
    }

    protected int computeIndexEndingAtOrEnclosingOffset(List<AttributedPosition> positions, int offset) {
        int i = -1;
        int j = positions.size();
        while (j - i > 1) {
            int k = i + j >> 1;
            AttributedPosition position = positions.get(k);
            int positionOffset = position.getOffset();
            if (positionOffset <= offset && positionOffset + position.getLength() > offset) {
                return k;
            }
            if (position.getOffset() >= offset) {
                j = k;
                continue;
            }
            i = k;
        }
        return j;
    }

    protected int computeIndexAtOffset(List<AttributedPosition> positions, int offset) {
        int i = -1;
        int j = positions.size();
        while (j - i > 1) {
            int k = i + j >> 1;
            AttributedPosition position = positions.get(k);
            if (position.getOffset() >= offset) {
                j = k;
                continue;
            }
            i = k;
        }
        return j;
    }

    /*
     * Unable to fully structure code
     */
    public void applyTextPresentation(TextPresentation textPresentation) {
        block4: {
            region = textPresentation.getExtent();
            i = this.computeIndexEndingAtOrEnclosingOffset(this.fPositions, region.getOffset());
            n = this.computeIndexAtOffset(this.fPositions, region.getOffset() + region.getLength());
            if (n - i <= 2) ** GOTO lbl21
            ranges = new ArrayList<StyleRange>(n - i);
            while (i < n) {
                position = this.fPositions.get(i);
                if (!position.isDeleted()) {
                    ranges.add(position.createStyleRange());
                }
                ++i;
            }
            array = new StyleRange[ranges.size()];
            array = ranges.toArray(array);
            textPresentation.replaceStyleRanges(array);
            break block4;
lbl-1000:
            // 1 sources

            {
                position = this.fPositions.get(i);
                if (!position.isDeleted()) {
                    textPresentation.replaceStyleRange(position.createStyleRange());
                }
                ++i;
lbl21:
                // 2 sources

                ** while (i < n)
            }
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        this.setCanceled(true);
        this.releaseDocument(oldInput);
        this.resetState();
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        this.manageDocument(newInput);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.setCanceled(true);
    }

    public void documentChanged(DocumentEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        IDocument document;
        IDocument iDocument = document = this.fSourceViewer != null ? this.fSourceViewer.getDocument() : null;
        if (document == null) {
            return this.fIsCanceled;
        }
        Object object = this.getLockObject(document);
        synchronized (object) {
            return this.fIsCanceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanceled(boolean isCanceled) {
        IDocument document;
        IDocument iDocument = document = this.fSourceViewer != null ? this.fSourceViewer.getDocument() : null;
        if (document == null) {
            this.fIsCanceled = isCanceled;
            return;
        }
        Object object = this.getLockObject(document);
        synchronized (object) {
            this.fIsCanceled = isCanceled;
        }
    }

    private Object getLockObject(IDocument document) {
        Object lock;
        if (document instanceof ISynchronizable && (lock = ((ISynchronizable)document).getLockObject()) != null) {
            return lock;
        }
        return document;
    }

    public void install(XtextSourceViewer sourceViewer, XtextPresentationReconciler backgroundPresentationReconciler) {
        this.fSourceViewer = sourceViewer;
        this.fPresentationReconciler = backgroundPresentationReconciler;
        this.fSourceViewer.prependTextPresentationListener(this);
        this.fSourceViewer.addTextInputListener(this);
        this.manageDocument(this.fSourceViewer.getDocument());
    }

    public void uninstall() {
        this.setCanceled(true);
        if (this.fSourceViewer != null) {
            this.fSourceViewer.removeTextPresentationListener(this);
            this.releaseDocument(this.fSourceViewer.getDocument());
            this.invalidateTextPresentation();
            this.resetState();
            this.fSourceViewer.removeTextInputListener(this);
            this.fSourceViewer = null;
        }
    }

    public void highlightingStyleChanged(TextAttribute highlighting) {
        int i = 0;
        int n = this.fPositions.size();
        while (i < n) {
            AttributedPosition position = this.fPositions.get(i);
            if (position.getHighlighting() == highlighting) {
                this.fSourceViewer.invalidateTextPresentation(position.getOffset(), position.getLength());
            }
            ++i;
        }
    }

    private void invalidateTextPresentation() {
        int i = 0;
        int n = this.fPositions.size();
        while (i < n) {
            AttributedPosition position = this.fPositions.get(i);
            this.fSourceViewer.invalidateTextPresentation(position.getOffset(), position.getLength());
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPositionFromUI(int offset, int length, TextAttribute highlighting) {
        AttributedPosition position = this.createHighlightedPosition(offset, length, highlighting);
        Object object = this.fPositionLock;
        synchronized (object) {
            this.insertPosition(position);
        }
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            return;
        }
        String positionCategory = this.getPositionCategory();
        try {
            document.addPosition(positionCategory, (Position)position);
        }
        catch (BadLocationException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        catch (BadPositionCategoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetState() {
        Object object = this.fPositionLock;
        synchronized (object) {
            this.fPositions.clear();
        }
    }

    private void manageDocument(IDocument document) {
        if (document != null) {
            document.addPositionCategory(this.getPositionCategory());
            document.addPositionUpdater(this.fPositionUpdater);
            document.addDocumentListener((IDocumentListener)this);
        }
    }

    private void releaseDocument(IDocument document) {
        if (document != null) {
            document.removeDocumentListener((IDocumentListener)this);
            document.removePositionUpdater(this.fPositionUpdater);
            try {
                document.removePositionCategory(this.getPositionCategory());
            }
            catch (BadPositionCategoryException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getPositionCategory() {
        return this.toString();
    }

    private class HighlightingPositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public HighlightingPositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventEnd = eventOffset + eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    AttributedPosition position = (AttributedPosition)positions[i];
                    int offset = position.getOffset();
                    int length = position.getLength();
                    int end = offset + length;
                    if (offset > eventEnd) {
                        this.updateWithPrecedingEvent(position, event);
                    } else if (end < eventOffset) {
                        this.updateWithSucceedingEvent(position, event);
                    } else if (offset <= eventOffset && end >= eventEnd) {
                        this.updateWithIncludedEvent(position, event);
                    } else if (offset <= eventOffset) {
                        this.updateWithOverEndEvent(position, event);
                    } else if (end >= eventEnd) {
                        this.updateWithOverStartEvent(position, event);
                    } else {
                        this.updateWithIncludingEvent(position, event);
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }

        private void updateWithPrecedingEvent(AttributedPosition position, DocumentEvent event) {
            String newText = event.getText();
            int eventNewLength = newText != null ? newText.length() : 0;
            int deltaLength = eventNewLength - event.getLength();
            position.setOffset(position.getOffset() + deltaLength);
        }

        private void updateWithSucceedingEvent(AttributedPosition position, DocumentEvent event) {
        }

        private void updateWithIncludedEvent(AttributedPosition position, DocumentEvent event) {
            int eventOffset = event.getOffset();
            String newText = event.getText();
            if (newText == null) {
                newText = "";
            }
            int eventNewLength = newText.length();
            int deltaLength = eventNewLength - event.getLength();
            int offset = position.getOffset();
            int length = position.getLength();
            int end = offset + length;
            int includedLength = 0;
            while (includedLength < eventNewLength && Character.isJavaIdentifierPart(newText.charAt(includedLength))) {
                ++includedLength;
            }
            if (includedLength == eventNewLength) {
                position.setLength(length + deltaLength);
            } else {
                int newLeftLength = eventOffset - offset + includedLength;
                int excludedLength = eventNewLength;
                while (excludedLength > 0 && Character.isJavaIdentifierPart(newText.charAt(excludedLength - 1))) {
                    --excludedLength;
                }
                int newRightOffset = eventOffset + excludedLength;
                int newRightLength = end + deltaLength - newRightOffset;
                if (newRightLength == 0) {
                    position.setLength(newLeftLength);
                } else if (newLeftLength == 0) {
                    position.update(newRightOffset, newRightLength);
                } else {
                    position.setLength(newLeftLength);
                    HighlightingPresenter.this.addPositionFromUI(newRightOffset, newRightLength, position.getHighlighting());
                }
            }
        }

        private void updateWithOverEndEvent(AttributedPosition position, DocumentEvent event) {
            String newText = event.getText();
            if (newText == null) {
                newText = "";
            }
            int eventNewLength = newText.length();
            int includedLength = 0;
            while (includedLength < eventNewLength && Character.isJavaIdentifierPart(newText.charAt(includedLength))) {
                ++includedLength;
            }
            position.setLength(event.getOffset() - position.getOffset() + includedLength);
        }

        private void updateWithOverStartEvent(AttributedPosition position, DocumentEvent event) {
            int eventNewLength;
            int eventOffset = event.getOffset();
            int eventEnd = eventOffset + event.getLength();
            String newText = event.getText();
            if (newText == null) {
                newText = "";
            }
            int excludedLength = eventNewLength = newText.length();
            while (excludedLength > 0 && Character.isJavaIdentifierPart(newText.charAt(excludedLength - 1))) {
                --excludedLength;
            }
            int deleted = eventEnd - position.getOffset();
            int inserted = eventNewLength - excludedLength;
            position.update(eventOffset + excludedLength, position.getLength() - deleted + inserted);
        }

        private void updateWithIncludingEvent(AttributedPosition position, DocumentEvent event) {
            position.delete();
            position.update(event.getOffset(), 0);
        }
    }
}

