/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.AbstractTypeResolver;
import org.eclipse.ocl.AmbiguousLookupException;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.TypeChecker;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.evaluation.BasicTypeChecker;
import org.eclipse.ocl.internal.evaluation.CachedTypeChecker;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractBasicEnvironment;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.options.ProblemOption;
import org.eclipse.ocl.parser.AbstractOCLAnalyzer;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.util.UnicodeSupport;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends AbstractBasicEnvironment
implements Environment.Internal<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E>,
Environment.Lookup<PK, C, O, P> {
    private int generatorInt = 0;
    private PK contextPackage;
    private O contextOperation;
    private P contextProperty;
    private List<VariableEntry> namedElements = new ArrayList<VariableEntry>();
    private Variable<C, PM> selfVariable;
    private Map<O, CT> operationBodies = new HashMap<O, CT>();
    private Map<P, CT> propertyInitializers = new HashMap<P, CT>();
    private Map<P, CT> propertyDerivations = new HashMap<P, CT>();
    private TypeChecker<C, O, P> typeChecker;

    protected AbstractEnvironment() {
        super(null);
    }

    protected AbstractEnvironment(Environment.Internal<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent) {
        super(parent);
    }

    protected AbstractEnvironment(AbstractEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent) {
        super(parent);
    }

    private String generateName() {
        ++this.generatorInt;
        return "temp" + this.generatorInt;
    }

    @Override
    public Environment.Internal<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getInternalParent() {
        return (Environment.Internal)super.getParent();
    }

    @Override
    @Deprecated
    public AbstractEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getParent() {
        return (AbstractEnvironment)super.getParent();
    }

    @Override
    public void setInternalParent(Environment.Internal<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent) {
        super.setParent(parent);
    }

    @Override
    protected void setParent(AbstractEnvironment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> parent) {
        super.setParent(parent);
    }

    @Override
    public PK getContextPackage() {
        if (this.contextPackage != null) {
            return this.contextPackage;
        }
        if (this.getInternalParent() != null) {
            return this.getInternalParent().getContextPackage();
        }
        return null;
    }

    protected void setContextPackage(PK contextPackage) {
        this.contextPackage = contextPackage;
    }

    @Override
    public C getContextClassifier() {
        return this.getSelfVariable().getType();
    }

    @Override
    public O getContextOperation() {
        if (this.contextOperation != null) {
            return this.contextOperation;
        }
        if (this.getInternalParent() != null) {
            return this.getInternalParent().getContextOperation();
        }
        return null;
    }

    protected void setContextOperation(O contextOperation) {
        this.contextOperation = contextOperation;
    }

    @Override
    public P getContextProperty() {
        if (this.contextProperty != null) {
            return this.contextProperty;
        }
        if (this.getInternalParent() != null) {
            return this.getInternalParent().getContextProperty();
        }
        return null;
    }

    protected void setContextProperty(P contextProperty) {
        this.contextProperty = contextProperty;
    }

    protected Resource getResource() {
        return this.getTypeResolver().getResource();
    }

    @Override
    public boolean isEmpty() {
        return this.namedElements.isEmpty();
    }

    @Override
    public Collection<Variable<C, PM>> getVariables() {
        ArrayList<Variable<C, PM>> result = new ArrayList<Variable<C, PM>>();
        int i = 0;
        while (i < this.namedElements.size()) {
            VariableEntry elem = this.namedElements.get(i);
            if (elem.isExplicit) {
                result.add(elem.variable);
            }
            ++i;
        }
        if (this.getInternalParent() != null) {
            for (Variable parentVar : this.getInternalParent().getVariables()) {
                if (this.lookupLocal(parentVar.getName()) != null) continue;
                result.add(parentVar);
            }
        }
        return result;
    }

    @Override
    public boolean addElement(String name, Variable<C, PM> elem, boolean isExplicit) {
        if (name == null) {
            name = this.generateName();
            while (this.lookup(name) != null) {
                name = this.generateName();
            }
        } else if (this.lookupLocal(name) != null) {
            return false;
        }
        this.getUMLReflection().setName(elem, name);
        VariableEntry newelem = new VariableEntry(name, elem, isExplicit);
        this.namedElements.add(newelem);
        this.addedVariable(name, elem, isExplicit);
        return true;
    }

    protected void addedVariable(String name, Variable<C, PM> variable, boolean isExplicit) {
        this.getResource().getContents().add(variable);
    }

    @Override
    public void deleteElement(String name) {
        Iterator<VariableEntry> iter = this.namedElements.iterator();
        while (iter.hasNext()) {
            VariableEntry elem = iter.next();
            if (!elem.name.equals(name)) continue;
            iter.remove();
            this.removedVariable(name, elem.variable, elem.isExplicit);
        }
    }

    protected void removedVariable(String name, Variable<C, PM> variable, boolean isExplicit) {
        this.getResource().getContents().remove(variable);
    }

    @Override
    public void setSelfVariable(Variable<C, PM> var) {
        C contextClassifier;
        this.selfVariable = var;
        if (this.getContextPackage() == null && (contextClassifier = this.getContextClassifier()) != null) {
            this.setContextPackage(this.getUMLReflection().getPackage(contextClassifier));
        }
    }

    @Override
    public Variable<C, PM> getSelfVariable() {
        Variable<C, PM> result = this.selfVariable;
        if (result == null && this.getInternalParent() != null) {
            result = this.getInternalParent().getSelfVariable();
        }
        return result;
    }

    protected int getElementsSize() {
        return this.namedElements.size();
    }

    protected VariableEntry getElement(int index) {
        return this.namedElements.get(index);
    }

    @Override
    public void addHelperProperty(C owner, P property) {
        this.addProperty(owner, property);
    }

    @Deprecated
    protected void addProperty(C owner, P property) {
        if (this.getInternalParent() != null) {
            this.getInternalParent().addHelperProperty(owner, property);
        } else {
            this.getTypeResolver().resolveAdditionalAttribute(owner, property);
        }
    }

    @Override
    public List<P> getAdditionalAttributes(C classifier) {
        if (this.getInternalParent() != null) {
            return this.getInternalParent().getAdditionalAttributes(classifier);
        }
        List<Object> result = null;
        TypeResolver res = this.getTypeResolver();
        List additionals = res.getAdditionalAttributes(classifier);
        if (!additionals.isEmpty()) {
            result = new ArrayList(additionals);
        }
        Collection allParents = classifier instanceof PredefinedType ? OCLStandardLibraryUtil.getAllSupertypes(this, (PredefinedType)classifier) : this.getUMLReflection().getAllSupertypes(classifier);
        for (Object general : allParents) {
            additionals = res.getAdditionalAttributes(general);
            if (additionals.isEmpty()) continue;
            if (result == null) {
                result = new ArrayList(additionals);
                continue;
            }
            result.addAll(additionals);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public void addHelperOperation(C owner, O operation) {
        this.addOperation(owner, operation);
    }

    @Deprecated
    protected void addOperation(C owner, O operation) {
        if (this.getInternalParent() != null) {
            this.getInternalParent().addHelperOperation(owner, operation);
        } else {
            this.getTypeResolver().resolveAdditionalOperation(owner, operation);
        }
    }

    @Override
    public List<O> getAdditionalOperations(C classifier) {
        if (this.getInternalParent() != null) {
            return this.getInternalParent().getAdditionalOperations(classifier);
        }
        List<Object> result = null;
        TypeResolver res = this.getTypeResolver();
        List additionals = res.getAdditionalOperations(classifier);
        if (!additionals.isEmpty()) {
            result = new ArrayList(additionals);
        }
        Collection allParents = classifier instanceof PredefinedType ? OCLStandardLibraryUtil.getAllSupertypes(this, (PredefinedType)classifier) : this.getUMLReflection().getAllSupertypes(classifier);
        for (Object general : allParents) {
            additionals = res.getAdditionalOperations(general);
            if (additionals.isEmpty()) continue;
            if (result == null) {
                result = new ArrayList(additionals);
                continue;
            }
            result.addAll(additionals);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public void setInitConstraint(P property, CT constraint) {
        if (this.getInternalParent() != null) {
            this.getInternalParent().setInitConstraint(property, constraint);
        } else {
            this.propertyInitializers.put(property, constraint);
        }
    }

    @Override
    public CT getInitConstraint(P property) {
        if (this.getInternalParent() != null) {
            return this.getInternalParent().getInitConstraint(property);
        }
        return this.propertyInitializers.get(property);
    }

    @Override
    public void setDeriveConstraint(P property, CT constraint) {
        if (this.getInternalParent() != null) {
            this.getInternalParent().setDeriveConstraint(property, constraint);
        } else {
            this.propertyDerivations.put(property, constraint);
        }
    }

    @Override
    public CT getDeriveConstraint(P property) {
        if (this.getInternalParent() != null) {
            return this.getInternalParent().getDeriveConstraint(property);
        }
        return this.propertyDerivations.get(property);
    }

    @Override
    public void setBodyCondition(O operation, CT constraint) {
        if (this.getInternalParent() != null) {
            this.getInternalParent().setBodyCondition(operation, constraint);
        } else {
            this.operationBodies.put(operation, constraint);
        }
    }

    @Override
    public CT getBodyCondition(O operation) {
        if (this.getInternalParent() != null) {
            return this.getInternalParent().getBodyCondition(operation);
        }
        return this.operationBodies.get(operation);
    }

    @Override
    public Variable<C, PM> lookupLocal(String name) {
        Variable<C, PM> result = this.doLookupLocal(name);
        if (result == null && AbstractOCLAnalyzer.isEscaped(name)) {
            result = this.doLookupLocal(AbstractOCLAnalyzer.unescape(name));
        }
        return result;
    }

    private Variable<C, PM> doLookupLocal(String name) {
        int i = 0;
        while (i < this.namedElements.size()) {
            VariableEntry elem = this.namedElements.get(i);
            if (elem.name.equals(name)) {
                return elem.variable;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Variable<C, PM> lookup(String name) {
        Variable<C, PM> elem = this.lookupLocal(name);
        if (elem != null) {
            return elem;
        }
        if (this.getInternalParent() != null) {
            return this.getInternalParent().lookup(name);
        }
        return null;
    }

    @Override
    public O lookupOperation(C owner, String name, List<? extends TypedElement<C>> args) {
        O result = this.doLookupOperation(owner, name, args);
        if (result == null && AbstractOCLAnalyzer.isEscaped(name)) {
            result = this.doLookupOperation(owner, AbstractOCLAnalyzer.unescape(name), args);
        }
        return result;
    }

    private O doLookupOperation(C owner, String name, List<? extends TypedElement<C>> args) {
        if (owner == null) {
            Variable<C, PM> vdcl = this.lookupImplicitSourceForOperation(name, args);
            if (vdcl == null) {
                return null;
            }
            owner = vdcl.getType();
        }
        return TypeUtil.findOperationMatching(this, owner, name, args);
    }

    @Override
    public P lookupProperty(C owner, String name) {
        P result = this.doLookupProperty(owner, name);
        if (result == null && AbstractOCLAnalyzer.isEscaped(name)) {
            result = this.doLookupProperty(owner, AbstractOCLAnalyzer.unescape(name));
        }
        return result;
    }

    private P doLookupProperty(C owner, String name) {
        if (owner == null) {
            Variable<C, PM> vdcl = this.lookupImplicitSourceForProperty(name);
            if (vdcl == null) {
                return null;
            }
            owner = vdcl.getType();
        }
        return TypeUtil.findAttribute(this, owner, name);
    }

    @Override
    public C lookupAssociationClassReference(C owner, String name) {
        C result = this.doLookupAssociationClassReference(owner, name);
        if (result == null && AbstractOCLAnalyzer.isEscaped(name)) {
            result = this.doLookupAssociationClassReference(owner, AbstractOCLAnalyzer.unescape(name));
        }
        return result;
    }

    private C doLookupAssociationClassReference(C owner, String name) {
        if (owner == null) {
            Variable<C, PM> vdcl = this.lookupImplicitSourceForAssociationClass(name);
            if (vdcl == null) {
                return null;
            }
            owner = vdcl.getType();
        }
        C result = null;
        List properties = this.getUMLReflection().getAttributes(owner);
        Iterator iter = properties.iterator();
        while (result == null && iter.hasNext()) {
            Object next = iter.next();
            Object assocClass = this.getUMLReflection().getAssociationClass(next);
            if (assocClass == null || !name.equals(this.initialLower(assocClass))) continue;
            result = assocClass;
        }
        return result;
    }

    @Override
    public C lookupSignal(C owner, String name, List<? extends TypedElement<C>> args) {
        C result = this.doLookupSignal(owner, name, args);
        if (result == null && AbstractOCLAnalyzer.isEscaped(name)) {
            result = this.doLookupSignal(owner, AbstractOCLAnalyzer.unescape(name), args);
        }
        return result;
    }

    private C doLookupSignal(C owner, String name, List<? extends TypedElement<C>> args) {
        if (owner == null) {
            Variable<C, PM> vdcl = this.lookupImplicitSourceForSignal(name, args);
            if (vdcl == null) {
                return null;
            }
            owner = vdcl.getType();
        }
        return TypeUtil.findSignalMatching(this, owner, this.getUMLReflection().getSignals(owner), name, args);
    }

    @Override
    public S lookupState(C owner, List<String> path) throws LookupException {
        if (owner == null) {
            Variable<C, PM> vdcl = this.lookupImplicitSourceForState(path);
            if (vdcl == null) {
                return null;
            }
            owner = vdcl.getType();
        }
        int lastIndex = path.size() - 1;
        String lastName = path.get(lastIndex);
        List states = this.getStates(owner, path.subList(0, lastIndex));
        S result = null;
        for (Object next : states) {
            String nextName = this.getUMLReflection().getName(next);
            boolean matched = lastName.equals(nextName);
            if (!matched && AbstractOCLAnalyzer.isEscaped(lastName)) {
                matched = AbstractOCLAnalyzer.unescape(lastName).equals(nextName);
            }
            if (!matched) continue;
            if (result == null) {
                result = next;
                continue;
            }
            String msg = OCLMessages.bind(OCLMessages.AmbiguousState_ERROR_, path, this.getUMLReflection().getQualifiedName(owner));
            throw new LookupException(msg);
        }
        return result;
    }

    @Override
    public Variable<C, PM> lookupImplicitSourceForOperation(String name, List<? extends TypedElement<C>> args) {
        O eop;
        Object owner;
        Variable<C, PM> vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            O eop2;
            VariableEntry element = this.namedElements.get(i);
            vdcl = element.variable;
            Object owner2 = vdcl.getType();
            if (!element.isExplicit && owner2 != null && (eop2 = this.lookupOperation(owner2, name, args)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && (owner = vdcl.getType()) != null && (eop = this.lookupOperation(owner, name, args)) != null) {
            return vdcl;
        }
        return null;
    }

    @Override
    public Variable<C, PM> lookupImplicitSourceForProperty(String name) {
        P property;
        Object owner;
        Variable<C, PM> vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            P property2;
            VariableEntry element = this.namedElements.get(i);
            vdcl = element.variable;
            Object owner2 = vdcl.getType();
            if (!element.isExplicit && owner2 != null && (property2 = this.safeTryLookupProperty(owner2, name)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && (owner = vdcl.getType()) != null && (property = this.safeTryLookupProperty(owner, name)) != null) {
            return vdcl;
        }
        return null;
    }

    private P safeTryLookupProperty(C owner, String name) {
        P result;
        block2: {
            result = null;
            try {
                result = this.tryLookupProperty(owner, name);
            }
            catch (LookupException e) {
                if (e.getAmbiguousMatches().isEmpty()) break block2;
                result = (P)e.getAmbiguousMatches().get(0);
            }
        }
        return result;
    }

    @Override
    public Variable<C, PM> lookupImplicitSourceForAssociationClass(String name) {
        Object ac;
        Object owner;
        Variable<C, PM> vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            Object ac2;
            VariableEntry element = this.namedElements.get(i);
            vdcl = element.variable;
            Object owner2 = vdcl.getType();
            if (!element.isExplicit && owner2 != null && (ac2 = this.lookupAssociationClassReference(owner2, name)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && (owner = vdcl.getType()) != null && (ac = this.lookupAssociationClassReference(owner, name)) != null) {
            return vdcl;
        }
        return null;
    }

    @Override
    public Variable<C, PM> lookupImplicitSourceForSignal(String name, List<? extends TypedElement<C>> args) {
        Object sig;
        Object owner;
        Variable<C, PM> vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            Object sig2;
            VariableEntry element = this.namedElements.get(i);
            vdcl = element.variable;
            Object owner2 = vdcl.getType();
            if (!element.isExplicit && owner2 != null && (sig2 = this.lookupSignal(owner2, name, args)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && (owner = vdcl.getType()) != null && (sig = this.lookupSignal(owner, name, args)) != null) {
            return vdcl;
        }
        return null;
    }

    @Override
    public Variable<C, PM> lookupImplicitSourceForState(List<String> path) throws LookupException {
        S state;
        Object owner;
        Variable<C, PM> vdcl;
        int i = this.namedElements.size() - 1;
        while (i >= 0) {
            S state2;
            VariableEntry element = this.namedElements.get(i);
            vdcl = element.variable;
            Object owner2 = vdcl.getType();
            if (!element.isExplicit && owner2 != null && (state2 = this.lookupState(owner2, path)) != null) {
                return vdcl;
            }
            --i;
        }
        vdcl = this.getSelfVariable();
        if (vdcl != null && (owner = vdcl.getType()) != null && (state = this.lookupState(owner, path)) != null) {
            return vdcl;
        }
        return null;
    }

    protected String initialLower(Object element) {
        String name = this.getUMLReflection().getName(element);
        if (name == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(name);
        if (result.length() > 0) {
            UnicodeSupport.setCodePointAt(result, 0, Character.toLowerCase(result.codePointAt(0)));
        }
        return result.toString();
    }

    @Override
    public C tryLookupAssociationClassReference(C owner, String name) throws LookupException {
        return this.lookupAssociationClassReference(owner, name);
    }

    @Override
    public C tryLookupClassifier(List<String> names) throws LookupException {
        return this.lookupClassifier(names);
    }

    @Override
    public O tryLookupOperation(C owner, String name, List<? extends TypedElement<C>> args) throws LookupException {
        return this.lookupOperation(owner, name, args);
    }

    @Override
    public C tryLookupSignal(C owner, String name, List<? extends TypedElement<C>> args) throws LookupException {
        return this.lookupSignal(owner, name, args);
    }

    @Override
    public PK tryLookupPackage(List<String> names) throws LookupException {
        return this.lookupPackage(names);
    }

    @Override
    public P tryLookupProperty(C owner, String name) throws LookupException {
        P result = this.lookupProperty(owner, name);
        if (result == null && (result = this.lookupNonNavigableEnd(owner, name)) == null && AbstractOCLAnalyzer.isEscaped(name)) {
            result = this.lookupNonNavigableEnd(owner, AbstractOCLAnalyzer.unescape(name));
        }
        return result;
    }

    protected P lookupNonNavigableEnd(C owner, String name) throws LookupException {
        if (owner == null) {
            Variable<C, PM> vdcl = this.lookupImplicitSourceForProperty(name);
            if (vdcl == null) {
                return null;
            }
            owner = vdcl.getType();
        }
        ArrayList matches = new ArrayList(2);
        this.findNonNavigableAssociationEnds(owner, name, matches);
        if (matches.isEmpty()) {
            this.findUnnamedAssociationEnds(owner, name, matches);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1 && this.notOK(ProblemOption.AMBIGUOUS_ASSOCIATION_ENDS)) {
            ProblemHandler.Severity sev = this.getValue(ProblemOption.AMBIGUOUS_ASSOCIATION_ENDS);
            String message = OCLMessages.bind(OCLMessages.Ambig_AssocEnd_, name, this.getUMLReflection().getName(owner));
            if (sev.getDiagnosticSeverity() >= 4) {
                throw new AmbiguousLookupException(message, matches);
            }
            this.getProblemHandler().analyzerProblem(sev, message, "lookupNonNavigableProperty", -1, -1);
        }
        return (P)matches.get(0);
    }

    protected void findNonNavigableAssociationEnds(C classifier, String name, List<P> ends) {
    }

    protected void findUnnamedAssociationEnds(C classifier, String name, List<P> ends) {
    }

    public boolean notOK(Option<ProblemHandler.Severity> option) {
        ProblemHandler.Severity sev = this.getValue(option);
        return sev != null && !sev.isOK();
    }

    @Override
    public void dispose() {
        if (this.getInternalParent() == null && this.getTypeResolver() instanceof AbstractTypeResolver) {
            ((AbstractTypeResolver)this.getTypeResolver()).dispose();
        }
    }

    protected TypeChecker<C, O, P> getTypeChecker() {
        if (this.typeChecker == null) {
            this.typeChecker = this.createTypeChecker();
        }
        return this.typeChecker;
    }

    protected TypeChecker<C, O, P> createTypeChecker() {
        boolean useTypeCaches = ParsingOptions.getValue(this, ParsingOptions.USE_TYPE_CACHES);
        if (useTypeCaches) {
            return new CachedTypeChecker(this);
        }
        return new BasicTypeChecker(this);
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == TypeChecker.class) {
            return (T)this.getTypeChecker();
        }
        return super.getAdapter(adapterType);
    }

    protected void resetTypeCaches() {
        if (this.typeChecker instanceof TypeChecker.Cached) {
            ((TypeChecker.Cached)this.typeChecker).reset();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class VariableEntry {
        final String name;
        final Variable<C, PM> variable;
        final boolean isExplicit;

        VariableEntry(String name, Variable<C, PM> variable, boolean isExplicit) {
            this.name = name;
            this.variable = variable;
            this.isExplicit = isExplicit;
        }

        public Variable<C, PM> getVariable() {
            return this.variable;
        }

        public boolean isExplicit() {
            return this.isExplicit;
        }

        public String toString() {
            return "VariableEntry[" + this.name + ", " + (this.isExplicit ? "explicit, " : "implicit, ") + this.variable + "]";
        }
    }
}

