/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.participants;

import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.xsd.utils.XSDUtils;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentLink;

public class XSDDocumentLinkParticipant
implements IDocumentLinkParticipant {
    private static final Logger LOGGER = Logger.getLogger(XSDDocumentLinkParticipant.class.getName());

    @Override
    public void findDocumentLinks(DOMDocument document, List<DocumentLink> links) {
        DOMElement root = document.getDocumentElement();
        if (!XSDUtils.isXSSchema(root)) {
            return;
        }
        String xmlSchemaPrefix = root.getPrefix();
        List<DOMNode> children = root.getChildren();
        for (DOMNode child : children) {
            DOMAttr schemaLocationAttr;
            DOMElement xsdElement;
            if (!child.isElement() || !Objects.equals(child.getPrefix(), xmlSchemaPrefix) || !XSDUtils.isXSInclude(xsdElement = (DOMElement)child) && !XSDUtils.isXSImport(xsdElement) || (schemaLocationAttr = XSDUtils.getSchemaLocation(xsdElement)) == null || StringUtils.isEmpty(schemaLocationAttr.getValue())) continue;
            String location = XSDDocumentLinkParticipant.getResolvedLocation(document.getDocumentURI(), schemaLocationAttr.getValue());
            DOMNode schemaLocationRange = schemaLocationAttr.getNodeAttrValue();
            try {
                links.add(XMLPositionUtility.createDocumentLink(schemaLocationRange, location));
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "Creation of document link failed", e);
            }
        }
    }

    private static String getResolvedLocation(String documentURI, String location) {
        if (location == null) {
            return null;
        }
        try {
            return XMLEntityManager.expandSystemId((String)location, (String)documentURI, (boolean)false);
        }
        catch (URI.MalformedURIException e) {
            return location;
        }
    }
}

