/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces.xmlmodel;

import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.eclipse.lemminx.extensions.xerces.xmlmodel.XMLModelValidator;
import org.eclipse.lemminx.utils.StringUtils;

public class XMLModelSchemaValidator
extends XMLSchemaValidator
implements XMLModelValidator {
    private static final String XMLNS_ATTR = "xmlns";
    private XMLErrorReporter errorReporter;
    private boolean rootElement = true;
    private String href;

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        super.reset(componentManager);
        this.fDoValidation = true;
        try {
            XMLErrorReporter value = (XMLErrorReporter)componentManager.getProperty("http://apache.org/xml/properties/internal/error-reporter");
            if (value != null) {
                this.errorReporter = value;
            }
        }
        catch (XMLConfigurationException e) {
            this.errorReporter = null;
        }
    }

    @Override
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public void setLocator(XMLLocator locator) {
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (this.rootElement) {
            String defaultNamespace = attributes.getValue(XMLNS_ATTR);
            if (StringUtils.isEmpty(defaultNamespace)) {
                String noNamespaceSchemaLocation = this.href;
                XMLSchemaLoader.processExternalHints(null, (String)noNamespaceSchemaLocation, (Hashtable)this.fLocationPairs, (XMLErrorReporter)this.errorReporter);
            } else {
                String schemaLocation = defaultNamespace + ' ' + this.href;
                XMLSchemaLoader.processExternalHints((String)schemaLocation, null, (Hashtable)this.fLocationPairs, (XMLErrorReporter)this.errorReporter);
            }
            this.rootElement = false;
        }
        super.startElement(element, attributes, augs);
    }
}

