/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMComment;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.services.extensions.format.IFormatterParticipant;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.StringUtils;

public class XMLBuilder {
    private final SharedSettings sharedSettings;
    private final String lineDelimiter;
    private final StringBuilder xml;
    private final String whitespacesIndent;
    private final Collection<IFormatterParticipant> formatterParticipants;
    private static final Logger LOGGER = Logger.getLogger(XMLBuilder.class.getName());

    public XMLBuilder(SharedSettings sharedSettings, String whitespacesIndent, String lineDelimiter) {
        this(sharedSettings, whitespacesIndent, lineDelimiter, null);
    }

    public XMLBuilder(SharedSettings sharedSettings, String whitespacesIndent, String lineDelimiter, Collection<IFormatterParticipant> formatterParticipants) {
        this.whitespacesIndent = whitespacesIndent;
        this.sharedSettings = sharedSettings;
        this.lineDelimiter = lineDelimiter;
        this.formatterParticipants = formatterParticipants;
        this.xml = new StringBuilder();
    }

    public XMLBuilder appendSpace() {
        this.append(" ");
        return this;
    }

    public XMLBuilder startElement(String prefix, String name, boolean close) {
        this.append("<");
        if (prefix != null && !prefix.isEmpty()) {
            this.append(prefix);
            this.append(":");
        }
        this.append(name);
        if (close) {
            this.closeStartElement();
        }
        return this;
    }

    public XMLBuilder startElement(String name, boolean close) {
        return this.startElement(null, name, close);
    }

    public XMLBuilder endElement(String name, boolean isEndTagClosed) {
        return this.endElement(null, name, isEndTagClosed);
    }

    public XMLBuilder endElement(String name) {
        return this.endElement(null, name, true);
    }

    public XMLBuilder endElement(String prefix, String name) {
        return this.endElement(prefix, name, true);
    }

    public XMLBuilder endElement(String prefix, String name, boolean isEndTagClosed) {
        this.append("</");
        if (prefix != null && !prefix.isEmpty()) {
            this.append(prefix);
            this.append(":");
        }
        if (name != null) {
            this.append(name);
        }
        if (isEndTagClosed) {
            this.append(">");
        }
        return this;
    }

    public XMLBuilder closeStartElement() {
        this.append(">");
        return this;
    }

    public XMLBuilder selfCloseElement() {
        if (this.isSpaceBeforeEmptyCloseTag() && !this.isLastLineEmptyOrWhitespace()) {
            this.appendSpace();
        }
        this.append("/>");
        return this;
    }

    public XMLBuilder addSingleAttribute(DOMAttr attr) {
        return this.addSingleAttribute(attr, false, true);
    }

    public XMLBuilder addSingleAttribute(DOMAttr attr, boolean surroundWithQuotes, boolean prependSpace) {
        return this.addSingleAttribute(attr.getName(), attr.getOriginalValue(), surroundWithQuotes, prependSpace, attr);
    }

    public XMLBuilder addSingleAttribute(String name, String value, boolean surroundWithQuotes) {
        return this.addSingleAttribute(name, value, surroundWithQuotes, true, null);
    }

    private XMLBuilder addSingleAttribute(String name, String value, boolean surroundWithQuotes, boolean prependSpace, DOMAttr attr) {
        if (prependSpace) {
            this.appendSpace();
        }
        this.addAttributeContents(name, true, value, surroundWithQuotes, attr);
        return this;
    }

    public XMLBuilder addPrologAttribute(DOMAttr attr) {
        this.appendSpace();
        this.addAttributeContents(attr.getName(), attr.hasDelimiter(), attr.getOriginalValue(), false, attr);
        return this;
    }

    public XMLBuilder addAttribute(String name, String value, int level, boolean surroundWithQuotes) {
        if (this.isSplitAttributes()) {
            this.linefeed();
            this.indent(level + this.sharedSettings.getFormattingSettings().getSplitAttributesIndentSize());
        } else {
            this.appendSpace();
        }
        this.addAttributeContents(name, true, value, surroundWithQuotes, null);
        return this;
    }

    public XMLBuilder addAttribute(DOMAttr attr, int level) {
        return this.addAttribute(attr, level, false);
    }

    private XMLBuilder addAttribute(DOMAttr attr, int level, boolean surroundWithQuotes) {
        if (this.isSplitAttributes()) {
            this.linefeed();
            this.indent(level + this.sharedSettings.getFormattingSettings().getSplitAttributesIndentSize());
        } else {
            this.appendSpace();
        }
        this.addAttributeContents(attr.getName(), attr.hasDelimiter(), attr.getOriginalValue(), surroundWithQuotes, attr);
        return this;
    }

    private void addAttributeContents(String name, boolean equalsSign, String originalValue, boolean surroundWithQuotes, DOMAttr attr) {
        if (name != null) {
            this.append(name);
        }
        if (equalsSign) {
            this.append("=");
        }
        if (originalValue != null) {
            char preferredQuote = this.getQuotationAsChar();
            Character quote = null;
            String valueWithoutQuote = originalValue;
            if (StringUtils.isQuoted(originalValue)) {
                quote = this.getEnforceQuoteStyle() == EnforceQuoteStyle.preferred && originalValue.charAt(0) != preferredQuote ? Character.valueOf(preferredQuote) : Character.valueOf(originalValue.charAt(0));
                valueWithoutQuote = StringUtils.convertToQuotelessValue(originalValue);
            } else if (surroundWithQuotes) {
                quote = Character.valueOf(preferredQuote);
            }
            this.formatAttributeValue(name, valueWithoutQuote, quote, attr);
        }
    }

    private void formatAttributeValue(String name, String valueWithoutQuote, Character quote, DOMAttr attr) {
        if (this.formatterParticipants != null) {
            for (IFormatterParticipant formatterParticipant : this.formatterParticipants) {
                try {
                    if (!formatterParticipant.formatAttributeValue(name, valueWithoutQuote, quote, attr, this)) continue;
                    return;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while processing format attributes for the participant '" + formatterParticipant.getClass().getName() + "'.", e);
                }
            }
        }
        if (quote != null) {
            this.append(quote.charValue());
        }
        this.append(valueWithoutQuote);
        if (quote != null) {
            this.append(quote.charValue());
        }
    }

    public void append(String str) {
        this.xml.append(str);
    }

    public void append(char c) {
        this.xml.append(c);
    }

    public XMLBuilder linefeed() {
        this.append(this.lineDelimiter);
        if (this.whitespacesIndent != null) {
            this.append(this.whitespacesIndent);
        }
        return this;
    }

    public XMLBuilder addContent(String text) {
        return this.addContent(text, false, false, null);
    }

    public XMLBuilder addContent(String text, boolean isWhitespaceContent, boolean hasSiblings, String delimiter) {
        int preservedNewLines;
        if (!isWhitespaceContent) {
            if (this.isJoinContentLines()) {
                text = StringUtils.normalizeSpace(text);
            } else if (hasSiblings) {
                text = text.trim();
            }
            if (this.isTrimTrailingWhitespace()) {
                text = XMLBuilder.trimTrailingSpacesEachLine(text);
            }
            this.append(text);
        } else if (!hasSiblings && this.isPreserveEmptyContent()) {
            this.append(text);
        } else if (hasSiblings && (preservedNewLines = this.getPreservedNewlines()) > 0) {
            int newLineCount = StringUtils.getNumberOfNewLines(text, isWhitespaceContent, delimiter, preservedNewLines);
            for (int i = 0; i < newLineCount - 1; ++i) {
                this.append(delimiter);
            }
        }
        return this;
    }

    public XMLBuilder indent(int level) {
        for (int i = 0; i < level; ++i) {
            if (this.isInsertSpaces()) {
                for (int j = 0; j < this.getTabSize(); ++j) {
                    this.appendSpace();
                }
                continue;
            }
            this.append("\t");
        }
        return this;
    }

    public XMLBuilder startPrologOrPI(String tagName) {
        this.append("<?");
        this.append(tagName);
        return this;
    }

    public XMLBuilder addContentPI(String content) {
        this.appendSpace();
        this.append(content);
        return this;
    }

    public XMLBuilder endPrologOrPI() {
        this.append("?>");
        return this;
    }

    public String toString() {
        return this.xml.toString();
    }

    public void trimFinalNewlines() {
        int i = this.xml.length() - 1;
        while (i >= 0 && Character.isWhitespace(this.xml.charAt(i))) {
            this.xml.deleteCharAt(i--);
        }
    }

    private static String trimTrailingSpacesEachLine(String str) {
        StringBuilder sb = new StringBuilder(str);
        boolean removeSpaces = true;
        for (int i = str.length() - 1; i >= 0; --i) {
            char curr = sb.charAt(i);
            if (curr == '\n' || curr == '\r') {
                removeSpaces = true;
                continue;
            }
            if (removeSpaces && Character.isWhitespace(curr)) {
                sb.deleteCharAt(i);
                continue;
            }
            removeSpaces = false;
        }
        return sb.toString();
    }

    public XMLBuilder startCDATA() {
        this.append("<![CDATA[");
        return this;
    }

    public XMLBuilder addContentCDATA(String content) {
        if (this.isJoinCDATALines()) {
            content = StringUtils.normalizeSpace(content);
        }
        this.append(content);
        return this;
    }

    public XMLBuilder endCDATA() {
        this.append("]]>");
        return this;
    }

    public XMLBuilder startComment(DOMComment comment) {
        if (comment.isCommentSameLineEndTag()) {
            this.appendSpace();
        }
        this.append("<!--");
        return this;
    }

    public XMLBuilder addContentComment(String content) {
        if (this.isJoinCommentLines()) {
            this.appendSpace();
            this.append(StringUtils.normalizeSpace(content));
            this.appendSpace();
        } else {
            this.append(content);
        }
        return this;
    }

    public XMLBuilder addDeclTagStart(DTDDeclNode tag) {
        this.append("<!" + tag.getDeclType());
        return this;
    }

    public XMLBuilder addDeclTagStart(String declTagName) {
        this.append("<!" + declTagName);
        return this;
    }

    public XMLBuilder startDoctype() {
        this.append("<!DOCTYPE");
        return this;
    }

    public XMLBuilder startDTDElementDecl() {
        this.append("<!ELEMENT");
        return this;
    }

    public XMLBuilder startDTDAttlistDecl() {
        this.append("<!ATTLIST");
        return this;
    }

    public XMLBuilder addParameter(String parameter) {
        return this.addUnindentedParameter(" " + this.replaceQuotesIfNeeded(parameter));
    }

    public XMLBuilder addUnindentedParameter(String parameter) {
        this.append(this.replaceQuotesIfNeeded(parameter));
        return this;
    }

    public XMLBuilder startDoctypeInternalSubset() {
        this.append(" [");
        return this;
    }

    public XMLBuilder startUnindentedDoctypeInternalSubset() {
        this.append("[");
        return this;
    }

    public XMLBuilder endDoctypeInternalSubset() {
        this.append("]");
        return this;
    }

    public XMLBuilder endComment() {
        this.append("-->");
        return this;
    }

    public XMLBuilder endDoctype() {
        this.append(">");
        return this;
    }

    public boolean isLastLineEmptyOrWhitespace() {
        int i;
        if (this.xml.length() == 0) {
            return true;
        }
        for (i = this.xml.length() - 1; i > 0 && Character.isSpaceChar(this.xml.charAt(i)); --i) {
        }
        return i > 0 && (this.xml.charAt(i) == '\r' || this.xml.charAt(i) == '\n');
    }

    private String replaceQuotesIfNeeded(String str) {
        if (this.getEnforceQuoteStyle() != EnforceQuoteStyle.preferred) {
            return str;
        }
        if (StringUtils.isQuoted(str)) {
            String quote = this.getQuotationAsString();
            return quote + StringUtils.convertToQuotelessValue(str) + quote;
        }
        return str;
    }

    private EnforceQuoteStyle getEnforceQuoteStyle() {
        return this.sharedSettings.getFormattingSettings().getEnforceQuoteStyle();
    }

    private String getQuotationAsString() {
        return this.sharedSettings.getPreferences().getQuotationAsString();
    }

    private boolean isJoinCommentLines() {
        return this.sharedSettings.getFormattingSettings().isJoinCommentLines();
    }

    private boolean isJoinCDATALines() {
        return this.sharedSettings.getFormattingSettings().isJoinCDATALines();
    }

    private boolean isSplitAttributes() {
        return this.sharedSettings.getFormattingSettings().isSplitAttributes();
    }

    private boolean isInsertSpaces() {
        return this.sharedSettings.getFormattingSettings().isInsertSpaces();
    }

    private int getTabSize() {
        return this.sharedSettings.getFormattingSettings().getTabSize();
    }

    private boolean isJoinContentLines() {
        return this.sharedSettings.getFormattingSettings().isJoinContentLines();
    }

    private boolean isPreserveEmptyContent() {
        return this.sharedSettings.getFormattingSettings().isPreserveEmptyContent();
    }

    private boolean isTrimTrailingWhitespace() {
        return this.sharedSettings.getFormattingSettings().isTrimTrailingWhitespace();
    }

    private int getPreservedNewlines() {
        return this.sharedSettings.getFormattingSettings().getPreservedNewlines();
    }

    private boolean isSpaceBeforeEmptyCloseTag() {
        return this.sharedSettings.getFormattingSettings().isSpaceBeforeEmptyCloseTag();
    }

    private char getQuotationAsChar() {
        return this.sharedSettings.getPreferences().getQuotationAsChar();
    }

    public int length() {
        return this.xml.length();
    }

    public char charAt(int index) {
        return this.xml.charAt(index);
    }

    public SharedSettings getSharedSettings() {
        return this.sharedSettings;
    }
}

