/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMProcessingInstruction;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.xerces.xmlmodel.XMLModelDeclaration;
import org.w3c.dom.ProcessingInstruction;

public class XMLModel {
    private static final String XML_MODEL_PI = "xml-model";
    private final DOMProcessingInstruction processingInstruction;
    private XMLModelDeclaration declaration;
    private DOMRange hrefNode;

    public XMLModel(DOMProcessingInstruction processingInstruction) {
        this.processingInstruction = processingInstruction;
    }

    public String getHref() {
        XMLModelDeclaration declaration = this.getModelDeclaration();
        return declaration != null ? declaration.getHref() : null;
    }

    private XMLModelDeclaration getModelDeclaration() {
        String data = this.processingInstruction.getData();
        if (data == null) {
            return null;
        }
        if (this.declaration == null) {
            this.declaration = XMLModelDeclaration.parse(data.toCharArray(), 0, data.length());
        }
        return this.declaration;
    }

    static List<XMLModel> createXMLModels(DOMDocument document) {
        List<DOMNode> children = document.getChildren();
        if (children != null && !children.isEmpty()) {
            return children.stream().filter(XMLModel::isXMLModel).map(node -> new XMLModel((DOMProcessingInstruction)node)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static boolean isXMLModel(DOMNode node) {
        return node.isProcessingInstruction() && XML_MODEL_PI.equals(((ProcessingInstruction)((Object)node)).getTarget());
    }

    public DOMRange getHrefNode() {
        if (this.hrefNode == null) {
            XMLModelDeclaration declaration = this.getModelDeclaration();
            if (declaration == null || declaration.getHref() == null) {
                return null;
            }
            int start = this.processingInstruction.getStartContent() + declaration.getHrefOffset() - 1;
            int end = start + declaration.getHref().length() + 2;
            this.hrefNode = new SimpleDOMRange(start, end, this.processingInstruction.getOwnerDocument());
        }
        return this.hrefNode;
    }

    private static class SimpleDOMRange
    implements DOMRange {
        private final int start;
        private final int end;
        private final DOMDocument ownerDocument;

        public SimpleDOMRange(int start, int end, DOMDocument ownerDocument) {
            this.start = start;
            this.end = end;
            this.ownerDocument = ownerDocument;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return this.ownerDocument;
        }
    }
}

