/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces;

import java.io.IOException;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLDTDDescription;
import org.apache.xerces.impl.dtd.XMLDTDLoader;
import org.apache.xerces.impl.dtd.XMLDTDValidator;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.extensions.xerces.ReflectionUtils;

public class ExternalXMLDTDValidator
extends XMLDTDValidator {
    public static final String DOCTYPE = "http://apache.org/xml/properties/dtd/external-doctype";
    private static final String DTD_NOT_FOUND_KEY = "dtd_not_found";
    private static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    private boolean rootElement = true;
    private XMLLocator locator;
    private XMLEntityManager entityManager;
    private String externalDoctype;
    private XMLErrorReporter reporterForGrammar;

    public void setExternalDoctype(String externalDoctype) {
        this.externalDoctype = externalDoctype;
    }

    public void setLocator(XMLLocator locator) {
        this.locator = locator;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, namespaceContext, augs);
        this.setLocator(locator);
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.tryToBindWithExternalDTD(element);
        super.startElement(element, attributes, augs);
    }

    private void tryToBindWithExternalDTD(QName element) {
        if (this.rootElement) {
            this.rootElement = false;
            this.fDTDValidation = this.externalDoctype != null;
            this.fValidation = this.fDTDValidation;
            if (this.fValidation) {
                QName fRootElement = this.getRootElement();
                String rootElementName = element.localpart;
                fRootElement.setValues(null, rootElementName, rootElementName, null);
                String eid = null;
                try {
                    eid = XMLEntityManager.expandSystemId((String)this.externalDoctype, (String)this.locator.getExpandedSystemId(), (boolean)false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                XMLDTDDescription grammarDesc = new XMLDTDDescription(null, this.externalDoctype, this.locator.getExpandedSystemId(), eid, rootElementName);
                this.fDTDGrammar = this.fGrammarBucket.getGrammar((XMLGrammarDescription)grammarDesc);
                if (this.fDTDGrammar == null && this.fGrammarPool != null) {
                    this.fDTDGrammar = (DTDGrammar)this.fGrammarPool.retrieveGrammar((XMLGrammarDescription)grammarDesc);
                }
                if (this.fDTDGrammar == null) {
                    XMLDTDLoader loader = new XMLDTDLoader(this.fSymbolTable, this.fGrammarPool);
                    loader.setProperty("http://apache.org/xml/properties/internal/error-reporter", (Object)this.reporterForGrammar);
                    loader.setEntityResolver((XMLEntityResolver)this.entityManager);
                    try {
                        this.fDTDGrammar = (DTDGrammar)loader.loadGrammar(new XMLInputSource(null, eid, null));
                    }
                    catch (Exception e) {
                        this.fErrorReporter.reportError(this.locator, "https://www.w3.org/TR/xml-model/", DTD_NOT_FOUND_KEY, new Object[]{element, eid}, (short)1);
                        this.fValidation = false;
                    }
                } else {
                    this.fValidationManager.setCachedDTD(true);
                }
            }
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.tryToBindWithExternalDTD(element);
        super.emptyElement(element, attributes, augs);
    }

    private QName getRootElement() {
        try {
            return (QName)ReflectionUtils.getFieldValue((Object)this, "fRootElement");
        }
        catch (Exception e) {
            return null;
        }
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.entityManager = (XMLEntityManager)componentManager.getProperty(ENTITY_MANAGER);
        try {
            this.setExternalDoctype((String)componentManager.getProperty(DOCTYPE));
        }
        catch (XMLConfigurationException e) {
            this.setExternalDoctype(null);
        }
        super.reset(componentManager);
        this.reporterForGrammar = (XMLErrorReporter)componentManager.getProperty("http://apache.org/xml/properties/internal/error-reporter-grammar");
        this.fValidation = false;
        this.fDTDValidation = false;
    }
}

