/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.DownloadDisabledResourceCodeAction;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;

public enum ExternalResourceErrorCode implements IXMLErrorCode
{
    DownloadResourceDisabled,
    DownloadingResource,
    ResourceNotInDeployedPath,
    DownloadProblem;

    private final String code;
    private static final Map<String, ExternalResourceErrorCode> codes;

    private ExternalResourceErrorCode() {
        this(null);
    }

    private ExternalResourceErrorCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        if (this.code == null) {
            return this.name();
        }
        return this.code;
    }

    public static ExternalResourceErrorCode get(String name) {
        return codes.get(name);
    }

    public static void registerCodeActionParticipants(Map<String, ICodeActionParticipant> codeActionParticipants) {
        codeActionParticipants.put(DownloadResourceDisabled.getCode(), new DownloadDisabledResourceCodeAction());
    }

    static {
        codes = new HashMap<String, ExternalResourceErrorCode>();
        for (ExternalResourceErrorCode errorCode : ExternalResourceErrorCode.values()) {
            codes.put(errorCode.getCode(), errorCode);
        }
    }
}

