/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.junit.jupiter.api.Test;

public class XMLSchemaCompletionExtensionsTest
extends BaseFileTempTest {
    @Test
    public void completionInRoot() throws BadLocationException {
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n\t<|</project>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("modelVersion", XMLAssert.te(3, 1, 3, 2, "<modelVersion></modelVersion>"), "<modelVersion"), XMLAssert.c("parent", "<parent></parent>", "<parent"));
        xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n\t<|   ></project>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("modelVersion", XMLAssert.te(3, 1, 3, 6, "<modelVersion></modelVersion>"), "<modelVersion"), XMLAssert.c("parent", "<parent></parent>", "<parent"));
        xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n\t|</project>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("modelVersion", XMLAssert.te(3, 1, 3, 1, "<modelVersion></modelVersion>"), "modelVersion"), XMLAssert.c("parent", "<parent></parent>", "parent"));
        xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n\tmod|</project>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("modelVersion", XMLAssert.te(3, 1, 3, 4, "<modelVersion></modelVersion>"), "modelVersion"), XMLAssert.c("parent", "<parent></parent>", "parent"));
    }

    @Test
    public void completionInRootWithCloseBracket() throws BadLocationException {
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n\t<|  ></project>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("modelVersion", XMLAssert.te(3, 1, 3, 5, "<modelVersion></modelVersion>"), "<modelVersion"), XMLAssert.c("parent", "<parent></parent>", "<parent"));
    }

    @Test
    public void completionInChildElement() throws BadLocationException {
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n\t<parent><|</project>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("groupId", "<groupId></groupId>", "<groupId"), XMLAssert.c("artifactId", "<artifactId></artifactId>", "<artifactId"), XMLAssert.c("version", "<version></version>", "<version"));
    }

    @Test
    public void completionInChildElementNoOpenBracket() throws BadLocationException {
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n\t<parent>|</project>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("groupId", "<groupId></groupId>", "groupId"), XMLAssert.c("artifactId", "<artifactId></artifactId>", "artifactId"), XMLAssert.c("version", "<version></version>", "version"));
    }

    @Test
    public void completionInRootWithAndWithoutPrefixes() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\"\r\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n       xmlns:camel=\"http://camel.apache.org/schema/spring\"\r\n       xmlns:cxf=\"http://camel.apache.org/schema/cxf\"\r\n       xsi:schemaLocation=\"\r\n         http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n         http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd\r\n         http://camel.apache.org/schema/cxf http://camel.apache.org/schema/cxf/camel-cxf.xsd\">\r\n\r\n  <| ";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("bean", "<bean></bean>", "<bean"), XMLAssert.c("camel:camelContext", "<camel:camelContext></camel:camelContext>", "<camel:camelContext"));
    }

    @Test
    public void completionInRootWithAndWithoutPrefixesNoOpenBracket() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\"\r\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n       xmlns:camel=\"http://camel.apache.org/schema/spring\"\r\n       xmlns:cxf=\"http://camel.apache.org/schema/cxf\"\r\n       xsi:schemaLocation=\"\r\n         http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n         http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd\r\n         http://camel.apache.org/schema/cxf http://camel.apache.org/schema/cxf/camel-cxf.xsd\">\r\n\r\n  | ";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("bean", "<bean></bean>", "bean"), XMLAssert.c("camel:camelContext", "<camel:camelContext></camel:camelContext>", "camel:camelContext"));
    }

    @Test
    public void completionInRootWithOnlyPrefix() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\"\r\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n       xmlns:camel=\"http://camel.apache.org/schema/spring\"\r\n       xmlns:cxf=\"http://camel.apache.org/schema/cxf\"\r\n       xsi:schemaLocation=\"\r\n         http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n         http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd\r\n         http://camel.apache.org/schema/cxf http://camel.apache.org/schema/cxf/camel-cxf.xsd\">\r\n\r\n  <camel:| ";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("camel:camelContext", "<camel:camelContext></camel:camelContext>"));
    }

    @Test
    public void completionInChildElementWithPrefixes() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\"\r\n       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n       xmlns:camel=\"http://camel.apache.org/schema/spring\"\r\n       xmlns:cxf=\"http://camel.apache.org/schema/cxf\"\r\n       xsi:schemaLocation=\"\r\n         http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\r\n         http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd\r\n         http://camel.apache.org/schema/cxf http://camel.apache.org/schema/cxf/camel-cxf.xsd\">\r\n\r\n  <camel:camelContext><| ";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("camel:route", "<camel:route></camel:route>"), XMLAssert.c("camel:template", "<camel:template />"));
    }

    @Test
    public void completionInChildElementWithElementWhichDeclareNS() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<root>\r\n  <camelContext id=\"camel\" xmlns=\"http://camel.apache.org/schema/spring\">\r\n\r\n    <|";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("route", "<route></route>"), XMLAssert.c("template", "<template />"));
    }

    @Test
    public void noNamespaceSchemaLocationCompletion() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<Configuration xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/Format.xsd\">\r\n  <ViewDefinitions>\r\n    <View><|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/Format.xml", 6, XMLAssert.c("Name", "<Name></Name>"), XMLAssert.c("End with '</Configuration>'", "/Configuration>"), XMLAssert.c("End with '</ViewDefinitions>'", "/ViewDefinitions>"), XMLAssert.c("End with '</View>'", "/View>"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<Configuration xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/Format.xsd\">\r\n  <ViewDefinitions>\r\n    <View><Name /><|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/Format.xml", 7, XMLAssert.c("OutOfBand", "<OutOfBand>false</OutOfBand>"), XMLAssert.c("ViewSelectedBy", "<ViewSelectedBy></ViewSelectedBy>"), XMLAssert.c("End with '</Configuration>'", "/Configuration>"), XMLAssert.c("End with '</ViewDefinitions>'", "/ViewDefinitions>"), XMLAssert.c("End with '</View>'", "/View>"));
    }

    @Test
    public void schemaLocationWithXSDFileSystemCompletion() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:schemaLocation=\"http://invoice xsd/invoice-ns.xsd \">\r\n  <|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/invoice.xml", 4, XMLAssert.c("date", "<date></date>"), XMLAssert.c("End with '</invoice>'", "</invoice>"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:schemaLocation=\"http://invoice xsd/invoice-ns.xsd \">\r\n  <date></date>|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/invoice.xml", 4, XMLAssert.c("number", "<number></number>"), XMLAssert.c("End with '</invoice>'", "</invoice>"));
    }

    @Test
    public void completionOnAttributeName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean |/>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("abstract", "abstract=\"false\""), XMLAssert.c("autowire", "autowire=\"default\""), XMLAssert.c("class", "class=\"\""));
    }

    @Test
    public void completionOnAttributeNameResolve() throws BadLocationException {
        String xml = "<dress\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/dressSize.xsd\"\r\n\ts| />";
        XMLAssert.testCompletionItemResolveFor(xml, null, "src/test/resources/dress.xml", 5, XMLAssert.c("size", XMLAssert.te(3, 1, 3, 2, "size=\"\""), "size", "Size Type documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"), XMLAssert.c("xmlns", XMLAssert.te(3, 1, 3, 2, "xmlns=\"\""), "xmlns"), XMLAssert.c("xsi:nil", XMLAssert.te(3, 1, 3, 2, "xsi:nil=\"true\""), "xsi:nil"), XMLAssert.c("xsi:type", XMLAssert.te(3, 1, 3, 2, "xsi:type=\"\""), "xsi:type"), XMLAssert.c("xsi:schemaLocation", XMLAssert.te(3, 1, 3, 2, "xsi:schemaLocation=\"\""), "xsi:schemaLocation"));
        XMLAssert.testCompletionItemUnresolvedFor(xml, null, "src/test/resources/dress.xml", 5, XMLAssert.c("size", XMLAssert.te(3, 1, 3, 2, "size=\"\""), "size"), XMLAssert.c("xmlns", XMLAssert.te(3, 1, 3, 2, "xmlns=\"\""), "xmlns"), XMLAssert.c("xsi:nil", XMLAssert.te(3, 1, 3, 2, "xsi:nil=\"true\""), "xsi:nil"), XMLAssert.c("xsi:type", XMLAssert.te(3, 1, 3, 2, "xsi:type=\"\""), "xsi:type"), XMLAssert.c("xsi:schemaLocation", XMLAssert.te(3, 1, 3, 2, "xsi:schemaLocation=\"\""), "xsi:schemaLocation"));
    }

    @Test
    public void completionOnAttributeValue() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean autowire=\"|\"/>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("byName", "byName"), XMLAssert.c("byType", "byType"), XMLAssert.c("constructor", "constructor"));
    }

    @Test
    public void completionOnAttributeValue2() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://invoice\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:schemaLocation=\"http://invoice xsd/invoice.xsd \">\r\n  <payments>\r\n    <payment method=\"|\"/>\r\n  </payments>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/invoice.xml", null, XMLAssert.c("credit", "credit"), XMLAssert.c("debit", "debit"), XMLAssert.c("cash", "cash"));
    }

    @Test
    public void completionOnAttributeValueWithUnionAndEnumeration() throws BadLocationException {
        String xml = "<dress\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/dressSize.xsd\"\r\n\tsize=\"|\" />";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/dress.xml", 4, XMLAssert.c("small", XMLAssert.te(3, 7, 3, 7, "small"), "small", "Small documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"), XMLAssert.c("medium", XMLAssert.te(3, 7, 3, 7, "medium"), "medium", "Medium documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"), XMLAssert.c("large", XMLAssert.te(3, 7, 3, 7, "large"), "large", "Size Type documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"), XMLAssert.c("x-large", XMLAssert.te(3, 7, 3, 7, "x-large"), "x-large", "Size Type documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"));
    }

    @Test
    public void completionOnAttributeValueWithUnionAndEnumerationResolve() throws BadLocationException {
        String xml = "<dress\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/dressSize.xsd\"\r\n\tsize=\"|\" />";
        XMLAssert.testCompletionItemResolveFor(xml, null, "src/test/resources/dress.xml", 4, XMLAssert.c("small", XMLAssert.te(3, 7, 3, 7, "small"), "small", "Small documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"), XMLAssert.c("medium", XMLAssert.te(3, 7, 3, 7, "medium"), "medium", "Medium documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"), XMLAssert.c("large", XMLAssert.te(3, 7, 3, 7, "large"), "large", "Size Type documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"), XMLAssert.c("x-large", XMLAssert.te(3, 7, 3, 7, "x-large"), "x-large", "Size Type documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"));
        XMLAssert.testCompletionItemUnresolvedFor(xml, null, "src/test/resources/dress.xml", 4, XMLAssert.c("small", XMLAssert.te(3, 7, 3, 7, "small"), "small"), XMLAssert.c("medium", XMLAssert.te(3, 7, 3, 7, "medium"), "medium"), XMLAssert.c("large", XMLAssert.te(3, 7, 3, 7, "large"), "large"), XMLAssert.c("x-large", XMLAssert.te(3, 7, 3, 7, "x-large"), "x-large"));
    }

    @Test
    public void completionOnTextWithUnionAndEnumeration() throws BadLocationException {
        String xml = "<dresssize\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/dressSize.xsd\" >\r\n\t| </dresssize>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/dressSize.xml", 8, XMLAssert.c("small", XMLAssert.te(2, 52, 3, 2, "small"), "\r\n\tsmall", "Small documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"), XMLAssert.c("medium", XMLAssert.te(2, 52, 3, 2, "medium"), "\r\n\tmedium", "Medium documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"), XMLAssert.c("large", XMLAssert.te(2, 52, 3, 2, "large"), "\r\n\tlarge", "Size Type documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"), XMLAssert.c("x-large", XMLAssert.te(2, 52, 3, 2, "x-large"), "\r\n\tx-large", "Size Type documentation" + System.lineSeparator() + System.lineSeparator() + "Source: dressSize.xsd", "plaintext"));
    }

    @Test
    public void completionOnTextWithEnumeration() throws BadLocationException {
        String xml = "<team xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"team_namespace\" xsi:schemaLocation=\"team_namespace xsd/team.xsd\">\r\n\t<member>\r\n\t\t<skills>\r\n\t\t\t|\r\n\t\t</skills>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/team.xml", null, XMLAssert.c("skill", "<skill>Java</skill>", XMLAssert.r(3, 3, 3, 3), "skill"));
        this.testCompletionSnippetSupportFor(xml, "src/test/resources/team.xml", null, XMLAssert.c("skill", "<skill>${1|Java,Node,XML|}$2</skill>$0", XMLAssert.r(3, 3, 3, 3), "skill"));
        xml = "<team xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"team_namespace\" xsi:schemaLocation=\"team_namespace xsd/team.xsd\">\r\n\t<member>\r\n\t\t<skills>\r\n\t\t\t<skill>|</skill>\r\n\t\t</skills>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/team.xml", null, XMLAssert.c("Java", "Java", XMLAssert.r(3, 10, 3, 10), "Java"), XMLAssert.c("Node", "Node", XMLAssert.r(3, 10, 3, 10), "Node"), XMLAssert.c("XML", "XML", XMLAssert.r(3, 10, 3, 10), "XML"));
        xml = "<team xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"team_namespace\" xsi:schemaLocation=\"team_namespace xsd/team.xsd\">\r\n\t<member>\r\n\t\t<skills>\r\n\t\t\t<skill> |</skill>\r\n\t\t</skills>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/team.xml", null, XMLAssert.c("Java", "Java", XMLAssert.r(3, 10, 3, 11), " Java"), XMLAssert.c("Node", "Node", XMLAssert.r(3, 10, 3, 11), " Node"), XMLAssert.c("XML", "XML", XMLAssert.r(3, 10, 3, 11), " XML"));
    }

    @Test
    public void schemaLocationWithElementAndAttributeCompletion() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<invoice xmlns=\"http://simpleAttribute\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n xsi:schemaLocation=\"http://simpleAttribute xsd/simpleAttribute.xsd \">\r\n  <pro|</invoice>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/simpleAttribute.xml", null, XMLAssert.c("product", "<product description=\"\" />"));
    }

    @Test
    public void completionWithoutStartBracket() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t|";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("bean", "<bean></bean>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t|</beans>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("bean", "<bean></bean>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean />|</beans>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("bean", "<bean></bean>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean />|";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("bean", "<bean></bean>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean ></bean>|</beans>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("bean", "<bean></bean>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean ></bean>|";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("bean", "<bean></bean>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean>|</bean>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("constructor-arg", "<constructor-arg></constructor-arg>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<bean>\r\n   |      \r\n</bean>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("constructor-arg", "<constructor-arg></constructor-arg>"));
    }

    @Test
    public void completionWithXMLSchemaContentChanged() throws Exception {
        String xsdPath = tempDirUri.getPath() + "/resources.xsd";
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<resources | xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"" + xsdPath + "\">\r\n    <resource name=\"res00\" >\r\n        <property name=\"propA\" value=\"...\" />\r\n        <property name=\"propB\" value=\"...\" />\r\n    </resource>\r\n    <resource name=\"\" >\r\n        <property name=\"\" value=\"...\" />\r\n        <property name=\"\" value=\"...\" />\r\n    </resource> \r\n</resources>";
        String schema = "<?xml version=\"1.0\"?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n\r\n    <xs:complexType name=\"property\">\r\n        <xs:attribute name=\"name\" type=\"xs:string\" />\r\n        <xs:attribute name=\"value\" type=\"xs:string\" />\r\n    </xs:complexType>\r\n\r\n    <xs:complexType name=\"resource\">\r\n        <xs:sequence>\r\n            <xs:element name=\"property\" type=\"property\" minOccurs=\"0\" maxOccurs=\"unbounded\" />\r\n        </xs:sequence>\r\n        <xs:attribute name=\"name\" type=\"xs:string\" use=\"required\" />\r\n    </xs:complexType>\r\n\r\n    <xs:element name=\"resources\">\r\n        <xs:complexType>\r\n            <xs:sequence>\r\n                <xs:element name=\"resource\" type=\"resource\" minOccurs=\"0\" maxOccurs=\"unbounded\" />\r\n            </xs:sequence>\r\n            <xs:attribute name=\"variant\" type=\"xs:string\" use=\"required\"/>\r\n        </xs:complexType>\r\n    </xs:element>\r\n</xs:schema>";
        XMLSchemaCompletionExtensionsTest.createFile(xsdPath, schema);
        XMLAssert.testCompletionFor(xmlLanguageService, xml, null, null, "target/resources.xml", (Integer)5, false, XMLAssert.c("variant", "variant=\"\""));
        schema = "<?xml version=\"1.0\"?>\r\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\r\n\r\n    <xs:complexType name=\"property\">\r\n        <xs:attribute name=\"name\" type=\"xs:string\" />\r\n        <xs:attribute name=\"value\" type=\"xs:string\" />\r\n    </xs:complexType>\r\n\r\n    <xs:complexType name=\"resource\">\r\n        <xs:sequence>\r\n            <xs:element name=\"property\" type=\"property\" minOccurs=\"0\" maxOccurs=\"unbounded\" />\r\n        </xs:sequence>\r\n        <xs:attribute name=\"name\" type=\"xs:string\" use=\"required\" />\r\n    </xs:complexType>\r\n\r\n    <xs:element name=\"resources\">\r\n        <xs:complexType>\r\n            <xs:sequence>\r\n                <xs:element name=\"resource\" type=\"resource\" minOccurs=\"0\" maxOccurs=\"unbounded\" />\r\n            </xs:sequence>\r\n        </xs:complexType>\r\n    </xs:element>\r\n</xs:schema>";
        XMLSchemaCompletionExtensionsTest.updateFile(xsdPath, schema);
        XMLAssert.testCompletionFor(xmlLanguageService, xml, null, null, "target/resources.xml", (Integer)4, false, new CompletionItem[0]);
    }

    @Test
    public void issue214() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<edmx:Edmx xmlns:edmx=\"http://docs.oasis-open.org/odata/ns/edmx\" xmlns=\"http://docs.oasis-open.org/odata/ns/edm\" Version=\"4.0\">\r\n  <edmx:Reference Uri=\"https://oasis-tcs.github.io/odata-vocabularies/vocabularies/Org.OData.Core.V1.xml\">\r\n    <edmx:Include Namespace=\"Org.OData.Core.V1\" Alias=\"Core\">\r\n      <Annotation Term=\"Core.DefaultNamespace\" />      \r\n    </edmx:Include>\r\n |";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("Annotation", "<Annotation Term=\"\"></Annotation>"), XMLAssert.c("edmx:Include", "<edmx:Include Namespace=\"\"></edmx:Include>"), XMLAssert.c("edmx:IncludeAnnotations", "<edmx:IncludeAnnotations TermNamespace=\"\" />"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<edmx:Edmx xmlns:edmx=\"http://docs.oasis-open.org/odata/ns/edmx\" xmlns=\"http://docs.oasis-open.org/odata/ns/edm\" Version=\"4.0\">   \r\n  <edmx:DataServices>\r\n    <Schema Namespace=\"ODataDemo\">\r\n |";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("Action", "<Action Name=\"\"></Action>"), XMLAssert.c("Annotation", "<Annotation Term=\"\"></Annotation>"), XMLAssert.c("Annotations", "<Annotations Target=\"\"></Annotations>"), XMLAssert.c("ComplexType", "<ComplexType Name=\"\"></ComplexType>"));
    }

    @Test
    public void issue214WithMarkdown() throws BadLocationException, URI.MalformedURIException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<edmx:Edmx xmlns:edmx=\"http://docs.oasis-open.org/odata/ns/edmx\" xmlns=\"http://docs.oasis-open.org/odata/ns/edm\" Version=\"4.0\">\r\n  <edmx:Reference Uri=\"https://oasis-tcs.github.io/odata-vocabularies/vocabularies/Org.OData.Core.V1.xml\">\r\n    <edmx:Include Namespace=\"Org.OData.Core.V1\" Alias=\"Core\">\r\n      <Annotation Term=\"Core.DefaultNamespace\" />      \r\n    </edmx:Include>\r\n |";
        this.testCompletionMarkdownSupportFor(xml, XMLAssert.c("Annotation", XMLAssert.te(6, 1, 6, 1, "<Annotation Term=\"\"></Annotation>"), "Annotation", null, null), XMLAssert.c("edmx:Include", XMLAssert.te(6, 1, 6, 1, "<edmx:Include Namespace=\"\"></edmx:Include>"), "edmx:Include", null, null), XMLAssert.c("edmx:IncludeAnnotations", "<edmx:IncludeAnnotations TermNamespace=\"\" />"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<edmx:Edmx xmlns:edmx=\"http://docs.oasis-open.org/odata/ns/edmx\" xmlns=\"http://docs.oasis-open.org/odata/ns/edm\" Version=\"4.0\">   \r\n  <edmx:DataServices>\r\n    <Schema Namespace=\"ODataDemo\">\r\n |";
        this.testCompletionMarkdownSupportFor(xml, XMLAssert.c("Action", "<Action Name=\"\"></Action>"), XMLAssert.c("Annotation", "<Annotation Term=\"\"></Annotation>"), XMLAssert.c("Annotations", "<Annotations Target=\"\"></Annotations>"), XMLAssert.c("ComplexType", "<ComplexType Name=\"\"></ComplexType>"));
    }

    @Test
    public void issue311() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<edmx:Edmx xmlns:edmx=\"http://docs.oasis-open.org/odata/ns/edmx\" xmlns:edm=\"http://docs.oasis-open.org/odata/ns/edm\" Version=\"4.0\">\r\n  | \r\n</edmx:Edmx>";
        XMLAssert.testCompletionFor(xml, "src/test/resources/catalogs/catalog.xml", "test.xsd", 6, XMLAssert.c("edmx:DataServices", "<edmx:DataServices></edmx:DataServices>"), XMLAssert.c("edmx:Reference", "<edmx:Reference Uri=\"\"></edmx:Reference>"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<edmx:Edmx xmlns:edmx=\"http://docs.oasis-open.org/odata/ns/edmx\" xmlns=\"http://docs.oasis-open.org/odata/ns/edm\" Version=\"4.0\">\r\n  | \r\n</edmx:Edmx>";
        XMLAssert.testCompletionFor(xml, "src/test/resources/catalogs/catalog.xml", "test.xsd", 6, XMLAssert.c("edmx:DataServices", "<edmx:DataServices></edmx:DataServices>"), XMLAssert.c("edmx:Reference", "<edmx:Reference Uri=\"\"></edmx:Reference>"));
    }

    @Test
    public void xsiCompletionTestAllItems() throws BadLocationException {
        String xml = "<project\r\n    xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    |>\r\n</project>";
        XMLAssert.testCompletionFor(xml, 4, XMLAssert.c("xsi:nil", "xsi:nil=\"true\""), XMLAssert.c("xsi:type", "xsi:type=\"\""), XMLAssert.c("xsi:noNamespaceSchemaLocation", "xsi:noNamespaceSchemaLocation=\"\""), XMLAssert.c("xsi:schemaLocation", "xsi:schemaLocation=\"\""));
    }

    @Test
    public void xsiCompletionNonRootElement() throws BadLocationException {
        String xml = "<project\r\n    xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n  <modelVersion xs|></modelVersion>\r\n</project>";
        XMLAssert.testCompletionFor(xml, 2, XMLAssert.c("xsi:nil", "xsi:nil=\"true\""), XMLAssert.c("xsi:type", "xsi:type=\"\""));
    }

    @Test
    public void xsiCompletionNonRootElement2() throws BadLocationException {
        String xml = "<project\r\n    xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n  <modelVersion xsi:nil=\"\" |></modelVersion>\r\n</project>";
        XMLAssert.testCompletionFor(xml, 1, XMLAssert.c("xsi:type", "xsi:type=\"\""));
    }

    @Test
    public void xsiCompletionNotUsingXSIName() throws BadLocationException {
        String xml = "<project\r\n    xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n    xmlns:XXY=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    XXY:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" |>\r\n  <modelVersion></modelVersion>\r\n</project>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, 4, XMLAssert.c("child.project.url.inherit.append.path", "child.project.url.inherit.append.path=\"\""), XMLAssert.c("XXY:nil", "XXY:nil=\"true\""), XMLAssert.c("XXY:type", "XXY:type=\"\""), XMLAssert.c("XXY:noNamespaceSchemaLocation", "XXY:noNamespaceSchemaLocation=\"\""));
    }

    @Test
    public void xmlnsXSICompletion() throws BadLocationException {
        String xml = "<project\r\n    xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n    xsi:|>\r\n  <modelVersion></modelVersion>\r\n</project>";
        XMLAssert.testCompletionFor(xml, 1, XMLAssert.c("xmlns:xsi", "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\""));
    }

    @Test
    public void xmlnsXSIValueCompletion() throws BadLocationException {
        String xml = "<project\r\n    xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n    xmlns:xsi=|>\r\n  <modelVersion></modelVersion>\r\n</project>";
        XMLAssert.testCompletionFor(xml, 1, XMLAssert.c("http://www.w3.org/2001/XMLSchema-instance", "\"http://www.w3.org/2001/XMLSchema-instance\""));
    }

    @Test
    public void xsiCompletionSchemaLocationExists() throws BadLocationException {
        String xml = "<project\r\n    xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd\" |>\r\n  <modelVersion></modelVersion>\r\n</project>";
        XMLAssert.testCompletionFor(xml, 4, XMLAssert.c("xsi:nil", "xsi:nil=\"true\""), XMLAssert.c("xsi:type", "xsi:type=\"\""), XMLAssert.c("xsi:noNamespaceSchemaLocation", "xsi:noNamespaceSchemaLocation=\"\""));
    }

    @Test
    public void xsiCompletionNoNamespaceSchemaLocationExists() throws BadLocationException {
        String xml = "<project\r\n    xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:noNamespaceSchemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" |>\r\n  <modelVersion></modelVersion>\r\n</project>";
        XMLAssert.testCompletionFor(xml, 3, XMLAssert.c("xsi:nil", "xsi:nil=\"true\""), XMLAssert.c("xsi:type", "xsi:type=\"\""), XMLAssert.c("xsi:schemaLocation", "xsi:schemaLocation=\"\""));
    }

    @Test
    public void choice() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n <|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/choice.xml", null, XMLAssert.c("member", "<member></member>"), XMLAssert.c("employee", "<employee></employee>"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n <employee /> | ";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/choice.xml", null, XMLAssert.c("member", "<member></member>"), XMLAssert.c("employee", "<employee></employee>"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n <employee />\r\n <employee /> <| </person>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/choice.xml", 4, XMLAssert.c("employee", "<employee></employee>"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n <employee />\r\n <employee />\r\n <employee /> <| </person>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/choice.xml", 2, new CompletionItem[0]);
    }

    @Test
    public void sequence() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<data xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/sequence.xsd\">\r\n\t|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", null, XMLAssert.c("e1", "<e1></e1>"), XMLAssert.c("optional0", "<optional0></optional0>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<data xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/sequence.xsd\">\r\n\t<e1></e1> | ";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", null, XMLAssert.c("e2", "<e2></e2>"), XMLAssert.c("optional1", "<optional1></optional1>"), XMLAssert.c("optional11", "<optional11></optional11>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<data xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/sequence.xsd\">\r\n\t<e1></e1>|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", null, XMLAssert.c("e2", "<e2></e2>"), XMLAssert.c("optional1", "<optional1></optional1>"), XMLAssert.c("optional11", "<optional11></optional11>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<data xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/sequence.xsd\">\r\n\t<e1></e1><e2></e2>|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", null, XMLAssert.c("e3", "<e3></e3>"), XMLAssert.c("optional2", "<optional2></optional2>"), XMLAssert.c("optional22", "<optional22></optional22>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<data xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/sequence.xsd\">\r\n\t<e1></e1><e2></e2><e3 />|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", null, XMLAssert.c("optional3", "<optional3></optional3>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<data xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/sequence.xsd\">\r\n\t<e1></e1><e2></e2><e3 /><optional3></optional3>|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", null, XMLAssert.c("optional3", "<optional3></optional3>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<data xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/sequence.xsd\">\r\n\t<e1></e1><e2></e2><e3 /><optional3></optional3><optional3></optional3>|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 3, XMLAssert.c("End with '</data>'", "</data>"));
    }

    @Test
    public void xsAny() throws IOException, BadLocationException {
        Path dir = Paths.get("target/xsd/", new String[0]);
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            Files.createDirectory(dir, new FileAttribute[0]);
        }
        Files.deleteIfExists(Paths.get(dir.toString(), "any.xsd"));
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String schema = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n\ttargetNamespace=\"http://ui\">\r\n\t<xs:element name=\"textbox\"></xs:element>\r\n\t<xs:element name=\"page\">\r\n\t\t<xs:complexType>\r\n\t\t\t<xs:sequence>\t\t\t\t\r\n\t\t\t\t<xs:element name=\"title\" />\r\n\t\t\t\t<xs:any processContents=\"strict\" />\r\n\t\t\t</xs:sequence>\t\t\t\r\n\t\t</xs:complexType>\r\n\t</xs:element>\r\n</xs:schema>";
        Files.write(Paths.get("target/xsd/any.xsd", new String[0]), schema.getBytes(), new OpenOption[0]);
        String xml = "<ui:page xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ui=\"http://ui\" xsi:schemaLocation=\"http://ui xsd/any.xsd\" >\r\n\t|\t\r\n\t<a/></ui:page>";
        XMLAssert.testCompletionFor(xmlLanguageService, xml, null, null, "target/any.xml", (Integer)5, true, XMLAssert.c("title", "<title></title>"));
        xml = "<ui:page xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ui=\"http://ui\" xsi:schemaLocation=\"http://ui xsd/any.xsd\" >\r\n\t<title></title>\r\n\t|\t\r\n\t<a/></ui:page>";
        XMLAssert.testCompletionFor(xmlLanguageService, xml, null, null, "target/any.xml", (Integer)6, true, XMLAssert.c("ui:page", "<ui:page></ui:page>"), XMLAssert.c("ui:textbox", "<ui:textbox></ui:textbox>"));
        xml = "<ui:page xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ui=\"http://ui\" xsi:schemaLocation=\"http://ui xsd/any.xsd\" >\r\n\t<title></title>\r\n\t<ui:textbox></ui:textbox>\r\n\t|\t\r\n\t<a/></ui:page>";
        XMLAssert.testCompletionFor(xmlLanguageService, xml, null, null, "target/any.xml", (Integer)4, true, new CompletionItem[0]);
        schema = "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n\ttargetNamespace=\"http://ui\">\r\n\t<xs:element name=\"textbox\"></xs:element>\r\n\t<xs:element name=\"page\">\r\n\t\t<xs:complexType>\r\n\t\t\t<xs:sequence>\t\t\t\t\r\n\t\t\t\t<xs:element name=\"title\" />\r\n\t\t\t\t<xs:any processContents=\"lax\" />\r\n\t\t\t</xs:sequence>\t\t\t\r\n\t\t</xs:complexType>\r\n\t</xs:element>\r\n</xs:schema>";
        Files.write(Paths.get("target/xsd/any.xsd", new String[0]), schema.getBytes(), new OpenOption[0]);
        xml = "<ui:page xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ui=\"http://ui\" xsi:schemaLocation=\"http://ui xsd/any.xsd\" >\r\n\t|\t\r\n\t<a/></ui:page>";
        XMLAssert.testCompletionFor(xmlLanguageService, xml, null, null, "target/any.xml", (Integer)5, true, XMLAssert.c("title", "<title></title>"));
        xml = "<ui:page xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ui=\"http://ui\" xsi:schemaLocation=\"http://ui xsd/any.xsd\" >\r\n\t<title></title>\r\n\t|\t\r\n\t<a/></ui:page>";
        XMLAssert.testCompletionFor(xmlLanguageService, xml, null, null, "target/any.xml", (Integer)8, true, XMLAssert.c("title", "<title></title>"), XMLAssert.c("a", "<a/>"), XMLAssert.c("ui:page", "<ui:page></ui:page>"), XMLAssert.c("ui:textbox", "<ui:textbox></ui:textbox>"));
        xml = "<ui:page xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ui=\"http://ui\" xsi:schemaLocation=\"http://ui xsd/any.xsd\" >\r\n\t<title></title>\r\n\t<ui:textbox></ui:textbox>\r\n\t|\t\r\n\t<a/></ui:page>";
        XMLAssert.testCompletionFor(xmlLanguageService, xml, null, null, "target/any.xml", (Integer)4, true, new CompletionItem[0]);
    }

    @Test
    public void xsAnySkip() throws BadLocationException {
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\r\n\t<modelVersion>4.0.0</modelVersion>\r\n\r\n\t<groupId>org.test</groupId>\r\n\t<artifactId>test</artifactId>\r\n\t<version>0.0.1-SNAPSHOT</version>\r\n\t<packaging>pom</packaging>\r\n\t\r\n\t<build>\r\n\t\t<plugins>\r\n\t\t\t<plugin>\r\n\t\t\t\t<groupId>org.apache.maven.plugins</groupId>\r\n\t\t\t\t<artifactId>maven-dependency-plugin</artifactId>\r\n\t\t\t\t<version>3.1.1</version>\r\n\t\t\t\t<executions>\r\n\t\t\t\t\t<execution>\r\n\t\t\t\t\t\t<goals><goal>list</goal></goals>\r\n\t\t\t\t\t\t<configuration>\r\n\t\t\t\t\t\t\t<|>\r\n\t\t\t\t\t\t</configuration>\r\n\t\t\t\t\t</execution>\r\n\t\t\t\t</executions>\r\n\t\t\t</plugin>\r\n\t\t</plugins>\r\n\t</build>\r\n</project>";
        XMLAssert.testCompletionFor(xml, "src/test/resources/catalogs/catalog.xml", null, 3, XMLAssert.c("project", XMLAssert.te(20, 7, 20, 9, "<project></project>"), "<project"));
    }

    @Test
    public void xsAnyDuplicate() throws IOException, BadLocationException {
        String xml = "<Page loaded=\"pageLoaded\" class=\"page\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/tns.xsd\" >\r\n\r\n | ";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/tns.xml", null, XMLAssert.c("Page", XMLAssert.te(2, 1, 2, 1, "<Page></Page>"), "Page", null, null), XMLAssert.c("AbsoluteLayout", XMLAssert.te(2, 1, 2, 1, "<AbsoluteLayout></AbsoluteLayout>"), "AbsoluteLayout", null, null), XMLAssert.c("DockLayout", XMLAssert.te(2, 1, 2, 1, "<DockLayout></DockLayout>"), "DockLayout", null, null));
    }

    @Test
    public void substitutionGroup() throws BadLocationException {
        String xml = "<fleet xmlns=\"http://example/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://example/ xsd/substitutionGroup.xsd\">\r\n\t   | ";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/substitutionGroup.xml", null, XMLAssert.c("truck", "<truck />"), XMLAssert.c("automobile", "<automobile />"));
    }

    @Test
    public void tag() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 6, XMLAssert.c("tag", "<tag></tag>"), XMLAssert.c("End with '</root>'", "</root>"), XMLAssert.c("#region", "<!-- #region -->"), XMLAssert.c("#endregion", "<!-- #endregion-->"), XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>"), XMLAssert.c("<!--", "<!-- -->"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t|\r\n</root>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 5, XMLAssert.c("tag", "<tag></tag>"), XMLAssert.c("#region", "<!-- #region -->"), XMLAssert.c("#endregion", "<!-- #endregion-->"), XMLAssert.c("<![CDATA[", "<![CDATA[ ]]>"), XMLAssert.c("<!--", "<!-- -->"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 4, XMLAssert.c("tag", "<tag></tag>"), XMLAssert.c("End with '</root>'", "</root>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<|\r\n</root>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 3, XMLAssert.c("tag", "<tag></tag>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<tag />|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 4, XMLAssert.c("optional", "<optional></optional>"), XMLAssert.c("End with '</root>'", "</root>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<tag />|\r\n</root>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 3, XMLAssert.c("optional", "<optional></optional>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<tag /><|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 4, XMLAssert.c("optional", "<optional></optional>"), XMLAssert.c("End with '</root>'", "/root>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<tag /><|\r\n</root>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 3, XMLAssert.c("optional", "<optional></optional>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<tag />\r\n|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 6, XMLAssert.c("optional", "<optional></optional>"), XMLAssert.c("End with '</root>'", "</root>"), XMLAssert.c("#region", "<!-- #region -->"), XMLAssert.c("#endregion", "<!-- #endregion-->"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<tag />\r\n|r\n</root>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 5, XMLAssert.c("optional", "<optional></optional>"), XMLAssert.c("#region", "<!-- #region -->"), XMLAssert.c("#endregion", "<!-- #endregion-->"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<tag />\r\n<|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 4, XMLAssert.c("optional", "<optional></optional>"), XMLAssert.c("End with '</root>'", "/root>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<tag />\r\n<|\r\n</root>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 3, XMLAssert.c("optional", "<optional></optional>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<tag />\r\n\t<optional />\r\n|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 6, XMLAssert.c("optional", "<optional></optional>"), XMLAssert.c("End with '</root>'", "</root>"), XMLAssert.c("#region", "<!-- #region -->"), XMLAssert.c("#endregion", "<!-- #endregion-->"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<tag />\r\n\t<optional />\r\n<|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 4, XMLAssert.c("optional", "<optional></optional>"), XMLAssert.c("End with '</root>'", "/root>"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<tag />\r\n\t<optional />\r\n\t<optional />\r\n|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 5, XMLAssert.c("End with '</root>'", "</root>"), XMLAssert.c("#region", "<!-- #region -->"), XMLAssert.c("#endregion", "<!-- #endregion-->"));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:noNamespaceSchemaLocation=\"xsd/tag.xsd\">\r\n\t<tag />\r\n\t<optional />\r\n\t<optional />\r\n<|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/sequence.xml", 3, XMLAssert.c("End with '</root>'", "/root>"));
    }

    @Test
    public void generateOnlyStartElementOnText() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n|</employee>";
        this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", 2, XMLAssert.c("member", XMLAssert.te(2, 0, 2, 0, "<member>$1</member>$0"), "member"), XMLAssert.c("employee", XMLAssert.te(2, 0, 2, 0, "<employee>$1$0"), "employee"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\nem|</employee>";
        this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", 2, XMLAssert.c("member", XMLAssert.te(2, 0, 2, 2, "<member>$1</member>$0"), "member"), XMLAssert.c("employee", XMLAssert.te(2, 0, 2, 2, "<employee>$1$0"), "employee"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<employee>|</employee>";
        this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", 3, XMLAssert.c("person", XMLAssert.te(2, 10, 2, 10, "<person>$1</person>$0"), "person"), XMLAssert.c("member", XMLAssert.te(2, 10, 2, 10, "<member>$1</member>$0"), "member"), XMLAssert.c("employee", XMLAssert.te(2, 10, 2, 10, "<employee>$1</employee>$0"), "employee"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<employee> |</employee>";
        this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", 3, XMLAssert.c("person", XMLAssert.te(2, 11, 2, 11, "<person>$1</person>$0"), "person"), XMLAssert.c("member", XMLAssert.te(2, 11, 2, 11, "<member>$1</member>$0"), "member"), XMLAssert.c("employee", XMLAssert.te(2, 11, 2, 11, "<employee>$1</employee>$0"), "employee"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<employee>| </employee>";
        this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", 3, XMLAssert.c("person", XMLAssert.te(2, 10, 2, 10, "<person>$1</person>$0"), "person"), XMLAssert.c("member", XMLAssert.te(2, 10, 2, 10, "<member>$1</member>$0"), "member"), XMLAssert.c("employee", XMLAssert.te(2, 10, 2, 10, "<employee>$1</employee>$0"), "employee"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<employee> | </employee>";
        this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", 3, XMLAssert.c("person", XMLAssert.te(2, 11, 2, 11, "<person>$1</person>$0"), "person"), XMLAssert.c("member", XMLAssert.te(2, 11, 2, 11, "<member>$1</member>$0"), "member"), XMLAssert.c("employee", XMLAssert.te(2, 11, 2, 11, "<employee>$1</employee>$0"), "employee"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<employee> | </employee></employee>";
        this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", 3, XMLAssert.c("person", XMLAssert.te(2, 11, 2, 11, "<person>$1</person>$0"), "person"), XMLAssert.c("member", XMLAssert.te(2, 11, 2, 11, "<member>$1</member>$0"), "member"), XMLAssert.c("employee", XMLAssert.te(2, 11, 2, 11, "<employee>$1</employee>$0"), "employee"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<employee></employee>\r\n|</employee>";
        this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", null, XMLAssert.c("member", XMLAssert.te(3, 0, 3, 0, "<member>$1</member>$0"), "member"), XMLAssert.c("employee", XMLAssert.te(3, 0, 3, 0, "<employee>$1$0"), "employee"));
    }

    @Test
    public void completionWithUnqualifiedElementFormDefault() throws BadLocationException {
        String xml = "<f:foo xmlns:f=\"http://foo\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"\r\n\t\thttp://foo xsd/foo-unqualified.xsd\">\r\n\t<bar>\r\n\t\t|";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/foo-unqualified.xml", null, XMLAssert.c("item", XMLAssert.te(5, 2, 5, 2, "<item></item>"), "item", null, null));
    }

    @Test
    public void completionWithUnqualifiedElementFormDefaultWithCatalog() throws BadLocationException {
        String xml = "<f:foo xmlns:f=\"http://foo\">\r\n\t<bar>\r\n\t\t|";
        XMLAssert.testCompletionFor(xml, "src/test/resources/catalogs/catalog.xml", "src/test/resources/foo-unqualified.xml", null, XMLAssert.c("item", XMLAssert.te(2, 2, 2, 2, "<item></item>"), "item", null, null));
    }

    @Test
    public void generateOnlyStartElementOnElement() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<|</employee>";
        this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", 2, XMLAssert.c("member", XMLAssert.te(2, 0, 2, 1, "<member>$1</member>$0"), "<member"), XMLAssert.c("employee", XMLAssert.te(2, 0, 2, 1, "<employee>$1$0"), "<employee"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<em|</employee>";
        this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", 2, XMLAssert.c("member", XMLAssert.te(2, 0, 2, 3, "<member>$1</member>$0"), "<member"), XMLAssert.c("employee", XMLAssert.te(2, 0, 2, 3, "<employee>$1$0"), "<employee"));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<person xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"xsd/choice.xsd\">\r\n<employee|></employee>";
        this.testCompletionSnippetSupportFor(xml, "src/test/resources/choice.xml", 2, XMLAssert.c("member", XMLAssert.te(2, 0, 2, 10, "<member>$1</member>$0"), "<member"), XMLAssert.c("employee", XMLAssert.te(2, 0, 2, 10, "<employee>$1$0"), "<employee"));
    }

    @Test
    public void documentationAsPlainText() throws BadLocationException {
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n\t<|</project>";
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, XMLAssert.c("groupId", XMLAssert.te(3, 1, 3, 2, "<groupId></groupId>"), "<groupId", "3.0.0+" + System.lineSeparator() + System.lineSeparator() + "A universally unique identifier for a project. It is normal to use a fully-qualified package name to distinguish it from other projects with a similar name (eg. org.apache.maven)." + System.lineSeparator() + System.lineSeparator() + "Source: maven-4.0.0.xsd", "plaintext"));
    }

    @Test
    public void documentationAsMarkdown() throws BadLocationException, URI.MalformedURIException {
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n\t<|</project>";
        String mavenFileURI = XMLSchemaCompletionExtensionsTest.getXMLSchemaFileURI("maven-4.0.0.xsd");
        this.testCompletionMarkdownSupportFor(xml, XMLAssert.c("groupId", XMLAssert.te(3, 1, 3, 2, "<groupId></groupId>"), "<groupId", "3.0.0+" + System.lineSeparator() + System.lineSeparator() + "A universally unique identifier for a project. It is normal to use a fully-qualified package name to distinguish it from other projects with a similar name (eg. `org.apache.maven`)." + System.lineSeparator() + System.lineSeparator() + "Source: [maven-4.0.0.xsd](" + mavenFileURI + ")", "markdown"));
    }

    private static String getXMLSchemaFileURI(String schemaURI) throws URI.MalformedURIException {
        return XMLEntityManager.expandSystemId((String)("xsd/" + schemaURI), (String)"src/test/resources/test.xml", (boolean)true).replace("///", "/");
    }

    private static void testCompletionWithCatalogFor(String xml, CompletionItem ... expectedItems) throws BadLocationException {
        XMLSchemaCompletionExtensionsTest.testCompletionWithCatalogFor(xml, null, expectedItems);
    }

    private static void testCompletionWithCatalogFor(String xml, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        XMLAssert.testCompletionFor(xml, "src/test/resources/catalogs/catalog.xml", null, expectedCount, expectedItems);
    }

    private void testCompletionMarkdownSupportFor(String xml, CompletionItem ... expectedItems) throws BadLocationException {
        CompletionCapabilities completionCapabilities = new CompletionCapabilities();
        CompletionItemCapabilities completionItem = new CompletionItemCapabilities(Boolean.valueOf(false));
        completionItem.setDocumentationFormat(Arrays.asList("markdown"));
        completionCapabilities.setCompletionItem(completionItem);
        SharedSettings sharedSettings = new SharedSettings();
        sharedSettings.getCompletionSettings().setCapabilities(completionCapabilities);
        XMLAssert.testCompletionFor(new XMLLanguageService(), xml, "src/test/resources/catalogs/catalog.xml", null, null, null, sharedSettings, expectedItems);
    }

    private void testCompletionSnippetSupportFor(String xml, String fileURI, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        CompletionCapabilities completionCapabilities = new CompletionCapabilities();
        CompletionItemCapabilities completionItem = new CompletionItemCapabilities(Boolean.valueOf(true));
        completionItem.setDocumentationFormat(Arrays.asList("markdown"));
        completionCapabilities.setCompletionItem(completionItem);
        SharedSettings sharedSettings = new SharedSettings();
        sharedSettings.getCompletionSettings().setCapabilities(completionCapabilities);
        XMLAssert.testCompletionFor(new XMLLanguageService(), xml, null, null, fileURI, null, sharedSettings, expectedItems);
    }

    @Test
    public void customProtocolNamespaceSchemaLocationCompletionWhenCachingOn() throws BadLocationException {
        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if ("custom".equals(protocol)) {
                    return new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) throws IOException {
                            return XMLSchemaCompletionExtensionsTest.class.getResource(u.getPath()).openConnection();
                        }
                    };
                }
                return null;
            }
        });
        Consumer<XMLLanguageService> config = service -> {
            ContentModelManager contentModelManager = (ContentModelManager)service.getComponent(ContentModelManager.class);
            contentModelManager.setUseCache(true);
            service.getResolverExtensionManager().registerResolver(new URIResolverExtension(){

                public String resolve(String baseLocation, String publicId, String systemId) {
                    if ("test://schema/format".equals(publicId)) {
                        return "custom://test/xsd/Format.xsd";
                    }
                    return null;
                }
            });
        };
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<Configuration xmlns=\"test://schema/format\">\r\n  <ViewDefinitions>\r\n    <View><|";
        XMLAssert.testCompletionFor(new XMLLanguageService(), xml, (String)null, config, "src/test/resources/Format.xml", (Integer)6, true, XMLAssert.c("Name", "<Name></Name>"), XMLAssert.c("End with '</Configuration>'", "/Configuration>"), XMLAssert.c("End with '</ViewDefinitions>'", "/ViewDefinitions>"), XMLAssert.c("End with '</View>'", "/View>"));
    }

    @Test
    public void completionWithCatalogAndXSDInclude() throws BadLocationException {
        String xml = "<document xmlns=\"http://foobar.com/test\">\r\n\t|\r\n</document>";
        XMLAssert.testCompletionFor(xml, "src/test/resources/catalogs/include/catalog-include.xml", "src/test/resources/test.xml", null, XMLAssert.c("page", XMLAssert.te(1, 1, 1, 1, "<page></page>"), "page", null, null));
    }

    @Test
    public void completionWithPrefixAttributeName() throws BadLocationException {
        String xml = "<sample xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txmlns:test=\"test-attrs\" xsi:noNamespaceSchemaLocation=\"xsd/attr-prefix/sample.xsd\"\r\n\t| />";
        XMLAssert.testCompletionFor(xml, "src/test/resources/catalogs/include/catalog-include.xml", "src/test/resources/test.xml", null, XMLAssert.c("test:label", XMLAssert.te(2, 1, 2, 1, "test:label=\"\""), "test:label", null, null));
    }

    @Test
    public void completionWithCatalogAndWebApp() throws BadLocationException {
        String xml = "<web-app xmlns=\"http://java.sun.com/xml/ns/j2ee\"\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\"\r\n    version=\"2.4\">\r\n    |\r\n</web-app>";
        XMLAssert.testCompletionFor(xml, "src/test/resources/catalogs/catalog-web-app.xml", "web.xml", 31, XMLAssert.c("servlet", XMLAssert.te(4, 4, 4, 4, "<servlet></servlet>"), "servlet", null, null));
    }
}

