/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd;

import java.util.concurrent.TimeUnit;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.ExternalResourceErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.DownloadDisabledResourceCodeAction;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.junit.jupiter.api.Test;

public class XSDValidationExternalResourcesTest {
    @Test
    public void includeSchemaLocationDownloadDisabled() throws Exception {
        XMLValidationSettings validation = new XMLValidationSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        ls.initializeIfNeeded();
        ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
        contentModelManager.setDownloadExternalResources(false);
        String xsd = "<xs:schema\r\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n    elementFormDefault=\"qualified\">\r\n    <xs:include schemaLocation=\"http://server:8080/sequence.xsd\" />\r\n</xs:schema>";
        String fileURI = "test.xsd";
        Diagnostic d = new Diagnostic(XMLAssert.r(3, 32, 3, 63), "Downloading external resources is disabled.", DiagnosticSeverity.Error, "xsd", ExternalResourceErrorCode.DownloadResourceDisabled.getCode());
        XMLAssert.testPublishDiagnosticsFor(xsd, fileURI, validation, ls, XMLAssert.pd(fileURI, d));
        XMLAssert.testCodeActionsFor(xsd, fileURI, d, XMLAssert.ca(d, DownloadDisabledResourceCodeAction.createDownloadCommand((String)"Force download of 'http://server:8080/sequence.xsd'.", (String)"http://server:8080/sequence.xsd", (String)fileURI)));
    }

    @Test
    public void includeSchemaLocationDownloadProblem() throws Exception {
        XMLValidationSettings validation = new XMLValidationSettings();
        validation.setResolveExternalEntities(true);
        XMLLanguageService ls = new XMLLanguageService();
        String xsd = "<xs:schema\r\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n    elementFormDefault=\"qualified\">\r\n    <xs:include schemaLocation=\"http://server:8080/sequence.xsd\" />\r\n</xs:schema>";
        String xsdCachePath = CacheResourcesManager.getResourceCachePath((String)"http://server:8080/sequence.xsd").toString();
        String fileURI = "test.xsd";
        XMLAssert.testPublishDiagnosticsFor(xsd, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(3, 32, 3, 63), "The resource 'http://server:8080/sequence.xsd' is downloading in the cache path '" + xsdCachePath + "'.", DiagnosticSeverity.Information, "xsd", ExternalResourceErrorCode.DownloadingResource.getCode())));
        TimeUnit.SECONDS.sleep(5L);
        XMLAssert.testPublishDiagnosticsFor(xsd, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(3, 32, 3, 63), "Error while downloading 'http://server:8080/sequence.xsd' to '" + xsdCachePath + "'.", DiagnosticSeverity.Error, "xsd", ExternalResourceErrorCode.DownloadProblem.getCode())));
    }

    public static void testDiagnosticsFor(String xml, String fileURI, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, null, null, fileURI, true, expected);
    }

    public static void testDiagnosticsFor(String xml, String fileURI, ContentModelSettings settings, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(xml, null, null, fileURI, true, settings, expected);
    }

    public static void testDiagnosticsFor(XMLLanguageService ls, String xml, String fileURI, ContentModelSettings settings, Diagnostic ... expected) {
        XMLAssert.testDiagnosticsFor(ls, xml, null, null, fileURI, true, settings, expected);
    }
}

