/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.CMRelaxNGAttributeDeclaration;
import com.thaiopensource.relaxng.pattern.CMRelaxNGElementDeclaration;
import com.thaiopensource.relaxng.pattern.CMRelaxNGElementDeclarationCollector;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.FilesChangedTracker;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.URIUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.xml.sax.Locator;

public class CMRelaxNGDocument
implements CMDocument {
    private static final String NAME_ATTR = "name";
    private static final String DOCUMENTATION_ELT = "documentation";
    private static final String CHOICE_ELT = "choice";
    private static final String VALUE_ELT = "value";
    private Collection<CMElementDeclaration> elements;
    private final Pattern start;
    private final URIResolverExtensionManager resolverExtensionManager;
    private final FilesChangedTracker tracker;
    private final Map<String, DOMDocument> documents;
    private final Map<ElementPattern, CMRelaxNGElementDeclaration> elementMappings;

    public CMRelaxNGDocument(String relaxNGURI, Pattern start, URIResolverExtensionManager resolverExtensionManager) {
        this.start = start;
        this.resolverExtensionManager = resolverExtensionManager;
        if (URIUtils.isFileResource(relaxNGURI)) {
            this.tracker = new FilesChangedTracker();
            this.tracker.addFileURI(relaxNGURI);
        } else {
            this.tracker = null;
        }
        this.documents = new HashMap<String, DOMDocument>();
        this.elementMappings = new HashMap<ElementPattern, CMRelaxNGElementDeclaration>();
    }

    @Override
    public boolean hasNamespace(String namespaceURI) {
        return false;
    }

    @Override
    public Collection<CMElementDeclaration> getElements() {
        if (this.elements == null) {
            this.elements = new CMRelaxNGElementDeclarationCollector(this, this.start).getElements();
        }
        return this.elements;
    }

    CMRelaxNGElementDeclaration getPatternElement(ElementPattern elementDeclaration) {
        CMRelaxNGElementDeclaration element = this.elementMappings.get(elementDeclaration);
        if (element == null) {
            element = new CMRelaxNGElementDeclaration(this, elementDeclaration);
            this.elementMappings.put(elementDeclaration, element);
        }
        return element;
    }

    @Override
    public CMElementDeclaration findCMElement(DOMElement element, String namespace) {
        ArrayList<DOMElement> paths = new ArrayList<DOMElement>();
        while (element != null && (namespace == null || namespace.equals(element.getNamespaceURI()))) {
            paths.add(0, element);
            element = element.getParentNode() instanceof DOMElement ? (DOMElement)element.getParentNode() : null;
        }
        CMElementDeclaration declaration = null;
        for (int i = 0; i < paths.size(); ++i) {
            DOMElement elt = (DOMElement)paths.get(i);
            if (i == 0) {
                declaration = this.findElementDeclaration(elt.getLocalName(), namespace);
            } else {
                CMElementDeclaration cMElementDeclaration = declaration = declaration != null ? declaration.findCMElement(elt.getLocalName(), namespace) : null;
            }
            if (declaration == null) break;
        }
        return declaration;
    }

    private CMElementDeclaration findElementDeclaration(String tag, String namespace) {
        for (CMElementDeclaration cmElement : this.getElements()) {
            if (!cmElement.getLocalName().equals(tag)) continue;
            return cmElement;
        }
        return null;
    }

    @Override
    public LocationLink findTypeLocation(DOMNode originNode) {
        DOMRange range;
        Locator locator;
        DOMElement originElement = null;
        DOMAttr originAttribute = null;
        if (originNode.isElement()) {
            originElement = (DOMElement)originNode;
        } else if (originNode.isAttribute()) {
            originAttribute = (DOMAttr)originNode;
            originElement = originAttribute.getOwnerElement();
        }
        if (originElement == null || originElement.getLocalName() == null) {
            return null;
        }
        CMRelaxNGElementDeclaration elementDeclaration = (CMRelaxNGElementDeclaration)this.findCMElement(originElement, originElement.getNamespaceURI());
        if (elementDeclaration == null) {
            return null;
        }
        CMRelaxNGAttributeDeclaration attributeDeclaration = null;
        if (originAttribute != null && (attributeDeclaration = (CMRelaxNGAttributeDeclaration)elementDeclaration.findCMAttribute(originAttribute)) == null) {
            return null;
        }
        Locator locator2 = locator = attributeDeclaration != null ? attributeDeclaration.getPattern().getLocator() : elementDeclaration.getPattern().getLocator();
        if (locator == null) {
            return null;
        }
        String systemId = locator.getSystemId();
        if (!URIUtils.isFileResource(systemId)) {
            return null;
        }
        DOMRange dOMRange = range = DOMUtils.isRelaxNGCompactSyntax(systemId) ? null : this.getDeclaredTypeRange(originNode, locator);
        if (range != null) {
            return XMLPositionUtility.createLocationLink(originNode, range);
        }
        Range originRange = XMLPositionUtility.createSelectionRange(originNode);
        Range targetRange = new Range(CMRelaxNGDocument.createValidPosition(locator.getLineNumber() - 1, locator.getColumnNumber() - 1), CMRelaxNGDocument.createValidPosition(locator.getLineNumber() - 1, locator.getColumnNumber()));
        return new LocationLink(systemId, targetRange, targetRange, originRange);
    }

    private static Position createValidPosition(int line, int character) {
        return new Position(Math.max(line, 0), Math.max(character, 0));
    }

    private DOMRange getDeclaredTypeRange(DOMNode originNode, Locator locator) {
        DOMElement element;
        DOMAttr name;
        DOMNode node = this.findNode(locator);
        if (node == null) {
            return null;
        }
        if (node.isElement() && (name = (element = (DOMElement)node).getAttributeNode(NAME_ATTR)) != null && originNode.getLocalName().equals(name.getValue())) {
            return name;
        }
        return null;
    }

    private DOMDocument getDocument(String systemId) {
        DOMDocument document = this.documents.get(systemId);
        if (document != null) {
            return document;
        }
        return this.getSynchDocument(systemId);
    }

    private synchronized DOMDocument getSynchDocument(String systemId) {
        DOMDocument document = this.documents.get(systemId);
        if (document != null) {
            return document;
        }
        document = DOMUtils.loadDocument(systemId, this.resolverExtensionManager);
        this.documents.put(systemId, document);
        return document;
    }

    @Override
    public boolean isDirty() {
        return this.tracker != null ? this.tracker.isDirty() : false;
    }

    public String getDocumentation(Locator locator) {
        return this.getDocumentation(locator, null);
    }

    public String getDocumentation(Locator locator, String value) {
        DOMNode node = this.findNode(locator);
        if (node == null) {
            return null;
        }
        if (node.isElement()) {
            DOMElement documentation = this.getDocumentationElement((DOMElement)node, value);
            if (documentation == null) {
                return null;
            }
            return CMRelaxNGDocument.getTextContent(documentation);
        }
        return null;
    }

    private DOMElement getDocumentationElement(DOMElement element, String value) {
        if (value == null) {
            return DOMUtils.findFirstChildElementByTagName(element, DOCUMENTATION_ELT);
        }
        DOMElement choice = DOMUtils.findFirstChildElementByTagName(element, CHOICE_ELT);
        if (choice == null) {
            return null;
        }
        int length = choice.getChildren().size();
        for (int i = 0; i < length; ++i) {
            DOMNode child = choice.getChild(i);
            if (!DOMUtils.isDOMElement(child, VALUE_ELT)) continue;
            DOMElement valueElement = (DOMElement)child;
            if (i >= length - 1 || !value.equals(CMRelaxNGDocument.getTextContent(valueElement))) continue;
            DOMNode next = choice.getChild(i + 1);
            if (DOMUtils.isDOMElement(next, DOCUMENTATION_ELT)) {
                return (DOMElement)next;
            }
            return null;
        }
        return null;
    }

    DOMNode findNode(Locator locator) {
        if (locator == null) {
            return null;
        }
        String systemId = locator.getSystemId();
        if (!URIUtils.isFileResource(systemId)) {
            return null;
        }
        DOMDocument targetSchema = this.getDocument(systemId);
        if (targetSchema == null) {
            return null;
        }
        try {
            int offset = targetSchema.offsetAt(new Position(locator.getLineNumber() - 1, locator.getColumnNumber() - 1));
            return targetSchema.findNodeAt(offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private static String getTextContent(DOMElement element) {
        int start = element.getStartTagCloseOffset() + 1;
        int end = element.getEndTagOpenOffset();
        return element.getOwnerDocument().getText().substring(start, end);
    }
}

