/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.customservice.AutoCloseTagResponse;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationRootSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.DocumentSymbolsResult;
import org.eclipse.lemminx.services.IXMLFullFormatter;
import org.eclipse.lemminx.services.SymbolInformationResult;
import org.eclipse.lemminx.services.XMLCodeActions;
import org.eclipse.lemminx.services.XMLCodeLens;
import org.eclipse.lemminx.services.XMLCompletions;
import org.eclipse.lemminx.services.XMLDefinition;
import org.eclipse.lemminx.services.XMLDiagnostics;
import org.eclipse.lemminx.services.XMLDocumentLink;
import org.eclipse.lemminx.services.XMLFoldings;
import org.eclipse.lemminx.services.XMLFormatter;
import org.eclipse.lemminx.services.XMLHighlighting;
import org.eclipse.lemminx.services.XMLHover;
import org.eclipse.lemminx.services.XMLLinkedEditing;
import org.eclipse.lemminx.services.XMLReference;
import org.eclipse.lemminx.services.XMLRename;
import org.eclipse.lemminx.services.XMLSelectionRanges;
import org.eclipse.lemminx.services.XMLSymbolsProvider;
import org.eclipse.lemminx.services.XMLTypeDefinition;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.diagnostics.DiagnosticsResult;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLCodeLensSettings;
import org.eclipse.lemminx.settings.XMLCompletionSettings;
import org.eclipse.lemminx.settings.XMLFoldingSettings;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XMLLanguageService
extends XMLExtensionsRegistry
implements IXMLFullFormatter {
    private static final CancelChecker NULL_CHECKER = new CancelChecker(){

        public void checkCanceled() {
        }
    };
    private final XMLFormatter formatter = new XMLFormatter(this);
    private final XMLHighlighting highlighting = new XMLHighlighting(this);
    private final XMLSymbolsProvider symbolsProvider = new XMLSymbolsProvider(this);
    private final XMLCompletions completions = new XMLCompletions(this);
    private final XMLHover hover = new XMLHover(this);
    private final XMLDiagnostics diagnostics = new XMLDiagnostics(this);
    private final XMLFoldings foldings = new XMLFoldings(this);
    private final XMLDocumentLink documentLink = new XMLDocumentLink(this);
    private final XMLDefinition definition = new XMLDefinition(this);
    private final XMLTypeDefinition typeDefinition = new XMLTypeDefinition(this);
    private final XMLReference reference = new XMLReference(this);
    private final XMLCodeLens codelens = new XMLCodeLens(this);
    private final XMLCodeActions codeActions = new XMLCodeActions(this);
    private final XMLRename rename = new XMLRename(this);
    private final XMLSelectionRanges selectionRanges = new XMLSelectionRanges();
    private final XMLLinkedEditing linkedEditing = new XMLLinkedEditing();

    @Override
    public String formatFull(String text, String uri, SharedSettings sharedSettings, CancelChecker cancelChecker) {
        DOMDocument xmlDocument = DOMParser.getInstance().parse(new TextDocument(text, uri), null);
        List<? extends TextEdit> edits = this.format(xmlDocument, null, sharedSettings);
        return edits.isEmpty() ? null : edits.get(0).getNewText();
    }

    public List<? extends TextEdit> format(DOMDocument xmlDocument, Range range, SharedSettings sharedSettings) {
        return this.formatter.format(xmlDocument, range, sharedSettings);
    }

    public List<DocumentHighlight> findDocumentHighlights(DOMDocument xmlDocument, Position position) {
        return this.findDocumentHighlights(xmlDocument, position, NULL_CHECKER);
    }

    public List<DocumentHighlight> findDocumentHighlights(DOMDocument xmlDocument, Position position, CancelChecker cancelChecker) {
        return this.highlighting.findDocumentHighlights(xmlDocument, position, cancelChecker);
    }

    public List<SymbolInformation> findSymbolInformations(DOMDocument xmlDocument, XMLSymbolSettings symbolSettings) {
        return this.findSymbolInformations(xmlDocument, symbolSettings, NULL_CHECKER);
    }

    public SymbolInformationResult findSymbolInformations(DOMDocument xmlDocument, XMLSymbolSettings symbolSettings, CancelChecker cancelChecker) {
        return this.symbolsProvider.findSymbolInformations(xmlDocument, symbolSettings, cancelChecker);
    }

    public List<DocumentSymbol> findDocumentSymbols(DOMDocument xmlDocument, XMLSymbolSettings symbolSettings) {
        return this.findDocumentSymbols(xmlDocument, symbolSettings, NULL_CHECKER);
    }

    public DocumentSymbolsResult findDocumentSymbols(DOMDocument xmlDocument, XMLSymbolSettings symbolSettings, CancelChecker cancelChecker) {
        return this.symbolsProvider.findDocumentSymbols(xmlDocument, symbolSettings, cancelChecker);
    }

    public CompletionList doComplete(DOMDocument xmlDocument, Position position, SharedSettings settings) {
        return this.doComplete(xmlDocument, position, settings, NULL_CHECKER);
    }

    public CompletionList doComplete(DOMDocument xmlDocument, Position position, SharedSettings settings, CancelChecker cancelChecker) {
        return this.completions.doComplete(xmlDocument, position, settings, cancelChecker);
    }

    public CompletionItem resolveCompletionItem(CompletionItem unresolved, DOMDocument xmlDocument, SharedSettings sharedSettings, CancelChecker cancelChecker) {
        return this.completions.resolveCompletionItem(unresolved, xmlDocument, sharedSettings, cancelChecker);
    }

    public Hover doHover(DOMDocument xmlDocument, Position position, SharedSettings sharedSettings) {
        return this.doHover(xmlDocument, position, sharedSettings, NULL_CHECKER);
    }

    public Hover doHover(DOMDocument xmlDocument, Position position, SharedSettings sharedSettings, CancelChecker cancelChecker) {
        return this.hover.doHover(xmlDocument, position, sharedSettings, cancelChecker);
    }

    public List<Diagnostic> doDiagnostics(DOMDocument xmlDocument, XMLValidationSettings validationSettings, Map<String, Object> validationArgs, CancelChecker cancelChecker) {
        return this.diagnostics.doDiagnostics(xmlDocument, validationSettings, validationArgs, cancelChecker);
    }

    public CompletableFuture<Path> publishDiagnostics(DOMDocument xmlDocument, Consumer<PublishDiagnosticsParams> publishDiagnostics, Consumer<TextDocument> triggerValidation, XMLValidationRootSettings validationSettings, Map<String, Object> validationArgs, CancelChecker cancelChecker) {
        String uri = xmlDocument.getDocumentURI();
        TextDocument document = xmlDocument.getTextDocument();
        XMLValidationSettings validationSettingsForUri = validationSettings != null ? validationSettings.getValidationSettings(xmlDocument.getDocumentURI()) : null;
        DiagnosticsResult diagnostics = (DiagnosticsResult)this.doDiagnostics(xmlDocument, validationSettingsForUri, validationArgs, cancelChecker);
        cancelChecker.checkCanceled();
        publishDiagnostics.accept(new PublishDiagnosticsParams(uri, (List)diagnostics));
        List<CompletableFuture<?>> futures = diagnostics.getFutures();
        if (!futures.isEmpty()) {
            CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
            ((CompletableFuture)allFutures.thenAccept(Void2 -> triggerValidation.accept(document))).exceptionally(downloadException -> {
                triggerValidation.accept(document);
                return null;
            });
        }
        return null;
    }

    public List<FoldingRange> getFoldingRanges(DOMDocument xmlDocument, XMLFoldingSettings context) {
        return this.getFoldingRanges(xmlDocument, context, NULL_CHECKER);
    }

    public List<FoldingRange> getFoldingRanges(DOMDocument xmlDocument, XMLFoldingSettings context, CancelChecker cancelChecker) {
        return this.foldings.getFoldingRanges(xmlDocument.getTextDocument(), context, cancelChecker);
    }

    public List<SelectionRange> getSelectionRanges(DOMDocument xmlDocument, List<Position> positions, CancelChecker cancelChecker) {
        return this.selectionRanges.getSelectionRanges(xmlDocument, positions, cancelChecker);
    }

    public WorkspaceEdit doRename(DOMDocument xmlDocument, Position position, String newText) {
        return this.rename.doRename(xmlDocument, position, newText);
    }

    public List<DocumentLink> findDocumentLinks(DOMDocument document) {
        return this.documentLink.findDocumentLinks(document);
    }

    public List<? extends LocationLink> findDefinition(DOMDocument xmlDocument, Position position, CancelChecker cancelChecker) {
        return this.definition.findDefinition(xmlDocument, position, cancelChecker);
    }

    public List<? extends LocationLink> findTypeDefinition(DOMDocument xmlDocument, Position position, CancelChecker cancelChecker) {
        return this.typeDefinition.findTypeDefinition(xmlDocument, position, cancelChecker);
    }

    public List<? extends Location> findReferences(DOMDocument xmlDocument, Position position, ReferenceContext context, CancelChecker cancelChecker) {
        return this.reference.findReferences(xmlDocument, position, context, cancelChecker);
    }

    public List<? extends CodeLens> getCodeLens(DOMDocument xmlDocument, XMLCodeLensSettings settings, CancelChecker cancelChecker) {
        return this.codelens.getCodelens(xmlDocument, settings, cancelChecker);
    }

    public List<CodeAction> doCodeActions(CodeActionContext context, Range range, DOMDocument document, SharedSettings sharedSettings, CancelChecker cancelChecker) {
        return this.codeActions.doCodeActions(context, range, document, sharedSettings, cancelChecker);
    }

    public CodeAction resolveCodeAction(CodeAction unresolved, DOMDocument document, SharedSettings sharedSettings, CancelChecker cancelChecker) {
        return this.codeActions.resolveCodeAction(unresolved, document, sharedSettings, cancelChecker);
    }

    public AutoCloseTagResponse doTagComplete(DOMDocument xmlDocument, XMLCompletionSettings completionSettings, Position position) {
        return this.doTagComplete(xmlDocument, position, completionSettings, NULL_CHECKER);
    }

    public AutoCloseTagResponse doTagComplete(DOMDocument xmlDocument, Position position, XMLCompletionSettings completionSettings, CancelChecker cancelChecker) {
        return this.completions.doTagComplete(xmlDocument, position, completionSettings, cancelChecker);
    }

    public AutoCloseTagResponse doAutoClose(DOMDocument xmlDocument, Position position, XMLCompletionSettings completionSettings, CancelChecker cancelChecker) {
        try {
            char c;
            int offset = xmlDocument.offsetAt(position);
            String text = xmlDocument.getText();
            if (offset > 0 && ((c = text.charAt(offset - 1)) == '>' || c == '/')) {
                return this.doTagComplete(xmlDocument, position, completionSettings, cancelChecker);
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public Position getMatchingTagPosition(DOMDocument xmlDocument, Position position, CancelChecker cancelChecker) {
        return XMLPositionUtility.getMatchingTagPosition(xmlDocument, position);
    }

    public LinkedEditingRanges findLinkedEditingRanges(DOMDocument xmlDocument, Position position, CancelChecker cancelChecker) {
        return this.linkedEditing.findLinkedEditingRanges(xmlDocument, position, cancelChecker);
    }
}

