/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterWithRangeTest {
    @Test
    public void range() throws BadLocationException {
        String content = "<div  class = \"foo\">\n  |<img  src = \"foo\"/>|\n </div>";
        String expected = "<div  class = \"foo\">\n  <img src=\"foo\" />\n </div>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, XMLAssert.te(1, 6, 1, 8, " "), XMLAssert.te(1, 11, 1, 12, ""), XMLAssert.te(1, 13, 1, 14, ""), XMLAssert.te(1, 19, 1, 19, " "));
        content = "<div  class = \"foo\">\n  |<img src=\"foo\" />|\n </div>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void range2() throws BadLocationException {
        String content = "<div  class = \"foo\">\n  |<img  src = \"foo\"/>|\n \n </div>";
        String expected = "<div  class = \"foo\">\n  <img src=\"foo\" />\n \n </div>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, XMLAssert.te(1, 6, 1, 8, " "), XMLAssert.te(1, 11, 1, 12, ""), XMLAssert.te(1, 13, 1, 14, ""), XMLAssert.te(1, 19, 1, 19, " "));
        content = "<div  class = \"foo\">\n  |<img src=\"foo\" />|\n \n </div>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void rangeChildrenFullSelection() throws BadLocationException {
        String content = "<licenses>\n  <license>\n    <name>License Name</name>\n|           <url>abcdefghijklmnop</url>\n            <distribution>repo</distribution>|\n  </license>\n</licenses>";
        String expected = "<licenses>\n  <license>\n    <name>License Name</name>\n    <url>abcdefghijklmnop</url>\n    <distribution>repo</distribution>\n  </license>\n</licenses>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, XMLAssert.te(2, 29, 3, 11, "\n    "), XMLAssert.te(3, 38, 4, 12, "\n    "));
        XMLFormatterWithRangeTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void rangeChildrenPartialSelection() throws BadLocationException {
        String content = "<licenses>\n  <license>\n  <name>Licen|se Name</name>\n              <url>abcdefghijklmnop</url>\n              <distribution>repo</distribution>|\n  </license>\n</licenses>";
        String expected = "<licenses>\n  <license>\n  <name>License Name</name>\n    <url>abcdefghijklmnop</url>\n    <distribution>repo</distribution>\n  </license>\n</licenses>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, XMLAssert.te(2, 27, 3, 14, "\n    "), XMLAssert.te(3, 41, 4, 14, "\n    "));
    }

    @Test
    public void rangeSelectAll() throws BadLocationException {
        String content = "<licenses>\n                                            <license>\n                        <name>License Name</name>\n        <url>abcdefghijklmnop</url>\n        <distribution>repo</distribution>\n                                        </license>\n                                                                </licenses>";
        String expected = "<licenses>\n  <license>\n    <name>License Name</name>\n    <url>abcdefghijklmnop</url>\n    <distribution>repo</distribution>\n  </license>\n</licenses>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, XMLAssert.te(0, 10, 1, 44, "\n  "), XMLAssert.te(1, 53, 2, 24, "\n    "), XMLAssert.te(2, 49, 3, 8, "\n    "), XMLAssert.te(3, 35, 4, 8, "\n    "), XMLAssert.te(4, 41, 5, 40, "\n  "), XMLAssert.te(5, 50, 6, 64, "\n"));
        XMLFormatterWithRangeTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void rangeSelectOnlyPartialStartTagAndChildren() throws BadLocationException {
        String content = "<licenses>\n                                 <lice|nse>\n                <name>License Name</name>\n                        <url>abcdefghijklmnop</url>\n            <distribution>repo</distribution>|\n  </license>\n</licenses>";
        String expected = "<licenses>\n  <license>\n    <name>License Name</name>\n    <url>abcdefghijklmnop</url>\n    <distribution>repo</distribution>\n  </license>\n</licenses>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, XMLAssert.te(0, 10, 1, 33, "\n  "), XMLAssert.te(1, 42, 2, 16, "\n    "), XMLAssert.te(2, 41, 3, 24, "\n    "), XMLAssert.te(3, 51, 4, 12, "\n    "));
        XMLFormatterWithRangeTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void rangeSelectOnlyFullStartTagAndChildren() throws BadLocationException {
        String content = "<licenses>\n                                 |<license>\n                <name>License Name</name>\n                        <url>abcdefghijklmnop</url>\n            <distribution>repo</distribution>|\n  </license>\n</licenses>";
        String expected = "<licenses>\n  <license>\n    <name>License Name</name>\n    <url>abcdefghijklmnop</url>\n    <distribution>repo</distribution>\n  </license>\n</licenses>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, XMLAssert.te(0, 10, 1, 33, "\n  "), XMLAssert.te(1, 42, 2, 16, "\n    "), XMLAssert.te(2, 41, 3, 24, "\n    "), XMLAssert.te(3, 51, 4, 12, "\n    "));
        XMLFormatterWithRangeTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void rangeSelectOnlyPartialEndTagAndChildren() throws BadLocationException {
        String content = "<licenses>\n  <license>\n                <nam|e>License Name</name>\n                        <url>abcdefghijklmnop</url>\n            <distribution>repo</distribution>\n  </licen|se>\n</licenses>";
        String expected = "<licenses>\n  <license>\n    <name>License Name</name>\n    <url>abcdefghijklmnop</url>\n    <distribution>repo</distribution>\n  </license>\n</licenses>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, XMLAssert.te(1, 11, 2, 16, "\n    "), XMLAssert.te(2, 41, 3, 24, "\n    "), XMLAssert.te(3, 51, 4, 12, "\n    "));
        XMLFormatterWithRangeTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void rangeSelectOnlyFullEndTagAndChildren() throws BadLocationException {
        String content = "<licenses>\n  <license>\n                <nam|e>License Name</name>\n                        <url>abcdefghijklmnop</url>\n            <distribution>repo</distribution>\n  </license>|\n</licenses>";
        String expected = "<licenses>\n  <license>\n    <name>License Name</name>\n    <url>abcdefghijklmnop</url>\n    <distribution>repo</distribution>\n  </license>\n</licenses>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, XMLAssert.te(1, 11, 2, 16, "\n    "), XMLAssert.te(2, 41, 3, 24, "\n    "), XMLAssert.te(3, 51, 4, 12, "\n    "));
        XMLFormatterWithRangeTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void rangeSelectWithinText() throws BadLocationException {
        String content = "<licenses>\n                <name>Lic|en|se</name>\n</licenses>";
        String expected = "<licenses>\n                <name>License</name>\n</licenses>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void rangeSelectEntityNoIndent() throws BadLocationException {
        String content = "<?xml version='1.0' standalone='no'?>\r\n<!DOCTYPE root-element [\r\n|<!ENTITY local \"LOCALLY DECLARED ENTITY\">|\r\n]>";
        String expected = "<?xml version='1.0' standalone='no'?>\r\n<!DOCTYPE root-element [\r\n<!ENTITY local \"LOCALLY DECLARED ENTITY\">\r\n]>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void rangeSelectEntityWithIndent() throws BadLocationException {
        String content = "<?xml version='1.0' standalone='no'?>\r\n<!DOCTYPE root-element [\r\n  |<!ENTITY local \"LOCALLY DECLARED ENTITY\">|\r\n]>";
        String expected = "<?xml version='1.0' standalone='no'?>\r\n<!DOCTYPE root-element [\r\n  <!ENTITY local \"LOCALLY DECLARED ENTITY\">\r\n]>";
        XMLFormatterWithRangeTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testSplitAttributesRangeOneLine() throws BadLocationException {
        String content = "<note>\r\n  <from\r\n      |foo     =           \"bar\"|\r\n      bar=\"foo\">sss</from>\r\n</note>";
        String expected = "<note>\r\n  <from\r\n      foo=\"bar\"\r\n      bar=\"foo\">sss</from>\r\n</note>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        XMLFormatterWithRangeTest.assertFormat(content, expected, settings, XMLAssert.te(2, 9, 2, 14, ""), XMLAssert.te(2, 15, 2, 26, ""));
    }

    @Test
    public void testSplitAttributesRangeMultipleLines() throws BadLocationException {
        String content = "<note>\r\n  <from\r\n        |foo       =       \"bar\"\r\nbar  =    \"foo\"   abc  =  \r\n    \"def\"\r\n      ghi=\"jkl\"|>sss</from>\r\n</note>";
        String expected = "<note>\r\n  <from\r\n      foo=\"bar\"\r\n      bar=\"foo\"\r\n      abc=\"def\"\r\n      ghi=\"jkl\">sss</from>\r\n</note>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setSplitAttributes(true);
        XMLFormatterWithRangeTest.assertFormat(content, expected, settings, XMLAssert.te(1, 7, 2, 8, "\r\n      "), XMLAssert.te(2, 11, 2, 18, ""), XMLAssert.te(2, 19, 2, 26, ""), XMLAssert.te(2, 31, 3, 0, "\r\n      "), XMLAssert.te(3, 3, 3, 5, ""), XMLAssert.te(3, 6, 3, 10, ""), XMLAssert.te(3, 15, 3, 18, "\r\n      "), XMLAssert.te(3, 21, 3, 23, ""), XMLAssert.te(3, 24, 4, 4, ""));
    }

    private static void assertFormat(String unformatted, String actual, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterWithRangeTest.assertFormat(unformatted, actual, new SharedSettings(), expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterWithRangeTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterWithRangeTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

