/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.LocationLink;
import org.junit.jupiter.api.Test;

public class RNGDefinitionExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void definitionOnRefName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\">\r\n    <start>\r\n        <element name=\"addressBook\">\r\n            <zeroOrMore>\r\n                <element name=\"card\">\r\n                    <ref name=\"cardCon|tent\"/>\r\n                </element>\r\n            </zeroOrMore>\r\n        </element>\r\n    </start>\r\n    <define name=\"cardContent\">\r\n        <element name=\"name\">\r\n            <text/>\r\n        </element>\r\n        <element name=\"email\">\r\n            <text/>\r\n        </element>\r\n    </define>\r\n</grammar>";
        RNGDefinitionExtensionsTest.testDefinitionFor(xml, XMLAssert.ll("test.rng", XMLAssert.r(6, 30, 6, 43), XMLAssert.r(11, 17, 11, 30)));
    }

    @Test
    public void definitionOnRefNameWithNestedDefine() throws BadLocationException {
        String xml = "<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\"\r\n  datatypeLibrary=\"http://www.w3.org/2001/XMLSchema-datatypes\">\r\n  <start>\r\n    <ref name=\"root-element\"/>\r\n  </start>\r\n  <define name=\"root-element\">\r\n      <element name=\"root-element\">\r\n        <ref name=\"as|df\"></ref>\r\n      </element>\r\n  </define>\r\n  <div>\r\n    <div>\r\n      <define name=\"asdf\">\r\n        <attribute name=\"child\"></attribute>\r\n      </define>\r\n    </div>\r\n  </div>\r\n</grammar>";
        RNGDefinitionExtensionsTest.testDefinitionFor(xml, XMLAssert.ll("test.rng", XMLAssert.r(7, 18, 7, 24), XMLAssert.r(12, 19, 12, 25)));
    }

    private static void testDefinitionFor(String xml, LocationLink ... expectedItems) throws BadLocationException {
        XMLAssert.testDefinitionFor(xml, "test.rng", expectedItems);
    }
}

