/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.nogrammarconstraints;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.nogrammarconstraints.NoGrammarConstraintsCodeAction;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NoGrammarConstraintsCodeActionTest
extends AbstractCacheBasedTest {
    private static final String TEST_DOCUMENT_URI = "file:///test.xml";
    private XMLLanguageService xmlLanguageService = new XMLLanguageService();
    private SharedSettings sharedSettings = new SharedSettings();

    @Test
    public void generateGrammarURI() {
        String actual = NoGrammarConstraintsCodeAction.getGrammarURI((String)"file:///C:/test.xml", (String)"xsd");
        Assertions.assertEquals((Object)"file:///C:/test.xsd", (Object)actual);
    }

    @Test
    public void generateGrammarURIWithDot() {
        String actual = NoGrammarConstraintsCodeAction.getGrammarURI((String)"file:///C:/.project", (String)"xsd");
        Assertions.assertEquals((Object)"file:///C:/.project.xsd", (Object)actual);
    }

    @Test
    public void testAssociateWithXmlModelCodeAction() throws BadLocationException {
        DOMDocument xmlDocument = this.getDOMDocument("");
        TextDocumentEdit actual = NoGrammarConstraintsCodeAction.createXmlModelEdit((String)"file:///my-schema.xsd", null, (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 0, 0, 0, "<?xml-model href=\"file:///my-schema.xsd\"?>" + System.lineSeparator()), XMLAssert.te(0, 0, 0, 0, "<root-element></root-element>")), actual);
        xmlDocument = this.getDOMDocument("");
        actual = NoGrammarConstraintsCodeAction.createXmlModelEdit((String)"file:///my-schema.xsd", (String)"https://google.ca", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 0, 0, 0, "<?xml-model href=\"file:///my-schema.xsd\"?>" + System.lineSeparator()), XMLAssert.te(0, 0, 0, 0, "<root-element xmlns=\"https://google.ca\"></root-element>")), actual);
        xmlDocument = this.getDOMDocument("<root></root>");
        actual = NoGrammarConstraintsCodeAction.createXmlModelEdit((String)"file:///my-schema.xsd", (String)"https://google.ca", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 0, 0, 0, "<?xml-model href=\"file:///my-schema.xsd\"?>" + System.lineSeparator()), XMLAssert.te(0, 5, 0, 5, " xmlns=\"https://google.ca\"")), actual);
        xmlDocument = this.getDOMDocument("<root hjkl=\"hjkl\"></root>");
        actual = NoGrammarConstraintsCodeAction.createXmlModelEdit((String)"file:///my-schema.xsd", (String)"https://google.ca", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 0, 0, 0, "<?xml-model href=\"file:///my-schema.xsd\"?>" + System.lineSeparator()), XMLAssert.te(0, 5, 0, 5, " xmlns=\"https://google.ca\"")), actual);
        xmlDocument = this.getDOMDocument("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        actual = NoGrammarConstraintsCodeAction.createXmlModelEdit((String)"file:///my-schema.xsd", (String)"https://google.ca", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 38, 0, 38, System.lineSeparator() + "<?xml-model href=\"file:///my-schema.xsd\"?>" + System.lineSeparator()), XMLAssert.te(0, 38, 0, 38, System.lineSeparator() + "<root-element xmlns=\"https://google.ca\"></root-element>")), actual);
    }

    @Test
    public void testAssociateWithDoctypeCodeAction() throws BadLocationException {
        DOMDocument xmlDocument = this.getDOMDocument("");
        TextDocumentEdit actual = NoGrammarConstraintsCodeAction.createDocTypeEdit((String)"file:///my-schema.dtd", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 0, 0, 0, "<!DOCTYPE root-element SYSTEM \"file:///my-schema.dtd\">" + System.lineSeparator() + "<root-element></root-element>")), actual);
        xmlDocument = this.getDOMDocument("<root></root>");
        actual = NoGrammarConstraintsCodeAction.createDocTypeEdit((String)"file:///my-schema.dtd", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 0, 0, 0, "<!DOCTYPE root SYSTEM \"file:///my-schema.dtd\">" + System.lineSeparator())), actual);
        xmlDocument = this.getDOMDocument("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        actual = NoGrammarConstraintsCodeAction.createDocTypeEdit((String)"file:///my-schema.dtd", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 38, 0, 38, System.lineSeparator() + "<!DOCTYPE root-element SYSTEM \"file:///my-schema.dtd\">" + System.lineSeparator() + "<root-element></root-element>")), actual);
    }

    @Test
    public void testAssociateWithNoNamespaceSchemaLocationCodeAction() throws BadLocationException {
        DOMDocument xmlDocument = this.getDOMDocument("");
        TextDocumentEdit actual = NoGrammarConstraintsCodeAction.createXSINoNamespaceSchemaLocationEdit((String)"file:///my-schema.dtd", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 0, 0, 0, "<root-element xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + " xsi:noNamespaceSchemaLocation=\"file:///my-schema.dtd\"></root-element>")), actual);
        xmlDocument = this.getDOMDocument("<root></root>");
        actual = NoGrammarConstraintsCodeAction.createXSINoNamespaceSchemaLocationEdit((String)"file:///my-schema.dtd", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 5, 0, 5, " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + " xsi:noNamespaceSchemaLocation=\"file:///my-schema.dtd\"")), actual);
        xmlDocument = this.getDOMDocument("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        actual = NoGrammarConstraintsCodeAction.createXSINoNamespaceSchemaLocationEdit((String)"file:///my-schema.dtd", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 38, 0, 38, System.lineSeparator() + "<root-element xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + " xsi:noNamespaceSchemaLocation=\"file:///my-schema.dtd\"></root-element>")), actual);
    }

    @Test
    public void testAssociateWithSchemaLocationCodeAction() throws BadLocationException {
        DOMDocument xmlDocument = this.getDOMDocument("");
        TextDocumentEdit actual = NoGrammarConstraintsCodeAction.createXSISchemaLocationEdit((String)"file:///my-schema.dtd", (String)"https://google.ca", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 0, 0, 0, "<root-element xmlns=\"https://google.ca\"" + System.lineSeparator() + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + " xsi:schemaLocation=\"https://google.ca file:///my-schema.dtd\"></root-element>")), actual);
        xmlDocument = this.getDOMDocument("<root></root>");
        actual = NoGrammarConstraintsCodeAction.createXSISchemaLocationEdit((String)"file:///my-schema.dtd", (String)"https://google.ca", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 5, 0, 5, " xmlns=\"https://google.ca\"" + System.lineSeparator() + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + " xsi:schemaLocation=\"https://google.ca file:///my-schema.dtd\"")), actual);
        xmlDocument = this.getDOMDocument("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        actual = NoGrammarConstraintsCodeAction.createXSISchemaLocationEdit((String)"file:///my-schema.dtd", (String)"https://google.ca", (DOMDocument)xmlDocument, (SharedSettings)this.sharedSettings);
        NoGrammarConstraintsCodeActionTest.assertTextDocumentEdit(NoGrammarConstraintsCodeActionTest.tde(XMLAssert.te(0, 38, 0, 38, System.lineSeparator() + "<root-element xmlns=\"https://google.ca\"" + System.lineSeparator() + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + System.lineSeparator() + " xsi:schemaLocation=\"https://google.ca file:///my-schema.dtd\"></root-element>")), actual);
    }

    private DOMDocument getDOMDocument(String xml) {
        TextDocument textDocument = new TextDocument(xml, TEST_DOCUMENT_URI);
        return DOMParser.getInstance().parse(textDocument, this.xmlLanguageService.getResolverExtensionManager());
    }

    private static TextDocumentEdit tde(TextEdit ... edits) {
        return XMLAssert.tde(TEST_DOCUMENT_URI, 0, edits);
    }

    private static void assertTextDocumentEdit(TextDocumentEdit expected, TextDocumentEdit actual) {
        Assertions.assertEquals((Object)expected.getTextDocument().getUri(), (Object)actual.getTextDocument().getUri());
        Assertions.assertEquals((int)expected.getEdits().size(), (int)actual.getEdits().size());
        for (int i = 0; i < expected.getEdits().size(); ++i) {
            Assertions.assertEquals(expected.getEdits().get(i), actual.getEdits().get(i));
        }
    }
}

