/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.diagnostics;

import java.util.function.Consumer;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLFileAssociation;
import org.eclipse.lemminx.extensions.relaxng.xml.validator.RelaxNGErrorCode;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class XMLFileAssociationRelaxNGCompactSyntaxDiagnosticsTest
extends AbstractCacheBasedTest {
    @Test
    public void valid() throws Exception {
        String xml = "<addressBook>\r\n  <card>\r\n    <name>John Smith</name>\r\n    <email>js@example.com</email>\r\n  </card>\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLFileAssociationRelaxNGCompactSyntaxDiagnosticsTest.testDiagnosticsFor(xml, new Diagnostic[0]);
    }

    @Test
    public void unkwown_element() throws Exception {
        String xml = "<addressBook>\r\n  <card>\r\n    <nameXXX>John Smith</nameXXX>\r\n    <email>js@example.com</email>\r\n  </card>\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLFileAssociationRelaxNGCompactSyntaxDiagnosticsTest.testDiagnosticsFor(xml, XMLAssert.d(2, 5, 12, (IXMLErrorCode)RelaxNGErrorCode.unknown_element), XMLAssert.d(3, 5, 10, (IXMLErrorCode)RelaxNGErrorCode.unexpected_element_required_element_missing));
    }

    private static void testDiagnosticsFor(String xml, Diagnostic ... expected) {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(XMLFileAssociationRelaxNGCompactSyntaxDiagnosticsTest.createXMLFileAssociation("src/test/resources/relaxng/"));
        };
        XMLAssert.testDiagnosticsFor(xml, null, configuration, "file:///test/addressBook.xml", expected);
    }

    private static XMLFileAssociation[] createXMLFileAssociation(String baseSystemId) {
        XMLFileAssociation addressBook = new XMLFileAssociation();
        addressBook.setPattern("**/addressBook.xml");
        addressBook.setSystemId(baseSystemId + "addressBook.rnc");
        return new XMLFileAssociation[]{addressBook};
    }
}

