/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class ContentModelManagerCacheTest
extends BaseFileTempTest {
    @Test
    public void testXSDCache() throws IOException, BadLocationException {
        String xsdPath = this.getTempDirPath().toString() + "/tag.xsd";
        String xmlPath = this.getTempDirPath().toString() + "/tag.xml";
        String xsd = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema\r\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n    elementFormDefault=\"qualified\">\r\n  <xs:element name=\"root\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element name=\"tag\"/>\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n</xs:schema>";
        ContentModelManagerCacheTest.createFile(xsdPath, xsd);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<root\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:noNamespaceSchemaLocation=\"tag.xsd\">\r\n  | </root>";
        XMLAssert.testCompletionFor(xml, null, xmlPath, 5, XMLAssert.c("tag", "<tag></tag>"));
        XMLAssert.testCompletionFor(xml, null, xmlPath, null, XMLAssert.c("tag", "<tag></tag>"));
        xsd = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<xs:schema\r\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n    elementFormDefault=\"qualified\">\r\n  <xs:element name=\"root\">\r\n    <xs:complexType>\r\n      <xs:sequence>\r\n        <xs:element name=\"label\"/>\r\n      </xs:sequence>\r\n    </xs:complexType>\r\n  </xs:element>\r\n</xs:schema>";
        ContentModelManagerCacheTest.updateFile(xsdPath, xsd);
        XMLAssert.testCompletionFor(xml, null, xmlPath, 5, XMLAssert.c("label", "<label></label>"));
        XMLAssert.testCompletionFor(xml, null, xmlPath, 5, XMLAssert.c("label", "<label></label>"));
        MoreFiles.deleteRecursively((Path)new File(xsdPath).toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        XMLAssert.testCompletionFor(xml, null, xmlPath, 4, new CompletionItem[0]);
        ContentModelManagerCacheTest.createFile(xsdPath, xsd);
        XMLAssert.testCompletionFor(xml, null, xmlPath, 5, XMLAssert.c("label", "<label></label>"));
        XMLAssert.testCompletionFor(xml, null, xmlPath, 5, XMLAssert.c("label", "<label></label>"));
    }
}

