/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import org.eclipse.lemminx.utils.MarkdownConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MarkdownConverterTest {
    @Test
    public void testHTMLConversion() {
        Assertions.assertEquals((Object)"This is `my code`", (Object)MarkdownConverter.convert((String)"This is <code>my code</code>"));
        Assertions.assertEquals((Object)("This is" + System.lineSeparator() + "**bold**"), (Object)MarkdownConverter.convert((String)"This is<br><b>bold</b>"));
        Assertions.assertEquals((Object)"The `<project>` element is the root of the descriptor.", (Object)MarkdownConverter.convert((String)"The <code>&lt;project&gt;</code> element is the root of the descriptor."));
        Assertions.assertEquals((Object)"# Hey Man #", (Object)MarkdownConverter.convert((String)"<h1>Hey Man</h1>"));
        Assertions.assertEquals((Object)"[Placeholder](https://www.xml.com)", (Object)MarkdownConverter.convert((String)"<a href=\"https://www.xml.com\">Placeholder</a>"));
        String htmlList = "<ul>" + System.lineSeparator() + "  <li>Coffee</li>" + System.lineSeparator() + "  <li>Tea</li>" + System.lineSeparator() + "  <li>Milk</li>" + System.lineSeparator() + "</ul>";
        String expectedList = " *  Coffee" + System.lineSeparator() + " *  Tea" + System.lineSeparator() + " *  Milk";
        Assertions.assertEquals((Object)expectedList, (Object)MarkdownConverter.convert((String)htmlList));
        Assertions.assertEquals((Object)"ONLY_THIS_TEXT", (Object)MarkdownConverter.convert((String)"<p>ONLY_THIS_TEXT</p>"));
        String multilineHTML = "multi" + System.lineSeparator() + "line" + System.lineSeparator() + "<code>HTML</code>" + System.lineSeparator() + "stuff";
        Assertions.assertEquals((Object)"multi line `HTML` stuff", (Object)MarkdownConverter.convert((String)multilineHTML));
        String multilineHTML2 = "<p>multi<p>" + System.lineSeparator() + "line" + System.lineSeparator() + "<code>HTML</code>" + System.lineSeparator() + "stuff";
        String multilineHTML2Expected = "multi" + System.lineSeparator() + "" + System.lineSeparator() + "line `HTML` stuff";
        Assertions.assertEquals((Object)multilineHTML2Expected, (Object)MarkdownConverter.convert((String)multilineHTML2));
    }

    @Test
    public void testMarkdownConversion() {
        Assertions.assertEquals((Object)"This is `my code`", (Object)MarkdownConverter.convert((String)"This is `my code`"));
        Assertions.assertEquals((Object)"The `<thing>` element is the root of the descriptor.", (Object)MarkdownConverter.convert((String)"The `<thing>` element is the root of the descriptor."));
        Assertions.assertEquals((Object)"The `<project>` element is the root of the descriptor.", (Object)MarkdownConverter.convert((String)"The `&lt;project&gt;` element is the root of the descriptor."));
    }
}

