/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.notifier;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.NotificationContentType;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.entities.ScheduleEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.exceptions.Om2mException;
import org.eclipse.om2m.commons.resource.Notification;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.comm.RestClient;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.router.Router;
import org.eclipse.om2m.core.thread.CoreExecutor;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class Notifier {
    private static Log LOGGER = LogFactory.getLog(Notifier.class);

    public static void notify(List<SubscriptionEntity> listSubscription, ResourceEntity resource, int resourceStatus) {
        if (listSubscription != null) {
            for (SubscriptionEntity sub : listSubscription) {
                NotificationWorker worker = new NotificationWorker(sub, resourceStatus, resource);
                CoreExecutor.postThread(worker);
            }
        }
    }

    public static void notifyDeletion(List<SubscriptionEntity> listSubs, ResourceEntity resourceDeleted) {
        List<SubscriptionEntity> parentSubscriptions = Notifier.getParentSubscriptions(resourceDeleted);
        if (parentSubscriptions != null) {
            Notifier.notify(parentSubscriptions, resourceDeleted, 2);
        }
        if (listSubs != null) {
            Notifier.notify(listSubs, resourceDeleted, 4);
        }
    }

    public static void performVerificationRequest(RequestPrimitive request, SubscriptionEntity subscriptionEntity) {
        for (String uri : subscriptionEntity.getNotificationURI()) {
            if (uri.equals(request.getFrom())) continue;
            Notification notification = new Notification();
            notification.setCreator(subscriptionEntity.getCreator());
            notification.setVerificationRequest(Boolean.valueOf(true));
            notification.setSubscriptionReference(subscriptionEntity.getHierarchicalURI());
            notification.setSubscriptionDeletion(Boolean.valueOf(false));
            RequestPrimitive notifRequest = new RequestPrimitive();
            notifRequest.setContent((Object)DataMapperSelector.getDataMapperList().get("application/xml").objToString((Object)notification));
            notifRequest.setFrom("/" + Constants.CSE_ID);
            notifRequest.setTo(uri);
            notifRequest.setOperation(Operation.NOTIFY);
            notifRequest.setRequestContentType("application/xml");
            notifRequest.setReturnContentType("application/xml");
            ResponsePrimitive resp = Notifier.notify(notifRequest, uri);
            if (resp.getResponseStatusCode().equals(ResponseStatusCode.TARGET_NOT_REACHABLE)) {
                throw new Om2mException("Error during the verification request", ResponseStatusCode.SUBSCRIPTION_VERIFICATION_INITIATION_FAILED);
            }
            if (!resp.getResponseStatusCode().equals(ResponseStatusCode.SUBSCRIPTION_CREATOR_HAS_NO_PRIVILEGE) && !resp.getResponseStatusCode().equals(ResponseStatusCode.SUBSCRIPTION_HOST_HAS_NO_PRIVILEGE)) continue;
            throw new Om2mException(resp.getResponseStatusCode());
        }
    }

    public static ResponsePrimitive notify(RequestPrimitive request, String contact) {
        LOGGER.info((Object)("Sending notify request to: " + contact));
        if (contact.matches(".*://.*")) {
            request.setTo(contact);
            return RestClient.sendRequest(request);
        }
        request.setTargetId(contact);
        LOGGER.info((Object)"Sending notify request...");
        return new Router().doRequest(request);
    }

    private static List<SubscriptionEntity> getParentSubscriptions(ResourceEntity resourceDeleted) {
        ArrayList<SubscriptionEntity> result;
        String[] ids = resourceDeleted.getHierarchicalURI().split("/");
        String parentHierarchicalId = resourceDeleted.getHierarchicalURI().replace("/" + ids[ids.length - 1], "");
        String parentId = UriMapper.getNonHierarchicalUri(parentHierarchicalId);
        DBService dbs = PersistenceService.getInstance().getDbService();
        DAO<?> dao = Patterns.getDAO(parentId, dbs);
        DBTransaction transaction = dbs.getDbTransaction();
        transaction.open();
        ResourceEntity parentEntity = (ResourceEntity)dao.find(transaction, (Object)parentId);
        switch (parentEntity.getResourceType().intValue()) {
            case 1: {
                AccessControlPolicyEntity acp = (AccessControlPolicyEntity)parentEntity;
                result = acp.getChildSubscriptions();
                break;
            }
            case 2: {
                AeEntity ae = (AeEntity)parentEntity;
                result = ae.getSubscriptions();
                break;
            }
            case 3: {
                ContainerEntity cnt = (ContainerEntity)parentEntity;
                result = cnt.getSubscriptions();
                break;
            }
            case 5: {
                CSEBaseEntity csb = (CSEBaseEntity)parentEntity;
                result = csb.getSubscriptions();
                break;
            }
            case 9: {
                GroupEntity group = (GroupEntity)parentEntity;
                result = group.getSubscriptions();
                break;
            }
            case 16: {
                RemoteCSEEntity csr = (RemoteCSEEntity)parentEntity;
                result = csr.getSubscriptions();
                break;
            }
            case 18: {
                ScheduleEntity schedule = (ScheduleEntity)parentEntity;
                result = schedule.getSubscriptions();
                break;
            }
            default: {
                result = new ArrayList();
            }
        }
        transaction.close();
        return result;
    }

    static class NotificationWorker
    implements Runnable {
        private int resourceStatus;
        private SubscriptionEntity sub;
        private ResourceEntity resource;

        public NotificationWorker(SubscriptionEntity sub, int resourceStatus, ResourceEntity resource) {
            this.resourceStatus = resourceStatus;
            this.sub = sub;
            this.resource = resource;
        }

        @Override
        public void run() {
            final RequestPrimitive request = new RequestPrimitive();
            Notification notification = new Notification();
            Notification.NotificationEvent notifEvent = new Notification.NotificationEvent();
            notification.setNotificationEvent(notifEvent);
            notifEvent.setResourceStatus(BigInteger.valueOf(this.resourceStatus));
            notification.setCreator(this.sub.getCreator());
            request.setOperation(Operation.NOTIFY);
            request.setFrom("/" + Constants.CSE_ID);
            if (this.resourceStatus == 4) {
                notification.setSubscriptionDeletion(Boolean.valueOf(true));
            } else {
                notification.setSubscriptionDeletion(Boolean.valueOf(false));
            }
            notification.setSubscriptionReference(this.sub.getHierarchicalURI());
            if (this.sub.getNotificationContentType() != null) {
                Object serializableResource;
                EntityMapper mapper = this.resource.getResourceType().equals(13) ? EntityMapperFactory.getMapperForMgmtObj((MgmtObjEntity)this.resource) : EntityMapperFactory.getMapperFromResourceType(this.resource.getResourceType().intValue());
                if (this.sub.getNotificationContentType().equals(NotificationContentType.MODIFIED_ATTRIBUTES)) {
                    serializableResource = mapper.mapEntityToResource(this.resource, ResultContent.ATTRIBUTES);
                    notification.getNotificationEvent().setRepresentation(serializableResource);
                    request.setRequestContentType("application/xml");
                } else if (this.sub.getNotificationContentType().equals(NotificationContentType.WHOLE_RESOURCE)) {
                    serializableResource = mapper.mapEntityToResource(this.resource, ResultContent.ATTRIBUTES);
                    notification.getNotificationEvent().setRepresentation(serializableResource);
                    request.setRequestContentType("application/xml");
                }
            }
            request.setContent((Object)DataMapperSelector.getDataMapperList().get("application/xml").objToString((Object)notification));
            for (final String uri : this.sub.getNotificationURI()) {
                CoreExecutor.postThread(new Runnable(){

                    @Override
                    public void run() {
                        Notifier.notify(request, uri);
                    }
                });
            }
        }
    }
}

