/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.om2m.commons.constants.MgmtDefinitionTypes;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Entity(name="andi")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class AreaNwkDeviceInfoEntity
extends MgmtObjEntity {
    @Column(name="dvd")
    protected String devID;
    @Column(name="dvt")
    protected String devType;
    @Column(name="awi")
    protected String areaNwkId;
    @Column(name="sli")
    protected BigInteger sleepInterval;
    @Column(name="sld")
    protected BigInteger sleepDuration;
    @Column(name="ss")
    protected String status;
    @Column(name="lnh")
    protected List<String> listOfNeighbors;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=AccessControlPolicyEntity.class)
    @JoinTable(name="ANDI_ACP_JOIN", joinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> acps;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=SubscriptionEntity.class)
    @JoinTable(name="ANDI_SUB_JOIN", joinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> subscriptions;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=NodeEntity.class)
    @JoinTable(name="ANDI_NOD_JOIN", joinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")})
    protected NodeEntity parentNode;

    public AreaNwkDeviceInfoEntity() {
        this.mgmtDefinition = MgmtDefinitionTypes.AREA_NWK_DEVICE_INFO;
    }

    public String getDevID() {
        return this.devID;
    }

    public void setDevID(String devID) {
        this.devID = devID;
    }

    public String getDevType() {
        return this.devType;
    }

    public void setDevType(String devType) {
        this.devType = devType;
    }

    public String getAreaNwkId() {
        return this.areaNwkId;
    }

    public void setAreaNwkId(String areaNwkId) {
        this.areaNwkId = areaNwkId;
    }

    public BigInteger getSleepInterval() {
        return this.sleepInterval;
    }

    public void setSleepInterval(BigInteger sleepInterval) {
        this.sleepInterval = sleepInterval;
    }

    public BigInteger getSleepDuration() {
        return this.sleepDuration;
    }

    public void setSleepDuration(BigInteger sleepDuration) {
        this.sleepDuration = sleepDuration;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<String> getListOfNeighbors() {
        if (this.listOfNeighbors == null) {
            this.listOfNeighbors = new ArrayList<String>();
        }
        return this.listOfNeighbors;
    }

    public void setListOfNeighbors(List<String> listOfNeighbors) {
        this.listOfNeighbors = listOfNeighbors;
    }

    public List<SubscriptionEntity> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(List<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public NodeEntity getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(NodeEntity parentNode) {
        this.parentNode = parentNode;
    }

    public List<AccessControlPolicyEntity> getAcps() {
        if (this.acps == null) {
            this.acps = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.acps;
    }

    public void setAcps(List<AccessControlPolicyEntity> acps) {
        this.acps = acps;
    }
}

