/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import org.eclipse.om2m.commons.constants.MimeMediaType;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;

@Entity(name="CIN")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class ContentInstanceEntity
extends AnnounceableSubordinateEntity {
    @Column(name="st", nullable=false)
    protected BigInteger stateTag;
    @Column(name="cr")
    protected String creator;
    @Column(name="cnf")
    protected String contentInfo = "text/plain:" + MimeMediaType.ENCOD_PLAIN;
    @Column(name="cs")
    protected BigInteger contentSize;
    @Column(name="or")
    protected String ontologyRef;
    @Column(name="con", nullable=false)
    @Lob
    protected String content;
    @ManyToOne(fetch=FetchType.EAGER, targetEntity=ContainerEntity.class)
    @JoinTable(name="CNT_CIN_JOIN", inverseJoinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="CINCH_ID", referencedColumnName="ri")})
    protected ContainerEntity parentContainer;

    public BigInteger getStateTag() {
        return this.stateTag;
    }

    public void setStateTag(BigInteger stateTag) {
        this.stateTag = stateTag;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getContentInfo() {
        return this.contentInfo;
    }

    public void setContentInfo(String contentInfo) {
        this.contentInfo = contentInfo;
    }

    public BigInteger getContentSize() {
        return this.contentSize;
    }

    public void setContentSize(BigInteger contentSize) {
        this.contentSize = contentSize;
    }

    public String getOntologyRef() {
        return this.ontologyRef;
    }

    public void setOntologyRef(String ontologyRef) {
        this.ontologyRef = ontologyRef;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ContainerEntity getParentContainer() {
        return this.parentContainer;
    }

    public void setParentContainer(ContainerEntity parentContainer) {
        this.parentContainer = parentContainer;
    }

    public List<AccessControlPolicyEntity> getAcpListFromParent() {
        if (this.getParentContainer() != null) {
            return this.getParentContainer().getAccessControlPolicies();
        }
        return null;
    }

    public int getByteSize() {
        return this.content.getBytes().length;
    }
}

