/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.debug.ui;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class BreakpointsListener
implements IBreakpointsListener {
    private final String ORIGIN_ID = "org.eclipse.debug.ui";
    private final AbstractContextStructureBridge structureBridge = ContextCore.getStructureBridge((String)"breakpoint");

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        this.breakpointsChanged(breakpoints, new IMarkerDelta[breakpoints.length]);
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            IInteractionElement element = ContextCore.getContextManager().getElement(this.structureBridge.getHandleIdentifier((Object)breakpoint));
            if (element != null) {
                ContextCore.getContextManager().deleteElement(element);
            }
            ++n2;
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            IMarkerDelta delta = deltas[i];
            if (delta == null || breakpoint.getMarker().getAttribute("org.eclipse.mylyn.debug.ui.breakpointId", null) == null || delta.getAttribute("org.eclipse.mylyn.debug.ui.breakpointId", null) != null) {
                InteractionEvent editEvent = new InteractionEvent(InteractionEvent.Kind.EDIT, "breakpoint", this.structureBridge.getHandleIdentifier((Object)breakpoint), "org.eclipse.debug.ui");
                ContextCore.getContextManager().processInteractionEvent(editEvent);
            }
            ++i;
        }
    }
}

