/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.UseStatementContext;
import org.eclipse.php.internal.core.codeassist.strategies.ElementsStrategy;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.FakeMethod;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class TypesStrategy
extends ElementsStrategy {
    protected final int trueFlag;
    protected final int falseFlag;
    protected static final IType[] EMPTY = new IType[0];
    private boolean aliasAdded = false;

    public TypesStrategy(ICompletionContext context, int trueFlag, int falseFlag) {
        super(context, null);
        this.trueFlag = trueFlag;
        this.falseFlag = falseFlag;
    }

    public TypesStrategy(ICompletionContext context) {
        this(context, 0, 0);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        IPHPCompletionRequestor phpCompletionRequestor;
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        if (abstractContext.getCompletionRequestor() instanceof IPHPCompletionRequestor && (phpCompletionRequestor = (IPHPCompletionRequestor)abstractContext.getCompletionRequestor()).filter(2)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)abstractContext.getPrefix())) {
            return;
        }
        ISourceRange replacementRange = this.getReplacementRange(abstractContext);
        ISourceRange memberReplacementRange = this.getReplacementRangeForMember(abstractContext);
        String nsUseGroupPrefix = null;
        if (context instanceof UseStatementContext && (nsUseGroupPrefix = ((UseStatementContext)context).getGroupPrefixBeforeOpeningCurly()) != null && nsUseGroupPrefix.startsWith("\\")) {
            nsUseGroupPrefix = nsUseGroupPrefix.substring(1);
        }
        IType[] types = this.getTypes(abstractContext);
        String suffix = "";
        String nsSuffix = this.getNSSuffix(abstractContext);
        int extraInfo = this.getExtraInfo();
        if (abstractContext.isAbsoluteName()) {
            extraInfo |= 8;
            extraInfo |= 0x200;
            extraInfo |= 0x400;
        }
        if (abstractContext.isAbsolute()) {
            extraInfo |= 8;
            extraInfo |= 0x200;
        }
        if (nsUseGroupPrefix != null) {
            extraInfo |= 0x200;
        }
        String namespace = this.getCompanion().getCurrentNamespace();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                int flags = type.getFlags();
                boolean isNamespace = PHPFlags.isNamespace(flags);
                int relevance = this.getRelevance(namespace, (IMember)type);
                if (nsUseGroupPrefix != null) {
                    reporter.reportType(type, nsUseGroupPrefix, isNamespace ? nsSuffix : suffix, isNamespace ? replacementRange : memberReplacementRange, extraInfo, relevance);
                } else {
                    boolean isAbsoluteType;
                    boolean bl = isAbsoluteType = abstractContext.isAbsoluteName() || abstractContext.isAbsolute();
                    if (isNamespace || isAbsoluteType) {
                        reporter.reportType(type, isNamespace ? nsSuffix : suffix, replacementRange, extraInfo | 0x80, relevance);
                    } else {
                        reporter.reportType(type, isNamespace ? nsSuffix : suffix, isNamespace ? replacementRange : memberReplacementRange, extraInfo, relevance);
                    }
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        this.addAlias(reporter, suffix);
    }

    protected void addAlias(ICompletionReporter reporter, String suffix) throws BadLocationException {
        if (this.aliasAdded) {
            return;
        }
        this.aliasAdded = true;
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        if (!abstractContext.getCompletionRequestor().isContextInformationMode()) {
            String prefix = abstractContext.getPrefix();
            boolean exactMatch = false;
            if (prefix.indexOf(92) == 0) {
                return;
            }
            if (prefix.indexOf(92) > 0) {
                prefix = prefix.substring(0, prefix.indexOf(92));
                exactMatch = true;
            }
            if (prefix.indexOf(92) < 0) {
                PHPModuleDeclaration moduleDeclaration = this.getCompanion().getModuleDeclaration();
                int offset = this.getCompanion().getOffset();
                IType namespace = PHPModelUtils.getCurrentNamespace(this.getCompanion().getSourceModule(), offset);
                Map<String, UsePart> result = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, offset, namespace, exactMatch);
                this.reportAlias(reporter, suffix, abstractContext, this.getCompanion().getSourceModule(), result);
            }
        }
    }

    protected void reportAliasForNS(ICompletionReporter reporter, String suffix, AbstractCompletionContext abstractContext, ISourceModule module, Map<String, UsePart> result) throws BadLocationException {
        ISourceRange replacementRange = this.getReplacementRange(abstractContext);
        IDLTKSearchScope scope = this.createSearchScope();
        for (Map.Entry<String, UsePart> entry : result.entrySet()) {
            String fullName = entry.getValue().getFullUseStatementName();
            IType[] elements = PHPModelAccess.getDefault().findTypes(null, String.valueOf(fullName) + '\\', ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null);
            int i = 0;
            while (i < elements.length) {
                String elementName = elements[i].getElementName();
                this.reportAlias(reporter, scope, module, replacementRange, elements[i], elementName, elementName.replace(fullName, entry.getKey()), suffix);
                ++i;
            }
        }
    }

    protected void reportAlias(ICompletionReporter reporter, String suffix, AbstractCompletionContext abstractContext, ISourceModule module, Map<String, UsePart> result) throws BadLocationException {
        ISourceRange replacementRange = this.getReplacementRange(abstractContext);
        String prefix = abstractContext.getPrefix();
        IDLTKSearchScope scope = this.createSearchScope();
        for (Map.Entry<String, UsePart> entry : result.entrySet()) {
            if (entry.getValue().getAlias() == null) continue;
            String name = entry.getKey();
            String fullName = entry.getValue().getFullUseStatementName();
            try {
                IType[] elements = PHPModelAccess.getDefault().findTypes(fullName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
                int i = 0;
                while (i < elements.length) {
                    if (PHPModelUtils.getFullName(elements[i]).equalsIgnoreCase(fullName)) {
                        this.reportAlias(reporter, scope, module, replacementRange, elements[i], elements[i].getElementName(), name, suffix);
                    }
                    ++i;
                }
                IType[] namespaces = PHPModelAccess.getDefault().findNamespaces(null, fullName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
                int i2 = 0;
                while (i2 < namespaces.length) {
                    String elementName = namespaces[i2].getElementName();
                    String nsname = prefix.replace(name, fullName);
                    if (!nsname.startsWith(String.valueOf(elementName) + "\\") || nsname.lastIndexOf("\\") != elementName.length()) {
                        IType[] typesOfNS = namespaces[i2].getTypes();
                        int j = 0;
                        while (j < typesOfNS.length) {
                            this.reportAlias(reporter, scope, module, replacementRange, typesOfNS[j], typesOfNS[j].getElementName(), (String.valueOf(elementName) + "\\" + typesOfNS[j].getElementName()).replace(fullName, name), suffix);
                            ++j;
                        }
                    }
                    ++i2;
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
        }
    }

    protected void reportAlias(ICompletionReporter reporter, IDLTKSearchScope scope, ISourceModule module, ISourceRange replacementRange, IType type, String fullName, String alias, String suffix) {
        reporter.reportType((IType)new AliasType((ModelElement)type, fullName, alias), suffix, replacementRange, this.getExtraInfo());
    }

    protected IType[] getTypes(AbstractCompletionContext context) throws BadLocationException {
        IType[] namespaces;
        IType[] types;
        String prefix = context.getPrefix();
        if (prefix.startsWith("$")) {
            return EMPTY;
        }
        IDLTKSearchScope scope = this.createSearchScope();
        if (context.getCompletionRequestor().isContextInformationMode()) {
            return PHPModelAccess.getDefault().findTypes(context.getQualifier(true), context.getMemberName(), ISearchEngine.MatchRule.EXACT, this.trueFlag, this.falseFlag, scope, null);
        }
        LinkedList<IType> result = new LinkedList<IType>();
        String memberName = context.getMemberName();
        String namespaceName = context.getQualifier(false);
        boolean isAbsoluteType = context.isAbsoluteName() || context.isAbsolute();
        StringBuilder sb = new StringBuilder();
        String altNamespacePrefix = null;
        if (namespaceName != null) {
            sb.append(namespaceName).append('\\');
        } else if (!isAbsoluteType && this.getCompanion().getCurrentNamespace() != null && this.useCurrentNamespace) {
            altNamespacePrefix = this.getCompanion().getCurrentNamespace() + '\\' + memberName;
        }
        String namespacePrefix = sb.append(memberName).toString();
        if (memberName.length() > 1 && memberName.toUpperCase().equals(memberName)) {
            types = PHPModelAccess.getDefault().findTypes(context.getQualifier(true), memberName, ISearchEngine.MatchRule.CAMEL_CASE, this.trueFlag, this.falseFlag, scope, null);
            result.addAll(Arrays.asList(types));
            if (((this.falseFlag & 0x800) == 0 || isAbsoluteType || namespaceName != null) && namespacePrefix.length() > 0) {
                namespaces = PHPModelAccess.getDefault().findNamespaces(null, namespacePrefix.toString(), ISearchEngine.MatchRule.CAMEL_CASE, this.trueFlag, 0, scope, null);
                result.addAll(CodeAssistUtils.removeDuplicatedElements((IModelElement[])namespaces));
            }
        }
        types = PHPModelAccess.getDefault().findTraitOrTypes(context.getQualifier(true), memberName, ISearchEngine.MatchRule.PREFIX, this.trueFlag, this.falseFlag, scope, null);
        result.addAll(Arrays.asList(types));
        if ((this.falseFlag & 0x800) == 0 || isAbsoluteType || namespaceName != null || altNamespacePrefix != null) {
            if (namespacePrefix.length() > 0) {
                namespaces = PHPModelAccess.getDefault().findNamespaces(null, namespacePrefix, ISearchEngine.MatchRule.PREFIX, this.trueFlag, 0, scope, null);
                result.addAll(CodeAssistUtils.removeDuplicatedElements((IModelElement[])namespaces));
            }
            if (altNamespacePrefix != null) {
                namespaces = PHPModelAccess.getDefault().findNamespaces(null, altNamespacePrefix, ISearchEngine.MatchRule.PREFIX, this.trueFlag, 0, scope, null);
                result.addAll(CodeAssistUtils.removeDuplicatedElements((IModelElement[])namespaces));
            }
        }
        return result.toArray(new IType[result.size()]);
    }

    protected void addSelf(AbstractCompletionContext context, ICompletionReporter reporter) throws BadLocationException {
        String prefix = context.getPrefix();
        ISourceRange replaceRange = this.getReplacementRange(context);
        if (StringUtils.startsWithIgnoreCase((CharSequence)"self", (CharSequence)prefix) && (!context.getCompletionRequestor().isContextInformationMode() || prefix.length() == 4)) {
            String suffix = this.getSuffix(context);
            IType selfClassData = CodeAssistUtils.getSelfClassData(this.getCompanion().getSourceModule(), this.getCompanion().getOffset());
            if (selfClassData != null) {
                try {
                    IMethod ctor = null;
                    IMethod[] iMethodArray = selfClassData.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        if (method.isConstructor()) {
                            ctor = method;
                            break;
                        }
                        ++n2;
                    }
                    if (ctor != null) {
                        sourceRange = selfClassData.getSourceRange();
                        FakeMethod ctorMethod = new FakeMethod((ModelElement)selfClassData, "self", sourceRange.getOffset(), sourceRange.getLength(), sourceRange.getOffset(), sourceRange.getLength()){

                            @Override
                            public boolean isConstructor() throws ModelException {
                                return true;
                            }
                        };
                        ctorMethod.setParameters(ctor.getParameters());
                        reporter.reportMethod((IMethod)ctorMethod, suffix, replaceRange, 8);
                    } else {
                        sourceRange = selfClassData.getSourceRange();
                        reporter.reportMethod((IMethod)new FakeMethod((ModelElement)selfClassData, "self", sourceRange.getOffset(), sourceRange.getLength(), sourceRange.getOffset(), sourceRange.getLength()), "()", replaceRange, 8);
                    }
                }
                catch (ModelException e) {
                    PHPCorePlugin.log(e);
                }
            }
        }
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "::".equals(nextWord) ? "" : "::";
    }

    protected int getExtraInfo() {
        return 1;
    }
}

