/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.parsers.data;

import java.util.ArrayDeque;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.titan.log.viewer.views.details.TreeLeaf;
import org.eclipse.titan.log.viewer.views.details.TreeObject;
import org.eclipse.titan.log.viewer.views.details.TreeParent;

public class TreeModel {
    private String value;
    private TreeParent invisibleRoot = new TreeParent("");

    public void inputChanged(String message) {
        if (message == null || message.length() == 0) {
            this.value = "";
            this.buildEmptyTree();
            return;
        }
        String newValue = message;
        this.value = newValue.length() >= 2 && newValue.startsWith(": ") ? newValue.substring(2) : newValue;
        this.buildTreeModel("Root node name");
    }

    private void buildEmptyTree() {
        this.invisibleRoot = new TreeParent("");
    }

    private void buildTreeModel(String namePort) {
        String logString = this.value;
        StringTokenizer tokenizer = new StringTokenizer(logString, "{},", true);
        ArrayDeque<TreeParent> parentStack = new ArrayDeque<TreeParent>();
        TreeParent root = new TreeParent(namePort);
        parentStack.add(root);
        if (!logString.startsWith("{")) {
            root.addChild(new TreeObject(logString.trim()));
        } else {
            String token = "";
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken().trim();
                if (",".equals(token) || "".equals(token) || "{".equals(token)) continue;
                if (token.endsWith("}")) {
                    if (parentStack.isEmpty()) continue;
                    TreeParent tmpParent = (TreeParent)parentStack.peek();
                    parentStack.pop();
                    if (!parentStack.isEmpty()) {
                        ((TreeParent)parentStack.peek()).addChild(tmpParent);
                        continue;
                    }
                    root.addChild(tmpParent);
                    continue;
                }
                if (!token.endsWith(":=")) {
                    String[] arr = token.split(":=");
                    if (arr.length == 2 && !parentStack.isEmpty()) {
                        ((TreeParent)parentStack.peek()).addChild(new TreeLeaf(arr[0].trim(), arr[1].trim()));
                        continue;
                    }
                    root.addChild(new TreeObject(token));
                    continue;
                }
                parentStack.push(new TreeParent(token.substring(0, token.length() - ":=".length()).trim()));
            }
        }
        this.invisibleRoot = new TreeParent("");
        this.invisibleRoot.addChild(root);
        parentStack.clear();
    }

    public String getFieldValue(List<String> qualifiedName) {
        return this.getFieldValue(this.invisibleRoot.getChild("Root node name"), qualifiedName, 0);
    }

    private String getFieldValue(TreeObject tree, List<String> qualifiedName, int idx) {
        if (qualifiedName == null || qualifiedName.isEmpty()) {
            return null;
        }
        if (tree instanceof TreeParent) {
            if (idx >= qualifiedName.size()) {
                return null;
            }
            TreeParent parent = (TreeParent)tree;
            TreeObject child = parent.getChild(qualifiedName.get(idx));
            if (child == null) {
                return null;
            }
            return this.getFieldValue(child, qualifiedName, idx + 1);
        }
        if (tree instanceof TreeLeaf) {
            if (idx != qualifiedName.size()) {
                return null;
            }
            return ((TreeLeaf)tree).getValue();
        }
        return null;
    }

    public String print() {
        return this.invisibleRoot.toString();
    }
}

