/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences.pages;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.preferences.fieldeditors.StringListEditor;
import org.eclipse.titan.log.viewer.preferences.pages.LogViewerPreferenceRootPage;
import org.eclipse.titan.log.viewer.utils.ImportExportUtils;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.ui.IWorkbench;

public class ComponentsVisualOrderPrefPage
extends LogViewerPreferenceRootPage {
    private StringListEditor compVisOrderEditor;

    public ComponentsVisualOrderPrefPage() {
        super(1, false);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("VisualComponentsOrderPrefPage.0"));
    }

    @Override
    public void createFieldEditors() {
        this.compVisOrderEditor = new StringListEditor("org.eclipse.titan.log.viewer_component_order_id", "", this.getFieldEditorParent(), true);
        this.compVisOrderEditor.setPreferenceStore(this.getPreferenceStore());
        this.addField(this.compVisOrderEditor);
    }

    public void init(IWorkbench workbench) {
    }

    @Override
    protected String getPageId() {
        return "org.eclipse.titan.log.viewer.properties.CompVisOrderPage";
    }

    private Map<String, String> getCurrentPreferences() {
        String[] elements;
        HashMap<String, String> currentPrefs = new HashMap<String, String>();
        String signalFilter = "";
        for (String element : elements = this.compVisOrderEditor.getElements()) {
            signalFilter = signalFilter.concat(element + ";");
        }
        currentPrefs.put(this.compVisOrderEditor.getPreferenceName(), signalFilter);
        return currentPrefs;
    }

    private Map<String, String[]> getCurrentPreferencesSeparated() {
        HashMap<String, String[]> currentPrefs = new HashMap<String, String[]>();
        currentPrefs.put(this.compVisOrderEditor.getPreferenceName(), this.compVisOrderEditor.getElements());
        return currentPrefs;
    }

    @Override
    protected void exportPreferences() {
        ImportExportUtils.exportSettings(this.getPageId(), this.getCurrentPreferencesSeparated(), true);
    }

    @Override
    protected void importPreferences() {
        Map<String, String> prop = ImportExportUtils.importSettings("org.eclipse.titan.log.viewer.properties.CompVisOrderPage");
        if (prop == null) {
            return;
        }
        String propertyValues = prop.get("org.eclipse.titan.log.viewer_component_order_id");
        if (propertyValues == null) {
            return;
        }
        boolean sutFound = false;
        boolean mtcFound = false;
        String[] propertyValuesSeparated = propertyValues.split(File.pathSeparator);
        for (int i = 0; !(i >= propertyValuesSeparated.length || sutFound && mtcFound); ++i) {
            String currValue = propertyValuesSeparated[i];
            if (currValue.contentEquals("System Under Test")) {
                sutFound = true;
                continue;
            }
            if (!currValue.contentEquals("Main Test Component")) continue;
            mtcFound = true;
        }
        if (!sutFound) {
            TitanLogExceptionHandler.handleException(new UserException(Messages.getString("ComponentsVisualOrderPrefPage.0")));
        } else if (!mtcFound) {
            TitanLogExceptionHandler.handleException(new UserException(Messages.getString("ComponentsVisualOrderPrefPage.1")));
        } else {
            this.setOldPreferences(this.getCurrentPreferences());
            this.setProperties(prop);
            this.getApplyButton().setEnabled(true);
        }
    }

    @Override
    protected void updatePage() {
        this.compVisOrderEditor.clear();
        this.compVisOrderEditor.load();
    }

    public void clearList() {
        this.compVisOrderEditor.clear();
        this.getApplyButton().setEnabled(true);
    }

    public void addComponent(String componentName) {
        this.compVisOrderEditor.addElementToList(componentName);
        this.getApplyButton().setEnabled(true);
    }
}

