/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

public final class Identifier_Internal_Data {
    public static final String INVALID_STRING = "<invalid>";
    private final String name;
    private String asnName;
    private String ttcnName;
    private int asnKind;
    private static final int ASN_UNDEF = 0;
    private static final int ASN_LOWER = 1;
    private static final int ASN_UPPER = 2;
    private static final int ASN_ALLUPPER = 3;
    private static final int ASN_WORD = 4;
    private static final int ASN_AMPUPPER = 5;
    private static final int ASN_AMPLOWER = 6;

    public Identifier_Internal_Data(String name, String asnName, String ttcnName) {
        this.name = name;
        this.asnName = name.equals(asnName) ? name : asnName;
        this.ttcnName = name.equals(ttcnName) ? name : ttcnName;
        this.asnKind = 0;
    }

    public static String asnToName(String from) {
        StringBuilder builder = new StringBuilder(from);
        if (builder.length() > 0 && '@' == builder.charAt(0)) {
            builder.replace(0, 1, "_root_");
        }
        int index = 0;
        int index2 = 0;
        while (index2 != -1 && index != -1) {
            if ((index = builder.indexOf(".<", index)) == -1 || (index2 = builder.indexOf(">.", index)) == -1) continue;
            builder.replace(index, index2 + 1, "");
        }
        index = builder.indexOf("-", 0);
        while (index != -1) {
            builder.replace(index, index + 1, "__");
            index += 2;
            index = builder.indexOf("-", index);
        }
        index = builder.indexOf(".", 0);
        while (index != -1) {
            builder.replace(index, index + 1, "_");
            ++index;
            index = builder.indexOf(".", index);
        }
        index = builder.indexOf("&", 0);
        while (index != -1) {
            builder.replace(index, index + 1, "");
            index = builder.indexOf("&", index);
        }
        String result = builder.toString();
        if (result.equals(from)) {
            return from;
        }
        return builder.toString();
    }

    public static String nameToAsn(String from) {
        int index;
        StringBuilder builder = new StringBuilder(from);
        for (index = 0; index < builder.length() && '_' == builder.charAt(index); ++index) {
        }
        if (index > 0) {
            builder.delete(0, index);
        }
        for (index = builder.length(); index > 0 && '_' == builder.charAt(index - 1); --index) {
        }
        if (index != builder.length()) {
            builder.delete(index, builder.length());
        }
        index = builder.indexOf("__", 0);
        while (index != -1) {
            builder.replace(index, index + 2, "-");
            ++index;
            index = builder.indexOf("__", index);
        }
        index = builder.indexOf("_", 0);
        while (index != -1) {
            builder.replace(index, index + 1, "-");
            ++index;
            index = builder.indexOf("_", index);
        }
        String result = builder.toString();
        if (result.equals(from)) {
            return from;
        }
        return builder.toString();
    }

    public static String ttcnToName(String from) {
        StringBuilder builder = new StringBuilder(from);
        int index = builder.indexOf("_", 0);
        while (index != -1) {
            builder.replace(index, index + 1, "__");
            index += 2;
            index = builder.indexOf("_", index);
        }
        String result = builder.toString();
        if (result.equals(from)) {
            return from;
        }
        return builder.toString();
    }

    public static String nameToTtcn(String from) {
        int index;
        StringBuilder builder = new StringBuilder(from);
        for (index = 0; index < builder.length() && '_' == builder.charAt(index); ++index) {
        }
        if (index > 0) {
            builder.delete(0, index);
        }
        for (index = builder.length(); index > 0 && '_' == builder.charAt(index - 1); --index) {
        }
        if (index != builder.length()) {
            builder.delete(index, builder.length());
        }
        index = builder.indexOf("__", 0);
        while (index != -1) {
            builder.deleteCharAt(index);
            index = builder.indexOf("__", index);
        }
        String result = builder.toString();
        if (result.equals(from)) {
            return from;
        }
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getAsnName() {
        if (this.asnName == null) {
            String temp = Identifier_Internal_Data.nameToAsn(this.name);
            this.asnName = this.name.equals(temp) ? this.name : temp;
        }
        return this.asnName;
    }

    public String getTtcnName() {
        if (this.ttcnName == null) {
            String temp = Identifier_Internal_Data.nameToTtcn(this.name);
            this.ttcnName = this.name.equals(temp) ? this.name : temp;
        }
        return this.ttcnName;
    }

    private void decideAsnKind() {
        if (this.asnKind != 0) {
            return;
        }
        if (INVALID_STRING.equals(this.asnName)) {
            return;
        }
        if (this.asnName.charAt(0) == '&') {
            if (this.asnName.length() > 2) {
                if (Character.isUpperCase(this.asnName.charAt(1))) {
                    this.asnKind = 5;
                } else if (Character.isLowerCase(this.asnName.charAt(1))) {
                    this.asnKind = 6;
                }
            }
        } else if (Character.isLowerCase(this.asnName.charAt(0))) {
            this.asnKind = 1;
        } else if (Character.isUpperCase(this.asnName.charAt(0))) {
            this.asnKind = 2;
            boolean hasLower = false;
            boolean hasDigit = false;
            for (int i = 0; i < this.asnName.length(); ++i) {
                if (Character.isLowerCase(this.asnName.charAt(i))) {
                    hasLower = true;
                    continue;
                }
                if (!Character.isDigit(this.asnName.charAt(i))) continue;
                hasDigit = true;
            }
            if (!hasLower) {
                this.asnKind = 3;
                if (!hasDigit) {
                    this.asnKind = 4;
                }
            }
        }
    }

    public boolean isvalidAsnTyperef() {
        this.decideAsnKind();
        return this.asnKind == 2 || this.asnKind == 3 || this.asnKind == 4;
    }

    public boolean isvalidAsnValueReference() {
        this.decideAsnKind();
        return this.asnKind == 1;
    }

    public boolean isvalidAsnObjectClassReference() {
        this.decideAsnKind();
        return this.asnKind == 3 || this.asnKind == 4;
    }

    public boolean isvalidAsnObjectReference() {
        this.decideAsnKind();
        return this.asnKind == 1;
    }

    public boolean isvalidAsnValueFieldReference() {
        this.decideAsnKind();
        return this.asnKind == 6;
    }

    public boolean isvalidAsnObjectFieldReference() {
        this.decideAsnKind();
        return this.asnKind == 6;
    }

    public boolean isvalidAsnObjectSetFieldReference() {
        this.decideAsnKind();
        return this.asnKind == 5;
    }

    public boolean isvalidAsnWord() {
        this.decideAsnKind();
        return this.asnKind == 4;
    }
}

